/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.navigator.ResourceNavigator;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.wst.common.ui.internal.viewers.ResourceFilter;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.properties.BasePropertySource;
import org.eclipse.wst.xsd.ui.internal.wizards.XSDSelectIncludeFileWizard;
import org.eclipse.xsd.XSDSchema;

public abstract class SchemaDirectiveHelperPropertySource
extends BasePropertySource {
    protected IFile currentIFile;
    IFile selectedIFile;
    String selectedNamespace;
    XSDSchema selectedXSDSchema;
    boolean isInclude;

    public SchemaDirectiveHelperPropertySource(boolean isInclude) {
        this.isInclude = isInclude;
    }

    public SchemaDirectiveHelperPropertySource(Viewer viewer, XSDSchema xsdSchema, boolean isInclude) {
        super(viewer, xsdSchema);
        this.isInclude = isInclude;
    }

    public SchemaDirectiveHelperPropertySource(XSDSchema xsdSchema, boolean isInclude) {
        super(xsdSchema);
        this.isInclude = isInclude;
    }

    public IFile getSelectedIFile() {
        return this.selectedIFile;
    }

    public String getSelectedNamespace() {
        return this.selectedNamespace;
    }

    public XSDSchema getSelectedXSDSchema() {
        return this.selectedXSDSchema;
    }

    public class SchemaLocationPropertyDescriptor
    extends PropertyDescriptor {
        public SchemaLocationPropertyDescriptor(Object id, String displayName) {
            super(id, displayName);
        }

        public CellEditor createPropertyEditor(Composite parent) {
            SchemaLocationDialogCellEditor editor = new SchemaLocationDialogCellEditor(parent);
            if (this.getValidator() != null) {
                editor.setValidator(this.getValidator());
            }
            return editor;
        }
    }

    public class SchemaLocationDialogCellEditor
    extends DialogCellEditor {
        protected SchemaLocationDialogCellEditor(Composite parent) {
            super(parent);
        }

        protected Object openDialogBox(Control cellEditorWindow) {
            Shell shell = Display.getCurrent().getActiveShell();
            ResourceFilter filter = new ResourceFilter(new String[]{".xsd"}, new IFile[]{SchemaDirectiveHelperPropertySource.this.currentIFile}, null);
            IViewPart[] viewParts = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViews();
            ResourceNavigator resourceNav = null;
            int i = 0;
            while (i < viewParts.length) {
                if (viewParts[i] instanceof ResourceNavigator) {
                    resourceNav = (ResourceNavigator)viewParts[i];
                    break;
                }
                ++i;
            }
            StructuredSelection selection = StructuredSelection.EMPTY;
            if (resourceNav != null) {
                selection = (IStructuredSelection)resourceNav.getViewSite().getSelectionProvider().getSelection();
            }
            XSDSelectIncludeFileWizard fileSelectWizard = new XSDSelectIncludeFileWizard(SchemaDirectiveHelperPropertySource.this.xsdSchema, SchemaDirectiveHelperPropertySource.this.isInclude, XSDEditorPlugin.getXSDString("_UI_FILEDIALOG_SELECT_XML_SCHEMA"), XSDEditorPlugin.getXSDString("_UI_FILEDIALOG_SELECT_XML_DESC"), (ViewerFilter)filter, (IStructuredSelection)selection);
            WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)fileSelectWizard);
            wizardDialog.create();
            wizardDialog.setBlockOnOpen(true);
            int result = wizardDialog.open();
            String value = (String)this.getValue();
            if (result == 0) {
                SchemaDirectiveHelperPropertySource.this.selectedIFile = fileSelectWizard.getResultFile();
                String schemaFileString = value;
                schemaFileString = SchemaDirectiveHelperPropertySource.this.selectedIFile != null ? URIHelper.getRelativeURI((IPath)SchemaDirectiveHelperPropertySource.this.selectedIFile.getLocation(), (IPath)SchemaDirectiveHelperPropertySource.this.currentIFile.getLocation()) : fileSelectWizard.getURL();
                SchemaDirectiveHelperPropertySource.this.selectedNamespace = fileSelectWizard.getNamespace();
                SchemaDirectiveHelperPropertySource.this.selectedXSDSchema = fileSelectWizard.getExternalSchema();
                return schemaFileString;
            }
            return value;
        }
    }
}

