/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.actions;

import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.commands.MakeAnonymousTypeGlobalCommand;
import org.eclipse.wst.xsd.ui.internal.refactor.RefactoringMessages;
import org.eclipse.wst.xsd.ui.internal.refactor.actions.SelectionDispatchAction;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.RenameRefactoringWizard;
import org.eclipse.wst.xsd.ui.internal.refactor.structure.MakeTypeGlobalProcessor;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Node;

public class MakeAnonymousTypeGlobalAction
extends SelectionDispatchAction {
    private String fParentName;
    private boolean isComplexType = true;
    private XSDTypeDefinition fSelectedComponent;

    public MakeAnonymousTypeGlobalAction(ISelectionProvider selectionProvider, XSDSchema schema) {
        super(selectionProvider);
        this.setText(XSDEditorPlugin.getXSDString("_UI_ACTION_MAKE_ANONYMOUS_TYPE_GLOBAL"));
        this.setSchema(schema);
    }

    public boolean canRun() {
        return this.fSelectedComponent != null;
    }

    private String getNewDefaultName() {
        if (this.fParentName != null && !"".equals(this.fParentName)) {
            if (this.isComplexType) {
                return String.valueOf(this.fParentName) + "ComplexType";
            }
            return String.valueOf(this.fParentName) + "SimpleType";
        }
        if (this.isComplexType) {
            return "NewComplexType";
        }
        return "NewSimpleType";
    }

    private boolean canEnable(XSDConcreteComponent xsdComponent) {
        if (xsdComponent instanceof XSDComplexTypeDefinition) {
            this.fSelectedComponent = (XSDComplexTypeDefinition)xsdComponent;
            this.isComplexType = true;
            XSDComplexTypeDefinition typeDef = (XSDComplexTypeDefinition)xsdComponent;
            XSDConcreteComponent parent = typeDef.getContainer();
            if (parent instanceof XSDElementDeclaration) {
                this.fParentName = ((XSDElementDeclaration)parent).getName();
                return true;
            }
        } else if (xsdComponent instanceof XSDSimpleTypeDefinition) {
            this.fSelectedComponent = (XSDSimpleTypeDefinition)xsdComponent;
            this.isComplexType = false;
            XSDSimpleTypeDefinition typeDef = (XSDSimpleTypeDefinition)xsdComponent;
            XSDConcreteComponent parent = typeDef.getContainer();
            if (parent instanceof XSDElementDeclaration) {
                this.fParentName = ((XSDElementDeclaration)parent).getName();
                return true;
            }
            if (parent instanceof XSDAttributeDeclaration) {
                this.fParentName = ((XSDAttributeDeclaration)parent).getName();
                return true;
            }
        }
        return false;
    }

    protected boolean canEnable(Object selectedObject) {
        if (selectedObject instanceof XSDConcreteComponent) {
            return this.canEnable((XSDConcreteComponent)selectedObject);
        }
        if (selectedObject instanceof Node) {
            Node node = (Node)selectedObject;
            XSDConcreteComponent concreteComponent = this.getSchema().getCorrespondingComponent(node);
            return this.canEnable(concreteComponent);
        }
        return false;
    }

    public void run1() {
        if (this.fSelectedComponent == null) {
            return;
        }
        if (this.fSelectedComponent.getSchema() == null) {
            this.getSchema().updateElement(true);
        }
        MakeTypeGlobalProcessor processor = new MakeTypeGlobalProcessor(this.fSelectedComponent, this.getNewDefaultName());
        RenameRefactoring refactoring = new RenameRefactoring((RenameProcessor)processor);
        try {
            RenameRefactoringWizard wizard = new RenameRefactoringWizard((Refactoring)refactoring, RefactoringMessages.getString("RenameComponentWizard.defaultPageTitle"), RefactoringMessages.getString("RenameComponentWizard.inputPage.description"), null);
            RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
            op.run(XSDEditorPlugin.getShell(), wizard.getDefaultPageTitle());
            op.getInitialConditionCheckingStatus();
        }
        catch (InterruptedException interruptedException) {}
    }

    public void run() {
        if (this.fSelectedComponent == null) {
            return;
        }
        if (this.fSelectedComponent.getSchema() == null) {
            this.getSchema().updateElement(true);
        }
        DocumentImpl doc = (DocumentImpl)this.fSelectedComponent.getElement().getOwnerDocument();
        doc.getModel().beginRecording((Object)this, XSDEditorPlugin.getXSDString("_UI_ACTION_MAKE_ANONYMOUS_TYPE_GLOBAL"));
        MakeAnonymousTypeGlobalCommand command = new MakeAnonymousTypeGlobalCommand((XSDConcreteComponent)this.fSelectedComponent, this.getNewDefaultName());
        command.run();
        doc.getModel().endRecording((Object)this);
    }
}

