/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.IHelpActivitySupport;
import org.eclipse.help.internal.base.util.IErrorUtil;
import org.eclipse.help.ui.internal.HelpActivitySupport;
import org.eclipse.help.ui.internal.util.ErrorUtil;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class HelpUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.help.ui";
    public static boolean DEBUG = false;
    public static boolean DEBUG_INFOPOP = false;
    private static HelpUIPlugin plugin;

    public static synchronized void logError(String message, Throwable ex) {
        HelpUIPlugin.logError(message, ex, true, false);
    }

    public static synchronized void logError(String message, Throwable ex, boolean log, boolean openDialog) {
        if (message == null) {
            message = "";
        }
        Status errorStatus = new Status(4, PLUGIN_ID, 0, message, ex);
        HelpPlugin.getDefault().getLog().log((IStatus)errorStatus);
        if (openDialog) {
            ErrorDialog.openError(null, null, null, (IStatus)errorStatus);
        }
    }

    public static synchronized void logWarning(String message) {
        if (HelpPlugin.DEBUG) {
            if (message == null) {
                message = "";
            }
            Status warningStatus = new Status(2, PLUGIN_ID, 0, message, null);
            HelpPlugin.getDefault().getLog().log((IStatus)warningStatus);
        }
    }

    public static HelpUIPlugin getDefault() {
        return plugin;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        Platform.getJobManager().cancel((Object)"org.eclipse.help.base.indexer");
        super.stop(context);
    }

    public void start(BundleContext context) throws Exception {
        IWorkbench workbench;
        super.start(context);
        plugin = this;
        DEBUG = this.isDebugging();
        if (DEBUG) {
            DEBUG_INFOPOP = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.help.ui/debug/infopop"));
        }
        if (BaseHelpSystem.getMode() == 0) {
            BaseHelpSystem.setDefaultErrorUtil((IErrorUtil)new ErrorUtil());
        }
        if (BaseHelpSystem.getMode() == 0 && (workbench = PlatformUI.getWorkbench()) != null) {
            HelpBasePlugin.setActivitySupport((IHelpActivitySupport)new HelpActivitySupport(workbench));
        }
    }
}

