/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.contentmodel;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Stack;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.contentmodel.ITaglibRecord;
import org.eclipse.jst.jsp.core.internal.contentmodel.ITaglibRecordEvent;
import org.eclipse.jst.jsp.core.internal.contentmodel.JarRecord;
import org.eclipse.jst.jsp.core.internal.contentmodel.ServletRecord;
import org.eclipse.jst.jsp.core.internal.contentmodel.TLDRecord;
import org.eclipse.jst.jsp.core.internal.contentmodel.TagDirRecord;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibIndex;
import org.eclipse.jst.jsp.core.internal.contentmodel.URLRecord;
import org.eclipse.jst.jsp.core.internal.util.DocumentProvider;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.sse.core.internal.util.JarUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ProjectDescription {
    static boolean _debugIndexCreation = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/taglib/indexcreation"));
    static boolean _debugIndexTime = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/taglib/indextime"));
    private static final String WEB_INF = "WEB-INF";
    private static final IPath WEB_INF_PATH = new Path("WEB-INF");
    private static final String WEB_XML = "web.xml";
    Hashtable fClasspathJars;
    Stack fClasspathProjects = null;
    Hashtable fClasspathReferences;
    Hashtable fImplicitReferences;
    Hashtable fJARReferences;
    IProject fProject;
    Hashtable fServletReferences;
    Hashtable fTagDirReferences;
    Hashtable fTLDReferences;
    IResourceDeltaVisitor fVisitor;
    private long time0;

    ProjectDescription(IProject project) {
        this.fProject = project;
        this.fClasspathReferences = new Hashtable(0);
        this.fClasspathJars = new Hashtable(0);
        this.fJARReferences = new Hashtable(0);
        this.fTagDirReferences = new Hashtable(0);
        this.fTLDReferences = new Hashtable(0);
        this.fServletReferences = new Hashtable(0);
        this.fImplicitReferences = new Hashtable(0);
    }

    void updateClasspathLibrary(String libraryLocation, int deltaKind) {
        String[] entries = JarUtilities.getEntryNames((String)libraryLocation);
        JarRecord libraryRecord = (JarRecord)this.createJARRecord(libraryLocation);
        this.fClasspathJars.put(libraryLocation, libraryRecord);
        int i = 0;
        while (i < entries.length) {
            InputStream contents;
            if (entries[i].endsWith(".tld") && (contents = JarUtilities.getInputStream((String)libraryLocation, (String)entries[i])) != null) {
                String uri = this.extractURI(libraryLocation, contents);
                if (uri != null && uri.length() > 0) {
                    URLRecord record = new URLRecord();
                    record.uri = uri;
                    record.baseLocation = libraryLocation;
                    try {
                        record.url = new URL("jar:file:" + libraryLocation + "!/" + entries[i]);
                        libraryRecord.urlRecords.add(record);
                        this.fClasspathReferences.put(uri, record);
                        if (_debugIndexCreation) {
                            System.out.println("created record for " + uri + "@" + record.getURL());
                        }
                    }
                    catch (MalformedURLException e) {
                        Logger.logException(e);
                    }
                }
                try {
                    contents.close();
                }
                catch (IOException iOException) {}
            }
            ++i;
        }
        TaglibIndex.fireTaglibRecordEvent(new TaglibRecordEvent(libraryRecord, deltaKind));
    }

    void updateJAR(IResource jar, int deltaKind) {
        if (_debugIndexCreation) {
            System.out.println("creating records for JAR " + jar.getFullPath());
        }
        String jarLocationString = jar.getLocation().toString();
        String[] entries = JarUtilities.getEntryNames((IResource)jar);
        JarRecord jarRecord = (JarRecord)this.createJARRecord(jar);
        this.fJARReferences.put(jar.getFullPath().toString(), jarRecord);
        int i = 0;
        while (i < entries.length) {
            InputStream contents;
            if (entries[i].endsWith(".tld") && (contents = JarUtilities.getInputStream((IResource)jar, (String)entries[i])) != null) {
                String uri = this.extractURI(jarLocationString, contents);
                if (uri != null && uri.length() > 0) {
                    URLRecord record = new URLRecord();
                    record.uri = uri;
                    record.baseLocation = jarLocationString;
                    try {
                        record.url = new URL("jar:file:" + jarLocationString + "!/" + entries[i]);
                        jarRecord.urlRecords.add(record);
                        this.getImplicitReferences(jarLocationString).put(uri, record);
                        if (_debugIndexCreation) {
                            System.out.println("created record for " + uri + "@" + record.getURL());
                        }
                    }
                    catch (MalformedURLException e) {
                        Logger.logException(e);
                    }
                }
                try {
                    contents.close();
                }
                catch (IOException iOException) {}
            }
            ++i;
        }
        TaglibIndex.fireTaglibRecordEvent(new TaglibRecordEvent(jarRecord, deltaKind));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void updateServlets(IResource webxml, int deltaKind) {
        Document document;
        block14: {
            if (webxml.getType() != 1) {
                return;
            }
            InputStream webxmlContents = null;
            document = null;
            try {
                try {
                    webxmlContents = ((IFile)webxml).getContents(true);
                    DocumentProvider provider = new DocumentProvider();
                    provider.setInputStream(webxmlContents);
                    provider.setValidating(false);
                    provider.setBaseReference(webxml.getParent().getLocation().toString());
                    document = provider.getDocument();
                }
                catch (CoreException e) {
                    Logger.logException(e);
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                if (webxmlContents == null) throw throwable;
                try {
                    webxmlContents.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var6_10 = null;
                if (webxmlContents == null) break block14;
            }
            try {}
            catch (IOException iOException) {}
            webxmlContents.close();
        }
        if (document == null) {
            return;
        }
        if (_debugIndexCreation) {
            System.out.println("creating records for " + webxml.getFullPath());
        }
        ServletRecord servletRecord = new ServletRecord();
        servletRecord.location = webxml.getLocation();
        this.fServletReferences.put(servletRecord.getWebXML().toString(), servletRecord);
        NodeList taglibs = document.getElementsByTagName("taglib");
        int i = 0;
        while (true) {
            if (i >= taglibs.getLength()) {
                TaglibIndex.fireTaglibRecordEvent(new TaglibRecordEvent(servletRecord, deltaKind));
                return;
            }
            String uri = this.readTextofChild(taglibs.item(i), "taglib-uri").trim();
            String location = this.readTextofChild(taglibs.item(i), "taglib-location").trim();
            TLDRecord record = new TLDRecord();
            record.uri = uri;
            record.location = location.startsWith("/") ? ResourcesPlugin.getWorkspace().getRoot().getLocation().append(String.valueOf(this.getLocalRoot(webxml.getLocation().toString())) + location) : new Path(URIHelper.normalize((String)location, (String)webxml.getLocation().toString(), (String)this.getLocalRoot(webxml.getLocation().toString())));
            servletRecord.tldRecords.add(record);
            this.getImplicitReferences(webxml.getLocation().toString()).put(uri, record);
            if (_debugIndexCreation) {
                System.out.println("created record for " + uri + "@" + record.location);
            }
            ++i;
        }
    }

    void updateTagDir(IResource tagFile, int deltaKind) {
    }

    void updateTLD(IResource tld, int deltaKind) {
        if (_debugIndexCreation) {
            System.out.println("creating record for " + tld.getFullPath());
        }
        TLDRecord record = this.createTLDRecord(tld);
        this.fTLDReferences.put(tld.getFullPath().toString(), record);
        if (record.uri != null) {
            this.getImplicitReferences(tld.getLocation().toString()).put(record.uri, record);
        }
        TaglibIndex.fireTaglibRecordEvent(new TaglibRecordEvent(record, deltaKind));
    }

    void clear() {
    }

    private ITaglibRecord createJARRecord(IResource jar) {
        return this.createJARRecord(jar.getLocation().toString());
    }

    private ITaglibRecord createJARRecord(String fileLocation) {
        JarRecord record = new JarRecord();
        record.location = new Path(fileLocation);
        record.urlRecords = new ArrayList(0);
        return record;
    }

    TagDirRecord createTagdirRecord(IResource tagFile) {
        IContainer tagdir = tagFile.getParent();
        String tagdirLocation = tagdir.getFullPath().toString();
        TagDirRecord record = (TagDirRecord)this.fTagDirReferences.get(tagdirLocation);
        if (record == null) {
            record = new TagDirRecord();
            record.location = tagdir.getFullPath();
            if (tagdir.getName().equals("tags")) {
                record.shortName = "tags";
            } else {
                IPath tagdirPath = tagdir.getFullPath();
                String[] segments = tagdirPath.segments();
                int i = 1;
                while (record.shortName == null && i < segments.length) {
                    if (segments[i - 1].equals(WEB_INF) && segments[i].equals("tags")) {
                        IPath tagdirLocalPath = tagdirPath.removeFirstSegments(i + 1);
                        record.shortName = tagdirLocalPath.toString().replace('/', '-');
                    }
                    ++i;
                }
            }
        }
        return record;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TLDRecord createTLDRecord(IResource tld) {
        TLDRecord record = new TLDRecord();
        record.location = tld.getLocation();
        InputStream contents = null;
        try {
            try {
                contents = ((IFile)tld).getContents(true);
                String baseLocation = record.location.toString();
                String defaultURI = this.extractURI(baseLocation, contents);
                if (defaultURI != null && defaultURI.length() > 0) {
                    record.uri = defaultURI;
                }
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (contents == null) throw throwable;
                contents.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        try {}
        catch (IOException iOException) {
            return record;
        }
        if (contents == null) return record;
        contents.close();
        return record;
    }

    private String extractURI(String baseLocation, InputStream tldContents) {
        StringBuffer uri = new StringBuffer();
        Node result = null;
        DocumentProvider provider = new DocumentProvider();
        provider.setInputStream(tldContents);
        provider.setValidating(false);
        provider.setRootElementName("taglib");
        provider.setBaseReference(baseLocation);
        result = provider.getRootElement();
        if (result.getNodeType() != 1) {
            return null;
        }
        Element taglibElement = (Element)result;
        if (taglibElement != null) {
            Node child = taglibElement.getFirstChild();
            while (!(child == null || child.getNodeType() == 1 && child.getNodeName().equals("uri"))) {
                child = child.getNextSibling();
            }
            if (child != null) {
                Node text = child.getFirstChild();
                while (text != null) {
                    if (text.getNodeType() == 3 || text.getNodeType() == 4) {
                        uri.append(text.getNodeValue().trim());
                    }
                    text = text.getNextSibling();
                }
            }
        }
        return uri.toString();
    }

    synchronized List getAvailableTaglibRecords(IPath location) {
        Collection implicitReferences = this.getImplicitReferences(location.toString()).values();
        ArrayList records = new ArrayList(this.fTLDReferences.size() + this.fTagDirReferences.size() + this.fJARReferences.size() + this.fServletReferences.size());
        records.addAll(this.fTLDReferences.values());
        records.addAll(this.fTagDirReferences.values());
        records.addAll(this.fJARReferences.values());
        records.addAll(this.fServletReferences.values());
        records.addAll(implicitReferences);
        return records;
    }

    Hashtable getImplicitReferences(String location) {
        String localRoot = this.getLocalRoot(location);
        Hashtable implicitReferences = (Hashtable)this.fImplicitReferences.get(localRoot);
        if (implicitReferences == null) {
            implicitReferences = new Hashtable(1);
            this.fImplicitReferences.put(localRoot, implicitReferences);
        }
        return implicitReferences;
    }

    IPath getLocalRoot(IPath baseLocation) {
        IFile file = FileBuffers.getWorkspaceFileAtLocation((IPath)baseLocation);
        while (file != null) {
            IFolder webinf;
            IContainer folder = null;
            folder = (file.getType() & 2) != 0 ? (IContainer)file : file.getParent();
            if (folder != null && (folder.getType() & 8) == 0 && (webinf = folder.getFolder(WEB_INF_PATH)) != null && webinf.exists()) {
                return folder.getFullPath();
            }
            file = file.getParent();
        }
        return this.fProject.getFullPath();
    }

    private String getLocalRoot(String baseLocation) {
        return this.getLocalRoot((IPath)new Path(baseLocation)).toString();
    }

    IResourceDeltaVisitor getVisitor() {
        if (this.fVisitor == null) {
            this.fVisitor = new DeltaVisitor();
        }
        return this.fVisitor;
    }

    void index() {
        this.time0 = System.currentTimeMillis();
        this.fTLDReferences.clear();
        this.fJARReferences.clear();
        this.fTagDirReferences.clear();
        this.fServletReferences.clear();
        try {
            this.fProject.accept((IResourceProxyVisitor)new Indexer(), 0);
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        if (_debugIndexTime) {
            System.out.println("indexed " + this.fProject.getName() + " in " + (System.currentTimeMillis() - this.time0) + "ms");
        }
    }

    void indexClasspath() {
        this.time0 = System.currentTimeMillis();
        this.fClasspathProjects = new Stack();
        this.fClasspathReferences.clear();
        this.fClasspathJars.clear();
        IJavaProject javaProject = JavaCore.create((IProject)this.fProject);
        this.indexClasspath(javaProject);
        if (_debugIndexTime) {
            System.out.println("indexed " + this.fProject.getName() + " classpath in " + (System.currentTimeMillis() - this.time0) + "ms");
        }
    }

    private void indexClasspath(IClasspathEntry entry) {
        switch (entry.getEntryKind()) {
            case 5: {
                IClasspathContainer container = (IClasspathContainer)entry;
                IClasspathEntry[] containedEntries = container.getClasspathEntries();
                int i = 0;
                while (i < containedEntries.length) {
                    this.indexClasspath(containedEntries[i]);
                    ++i;
                }
                break;
            }
            case 1: {
                IPath libPath;
                if (this.fClasspathProjects.size() >= 2 && !entry.isExported() || this.fClasspathJars.containsKey((libPath = entry.getPath()).toString())) break;
                if (libPath.toFile().exists()) {
                    this.updateClasspathLibrary(libPath.toString(), 4);
                    break;
                }
                IFile libFile = ResourcesPlugin.getWorkspace().getRoot().getFile(libPath);
                if (libFile == null || !libFile.exists()) break;
                this.updateClasspathLibrary(libFile.getLocation().toString(), 4);
                break;
            }
            case 2: {
                IProject project;
                if (this.fClasspathProjects.size() >= 2 && !entry.isExported() || (project = ResourcesPlugin.getWorkspace().getRoot().getProject(entry.getPath().lastSegment())) == null || this.fClasspathProjects.contains(project.getName())) break;
                this.indexClasspath(JavaCore.create((IProject)project));
                break;
            }
            case 3: {
                break;
            }
        }
    }

    private void indexClasspath(IJavaProject javaProject) {
        if (javaProject != null && javaProject.exists()) {
            this.fClasspathProjects.push(javaProject.getElementName());
            try {
                IClasspathEntry[] entries = javaProject.getResolvedClasspath(true);
                int i = 0;
                while (i < entries.length) {
                    this.indexClasspath(entries[i]);
                    ++i;
                }
            }
            catch (JavaModelException e) {
                Logger.logException("Error searching Java Build Path + (" + this.fProject.getName() + ") for tag libraries", e);
            }
            this.fClasspathProjects.pop();
        }
    }

    protected String readTextofChild(Node node, String childName) {
        StringBuffer buffer = new StringBuffer();
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals(childName)) {
                Node text = child.getFirstChild();
                while (text != null) {
                    buffer.append(text.getNodeValue().trim());
                    text = text.getNextSibling();
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    void removeClasspathLibrary(String libraryLocation) {
        JarRecord record = (JarRecord)this.fClasspathJars.remove(libraryLocation);
        if (record != null) {
            URLRecord[] records = record.getURLRecords().toArray(new URLRecord[0]);
            int i = 0;
            while (i < records.length) {
                this.fClasspathReferences.remove(records[i].getURI());
                ++i;
            }
            TaglibIndex.fireTaglibRecordEvent(new TaglibRecordEvent(record, 2));
        }
    }

    void removeJAR(IResource jar) {
        JarRecord record;
        if (_debugIndexCreation) {
            System.out.println("removing records for JAR " + jar.getFullPath());
        }
        if ((record = (JarRecord)this.fJARReferences.remove(jar.getFullPath())) != null) {
            URLRecord[] records = record.getURLRecords().toArray(new URLRecord[0]);
            int i = 0;
            while (i < records.length) {
                this.getImplicitReferences(jar.getLocation().toString()).remove(records[i].getURI());
                ++i;
            }
            TaglibIndex.fireTaglibRecordEvent(new TaglibRecordEvent(record, 2));
        }
    }

    void removeServlets(IResource webxml) {
        ServletRecord record;
        if (_debugIndexCreation) {
            System.out.println("removing records for " + webxml.getFullPath());
        }
        if ((record = (ServletRecord)this.fServletReferences.remove(webxml.getLocation().toString())) != null) {
            TLDRecord[] records = record.getTLDRecords().toArray(new TLDRecord[0]);
            int i = 0;
            while (i < records.length) {
                if (_debugIndexCreation) {
                    System.out.println("removed record for " + records[i].uri + "@" + records[i].location);
                }
                this.getImplicitReferences(webxml.getLocation().toString()).remove(records[i].getURI());
                ++i;
            }
            TaglibIndex.fireTaglibRecordEvent(new TaglibRecordEvent(record, 2));
        }
    }

    void removeTagDir(IResource tagFile) {
    }

    void removeTLD(IResource tld) {
        TLDRecord record;
        if (_debugIndexCreation) {
            System.out.println("removing record for " + tld.getFullPath());
        }
        if ((record = (TLDRecord)this.fTLDReferences.remove(tld.getFullPath())) != null) {
            if (record.uri != null) {
                this.getImplicitReferences(tld.getLocation().toString()).remove(record.uri);
            }
            TaglibIndex.fireTaglibRecordEvent(new TaglibRecordEvent(record, 2));
        }
    }

    ITaglibRecord resolve(String basePath, String reference) {
        ITaglibRecord record = null;
        String location = null;
        location = reference.startsWith("/") ? String.valueOf(this.getLocalRoot(basePath)) + reference : URIHelper.normalize((String)reference, (String)basePath, (String)this.getLocalRoot(basePath));
        if (record == null) {
            record = (ITaglibRecord)this.fServletReferences.get(location);
        }
        if (record == null) {
            record = (ITaglibRecord)this.fJARReferences.get(location);
        }
        if (record == null) {
            record = (ITaglibRecord)this.fTLDReferences.get(location);
        }
        if (record == null) {
            record = (ITaglibRecord)this.getImplicitReferences(basePath).get(reference);
        }
        if (record == null) {
            record = (ITaglibRecord)this.fTagDirReferences.get(location);
        }
        if (record == null) {
            record = (ITaglibRecord)this.fClasspathReferences.get(reference);
        }
        return record;
    }

    class DeltaVisitor
    implements IResourceDeltaVisitor {
        DeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource.getType() == 1) {
                if (resource.getName().endsWith(".tld")) {
                    if (delta.getKind() == 2) {
                        ProjectDescription.this.removeTLD(resource);
                    } else {
                        ProjectDescription.this.updateTLD(resource, delta.getKind());
                    }
                } else if (resource.getName().endsWith(".jar")) {
                    if (delta.getKind() == 2) {
                        ProjectDescription.this.removeJAR(resource);
                    } else {
                        ProjectDescription.this.updateJAR(resource, delta.getKind());
                    }
                } else if (resource.getName().endsWith(".tag") || resource.getName().endsWith(".tagx")) {
                    if (delta.getKind() == 2) {
                        ProjectDescription.this.removeTagDir(resource);
                    } else {
                        ProjectDescription.this.updateTagDir(resource, delta.getKind());
                    }
                } else if (resource.getName().equals(ProjectDescription.WEB_XML) && resource.getParent().getName().equals(ProjectDescription.WEB_INF)) {
                    if (delta.getKind() == 2) {
                        ProjectDescription.this.removeServlets(resource);
                    } else {
                        ProjectDescription.this.updateServlets(resource, delta.getKind());
                    }
                }
            }
            return resource.getName().length() != 0 && resource.getName().charAt(0) != '.';
        }
    }

    class Indexer
    implements IResourceProxyVisitor {
        Indexer() {
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            String name;
            if (proxy.getType() == 1) {
                if (proxy.getName().endsWith(".tld")) {
                    ProjectDescription.this.updateTLD(proxy.requestResource(), 1);
                } else if (proxy.getName().endsWith(".jar")) {
                    ProjectDescription.this.updateJAR(proxy.requestResource(), 1);
                } else if (proxy.getName().endsWith(".tag") || proxy.getName().endsWith(".tagx")) {
                    ProjectDescription.this.updateTagDir(proxy.requestResource(), 1);
                } else if (proxy.getName().equals(ProjectDescription.WEB_XML) && proxy.requestResource().getParent().getName().equals(ProjectDescription.WEB_INF)) {
                    ProjectDescription.this.updateServlets(proxy.requestResource(), 1);
                }
            }
            return (name = proxy.getName()).length() != 0 && name.charAt(0) != '.';
        }
    }

    class TaglibRecordEvent
    implements ITaglibRecordEvent {
        ITaglibRecord fTaglibRecord = null;
        int fType = -1;
        static /* synthetic */ Class class$0;

        TaglibRecordEvent(ITaglibRecord record, int type) {
            this.fTaglibRecord = record;
            this.fType = type;
        }

        public ITaglibRecord getTaglibRecord() {
            return this.fTaglibRecord;
        }

        public int getType() {
            return this.fType;
        }

        public String toString() {
            String string = this.fTaglibRecord.toString();
            switch (this.fType) {
                case 1: {
                    StringBuffer stringBuffer = new StringBuffer(String.valueOf(string)).append(" ADDED (");
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.internal.contentmodel.ProjectDescription$TaglibRecordEvent");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    string = stringBuffer.append(clazz.getName()).append(")").toString();
                    break;
                }
                case 4: {
                    StringBuffer stringBuffer = new StringBuffer(String.valueOf(string)).append(" CHANGED (");
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.internal.contentmodel.ProjectDescription$TaglibRecordEvent");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    string = stringBuffer.append(clazz.getName()).append(")").toString();
                    break;
                }
                case 2: {
                    StringBuffer stringBuffer = new StringBuffer(String.valueOf(string)).append(" REMOVED (");
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.internal.contentmodel.ProjectDescription$TaglibRecordEvent");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    string = stringBuffer.append(clazz.getName()).append(")").toString();
                    break;
                }
                default: {
                    StringBuffer stringBuffer = new StringBuffer(String.valueOf(string)).append(" other:").append(this.fType).append(" (");
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.internal.contentmodel.ProjectDescription$TaglibRecordEvent");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    string = stringBuffer.append(clazz.getName()).append(")").toString();
                }
            }
            return string;
        }
    }
}

