/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.contentmodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsp.core.internal.contentmodel.ITaglibIndexListener;
import org.eclipse.jst.jsp.core.internal.contentmodel.ITaglibRecordEvent;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibIndex;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDCMDocumentManager;
import org.eclipse.jst.jsp.core.internal.parser.JSPSourceParser;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;
import org.eclipse.wst.sse.core.internal.util.Assert;

public class TaglibController
implements IDocumentSetupParticipant {
    static TaglibController _instance = null;
    private static boolean fIsShutdown = false;
    IFileBufferListener fBufferListener = new FileBufferListener();
    Map fDocumentMap;
    List fJSPdocuments = new ArrayList(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ITextFileBuffer getFileBuffer(IDocument document) {
        Map map = TaglibController._instance.fDocumentMap;
        synchronized (map) {
            DocumentInfo info = (DocumentInfo)TaglibController._instance.fDocumentMap.get(document);
            if (info != null) {
                return info.textFileBuffer;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ITextFileBuffer getFileBuffer(TLDCMDocumentManager manager) {
        if (_instance == null) {
            return null;
        }
        ITextFileBuffer buffer = null;
        Map map = TaglibController._instance.fDocumentMap;
        synchronized (map) {
            Iterator docInfos = TaglibController._instance.fDocumentMap.values().iterator();
            while (docInfos.hasNext() && buffer == null) {
                DocumentInfo info = (DocumentInfo)docInfos.next();
                if (!info.tldDocumentManager.equals(manager)) continue;
                buffer = info.textFileBuffer;
            }
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TLDCMDocumentManager getTLDCMDocumentManager(IDocument document) {
        if (_instance == null) {
            return null;
        }
        Map map = TaglibController._instance.fDocumentMap;
        synchronized (map) {
            DocumentInfo info = (DocumentInfo)TaglibController._instance.fDocumentMap.get(document);
            if (info != null) {
                return info.tldDocumentManager;
            }
            return null;
        }
    }

    public static synchronized void shutdown() {
        TaglibController.setShutdown(true);
        FileBuffers.getTextFileBufferManager().removeFileBufferListener(TaglibController._instance.fBufferListener);
        _instance = null;
    }

    public static synchronized void startup() {
        _instance = new TaglibController();
        FileBuffers.getTextFileBufferManager().addFileBufferListener(TaglibController._instance.fBufferListener);
        TaglibController.setShutdown(false);
    }

    public TaglibController() {
        this.fDocumentMap = new HashMap(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup(IDocument document) {
        if (TaglibController.isShutdown()) {
            return;
        }
        List list = TaglibController._instance.fJSPdocuments;
        synchronized (list) {
            TaglibController._instance.fJSPdocuments.add(document);
        }
    }

    private static synchronized boolean isShutdown() {
        return fIsShutdown;
    }

    private static synchronized void setShutdown(boolean isShutdown) {
        fIsShutdown = isShutdown;
    }

    class DocumentInfo
    implements ITaglibIndexListener {
        IStructuredDocument document;
        ITextFileBuffer textFileBuffer;
        TLDCMDocumentManager tldDocumentManager;

        DocumentInfo() {
        }

        public void indexChanged(ITaglibRecordEvent event) {
            this.tldDocumentManager.indexChanged(event);
        }
    }

    class FileBufferListener
    implements IFileBufferListener {
        FileBufferListener() {
        }

        public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
        }

        public void bufferContentReplaced(IFileBuffer buffer) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bufferCreated(IFileBuffer buffer) {
            if (buffer instanceof ITextFileBuffer) {
                IDocument document = ((ITextFileBuffer)buffer).getDocument();
                List list = TaglibController.this.fJSPdocuments;
                synchronized (list) {
                    if (!TaglibController.this.fJSPdocuments.contains(document)) {
                        return;
                    }
                }
                Assert.isTrue((boolean)(document instanceof IStructuredDocument), (String)(String.valueOf(this.getClass().getName()) + " SetupParticipant was called for non-IStructuredDocument"));
                DocumentInfo info = new DocumentInfo();
                info.document = (IStructuredDocument)document;
                info.textFileBuffer = (ITextFileBuffer)buffer;
                info.tldDocumentManager = new TLDCMDocumentManager();
                info.tldDocumentManager.setSourceParser((JSPSourceParser)info.document.getParser());
                Map map = TaglibController.this.fDocumentMap;
                synchronized (map) {
                    TaglibController.this.fDocumentMap.put(document, info);
                    TaglibIndex.addTaglibIndexListener(info);
                }
                if (document instanceof BasicStructuredDocument) {
                    ((BasicStructuredDocument)document).reparse((Object)this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bufferDisposed(IFileBuffer buffer) {
            if (buffer instanceof ITextFileBuffer) {
                IDocument document = ((ITextFileBuffer)buffer).getDocument();
                List list = TaglibController.this.fJSPdocuments;
                synchronized (list) {
                    if (!TaglibController.this.fJSPdocuments.remove(document)) {
                        return;
                    }
                }
            }
            Map map = TaglibController.this.fDocumentMap;
            synchronized (map) {
                Object[] keys = TaglibController.this.fDocumentMap.keySet().toArray();
                boolean removed = false;
                int i = 0;
                while (i < keys.length && !removed) {
                    DocumentInfo info = (DocumentInfo)TaglibController.this.fDocumentMap.get(keys[i]);
                    if (info != null && info.textFileBuffer.equals(buffer)) {
                        TaglibIndex.removeTaglibIndexListener(info);
                        TaglibController.this.fDocumentMap.remove(keys[i]);
                        removed = true;
                    }
                    ++i;
                }
            }
        }

        public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
        }

        public void stateChangeFailed(IFileBuffer buffer) {
        }

        public void stateChanging(IFileBuffer buffer) {
        }

        public void stateValidationChanged(IFileBuffer buffer, boolean isStateValidated) {
        }

        public void underlyingFileDeleted(IFileBuffer buffer) {
        }

        public void underlyingFileMoved(IFileBuffer buffer, IPath path) {
        }
    }
}

