/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.contentmodel;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.contentmodel.ITaglibIndexListener;
import org.eclipse.jst.jsp.core.internal.contentmodel.ITaglibRecord;
import org.eclipse.jst.jsp.core.internal.contentmodel.ITaglibRecordEvent;
import org.eclipse.jst.jsp.core.internal.contentmodel.JarRecord;
import org.eclipse.jst.jsp.core.internal.contentmodel.ProjectDescription;
import org.eclipse.jst.jsp.core.internal.contentmodel.TLDRecord;
import org.eclipse.jst.jsp.core.internal.contentmodel.URLRecord;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.sse.core.internal.util.StringUtils;

public class TaglibIndex {
    static final boolean _debugChangeListener = false;
    static boolean _debugEvents = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/taglib/events"));
    static boolean _debugIndexCreation = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/taglib/indexcreation"));
    static final boolean _debugResolution = "true".equals(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/taglib/resolve"));
    static TaglibIndex _instance;
    private ClasspathChangeListener fClasspathChangeListener = null;
    private Map fProjectDescriptions;
    private ResourceChangeListener fResourceChangeListener = new ResourceChangeListener();
    private ITaglibIndexListener[] fTaglibIndexListeners = null;

    public static void addTaglibIndexListener(ITaglibIndexListener listener) {
        _instance.internalAddTaglibIndexListener(listener);
    }

    static void fireTaglibRecordEvent(ITaglibRecordEvent event) {
        ITaglibIndexListener[] listeners;
        if (_debugEvents) {
            System.out.println("TaglibIndex fired event:" + event);
        }
        if ((listeners = TaglibIndex._instance.fTaglibIndexListeners) != null) {
            int i = 0;
            while (i < listeners.length) {
                try {
                    listeners[i].indexChanged(event);
                }
                catch (Exception e) {
                    Logger.log(2, e.getMessage());
                }
                ++i;
            }
        }
    }

    public static ITaglibRecord[] getAvailableTaglibRecords(IPath workspacePath) {
        ITaglibRecord[] records = _instance.internalGetAvailableTaglibRecords(workspacePath);
        return records;
    }

    public static IPath getContextRoot(IPath path) {
        return _instance.internalGetContextRoot(path);
    }

    public static void removeTaglibIndexListener(ITaglibIndexListener listener) {
        _instance.internalRemoveTaglibIndexListener(listener);
    }

    public static ITaglibRecord resolve(String basePath, String reference, boolean crossProjects) {
        ITaglibRecord result = _instance.internalResolve(basePath, reference, crossProjects);
        if (_debugResolution) {
            if (result == null) {
                System.out.println("TaglibIndex could not resolve \"" + reference + "\" from " + basePath);
            } else {
                switch (result.getRecordType()) {
                    case 2: {
                        TLDRecord record = (TLDRecord)result;
                        System.out.println("TaglibIndex resolved " + basePath + ":" + reference + " = " + record.getLocation());
                        break;
                    }
                    case 4: {
                        JarRecord record = (JarRecord)result;
                        System.out.println("TaglibIndex resolved " + basePath + ":" + reference + " = " + record.getLocation());
                        break;
                    }
                    case 16: {
                        break;
                    }
                    case 1: {
                        URLRecord record = (URLRecord)result;
                        System.out.println("TaglibIndex resolved " + basePath + ":" + reference + " = " + record.getURL());
                    }
                }
            }
        }
        return result;
    }

    public static synchronized void shutdown() {
        if (_instance != null) {
            _instance.stop();
        }
        _instance = null;
    }

    public static synchronized void startup() {
        _instance = new TaglibIndex();
    }

    private TaglibIndex() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fResourceChangeListener, 1);
        this.fClasspathChangeListener = new ClasspathChangeListener();
        JavaCore.addElementChangedListener((IElementChangedListener)this.fClasspathChangeListener);
        this.fProjectDescriptions = new HashMap();
    }

    ProjectDescription createDescription(IProject project) {
        ProjectDescription description = (ProjectDescription)this.fProjectDescriptions.get(project);
        if (description == null) {
            description = new ProjectDescription(project);
            description.index();
            description.indexClasspath();
            this.fProjectDescriptions.put(project, description);
        }
        return description;
    }

    private synchronized void internalAddTaglibIndexListener(ITaglibIndexListener listener) {
        if (this.fTaglibIndexListeners == null) {
            this.fTaglibIndexListeners = new ITaglibIndexListener[]{listener};
        } else {
            ArrayList<ITaglibIndexListener> listeners = new ArrayList<ITaglibIndexListener>(Arrays.asList(this.fTaglibIndexListeners));
            listeners.add(listener);
            this.fTaglibIndexListeners = listeners.toArray(new ITaglibIndexListener[0]);
        }
    }

    private ITaglibRecord[] internalGetAvailableTaglibRecords(IPath location) {
        ITaglibRecord[] records = null;
        IFile baseResource = ResourcesPlugin.getWorkspace().getRoot().getFile(location);
        if (baseResource != null) {
            IProject project = baseResource.getProject();
            ProjectDescription description = this.createDescription(project);
            List availableRecords = description.getAvailableTaglibRecords(location);
            records = availableRecords.toArray(records);
        } else {
            records = new ITaglibRecord[]{};
        }
        return records;
    }

    private IPath internalGetContextRoot(IPath path) {
        IFile baseResource = FileBuffers.getWorkspaceFileAtLocation((IPath)path);
        if (baseResource != null) {
            IProject project = baseResource.getProject();
            ProjectDescription description = _instance.createDescription(project);
            IPath rootPath = description.getLocalRoot(baseResource.getFullPath());
            return ResourcesPlugin.getWorkspace().getRoot().getLocation().append(rootPath);
        }
        IPath root = path;
        while (root != null && !root.isRoot()) {
            root = root.removeLastSegments(1);
        }
        if (root == null) {
            root = path;
        }
        return root;
    }

    private synchronized void internalRemoveTaglibIndexListener(ITaglibIndexListener listener) {
        if (this.fTaglibIndexListeners != null) {
            ArrayList<ITaglibIndexListener> listeners = new ArrayList<ITaglibIndexListener>(Arrays.asList(this.fTaglibIndexListeners));
            listeners.remove(listener);
            this.fTaglibIndexListeners = listeners.toArray(new ITaglibIndexListener[0]);
        }
    }

    private ITaglibRecord internalResolve(String basePath, String reference, boolean crossProjects) {
        IProject project = null;
        ITaglibRecord resolved = null;
        IFile baseResource = FileBuffers.getWorkspaceFileAtLocation((IPath)new Path(basePath));
        if (baseResource != null) {
            project = baseResource.getProject();
            ProjectDescription description = this.createDescription(project);
            resolved = description.resolve(basePath, reference);
        } else {
            String normalizedReference;
            File baseFile = FileBuffers.getSystemFileAtLocation((IPath)new Path(basePath));
            if (baseFile != null && (normalizedReference = URIHelper.normalize((String)reference, (String)basePath, (String)"/")) != null) {
                TLDRecord record = new TLDRecord();
                record.location = new Path(normalizedReference);
                record.uri = reference;
                resolved = record;
            }
        }
        return resolved;
    }

    boolean isIndexAvailable() {
        return _instance != null;
    }

    private void stop() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fResourceChangeListener);
        JavaCore.removeElementChangedListener((IElementChangedListener)this.fClasspathChangeListener);
        this.fProjectDescriptions.clear();
    }

    class ClasspathChangeListener
    implements IElementChangedListener {
        Stack classpathStack = new Stack();
        List projectsIndexed = new ArrayList(1);

        ClasspathChangeListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            if (!TaglibIndex.this.isIndexAvailable()) {
                return;
            }
            this.classpathStack.clear();
            this.projectsIndexed.clear();
            this.elementChanged(event.getDelta());
        }

        private void elementChanged(IJavaElementDelta delta) {
            if (delta.getElement().getElementType() == 1) {
                IJavaElementDelta[] changed = delta.getChangedChildren();
                int i = 0;
                while (i < changed.length) {
                    this.elementChanged(changed[i]);
                    ++i;
                }
            } else if (delta.getElement().getElementType() == 2 && (delta.getFlags() & 0x20000) != 0) {
                IJavaElement proj = delta.getElement();
                this.handleClasspathChange((IJavaProject)proj);
            }
        }

        private void handleClasspathChange(IJavaProject project) {
            this.classpathStack.push(project.getElementName());
            try {
                IResource resource = project.getCorrespondingResource();
                if (resource.getType() == 4 && !this.projectsIndexed.contains(resource)) {
                    this.projectsIndexed.add(resource);
                    boolean classpathIndexIsOld = TaglibIndex.this.fProjectDescriptions.containsKey(resource);
                    ProjectDescription description = TaglibIndex.this.createDescription((IProject)resource);
                    if (classpathIndexIsOld) {
                        description.indexClasspath();
                    }
                }
                IJavaProject[] projects = project.getJavaModel().getJavaProjects();
                int i = 0;
                while (i < projects.length) {
                    IJavaProject otherProject = projects[i];
                    if (StringUtils.contains((String[])otherProject.getRequiredProjectNames(), (String)project.getElementName(), (boolean)false) && !this.classpathStack.contains(otherProject.getElementName())) {
                        this.handleClasspathChange(otherProject);
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {}
            this.classpathStack.pop();
        }
    }

    class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (!TaglibIndex.this.isIndexAvailable()) {
                return;
            }
            switch (event.getType()) {
                case 2: 
                case 4: {
                    ProjectDescription description;
                    int i;
                    IResource resource;
                    IProject[] projects;
                    IResourceDelta[] deltas;
                    try {
                        deltas = new IResourceDelta[]{event.getDelta()};
                        projects = null;
                        if (deltas != null && deltas.length > 0) {
                            resource = null;
                            resource = deltas[0] != null ? deltas[0].getResource() : event.getResource();
                            if (resource != null) {
                                if (resource.getType() == 8) {
                                    deltas = deltas[0].getAffectedChildren();
                                    projects = new IProject[deltas.length];
                                    i = 0;
                                    while (i < deltas.length) {
                                        if (deltas[i].getResource().getType() == 4) {
                                            projects[i] = (IProject)deltas[i].getResource();
                                        }
                                        ++i;
                                    }
                                } else {
                                    projects = new IProject[]{resource.getType() != 4 ? resource.getProject() : (IProject)resource};
                                }
                            }
                            i = 0;
                            while (i < projects.length) {
                                if (_debugIndexCreation) {
                                    System.out.println("TaglibIndex noticed " + projects[i].getName() + " is about to be deleted/closed");
                                }
                                if ((description = (ProjectDescription)TaglibIndex.this.fProjectDescriptions.remove(projects[i])) != null) {
                                    if (_debugIndexCreation) {
                                        System.out.println("removing index of " + description.fProject.getName());
                                    }
                                    description.clear();
                                }
                                ++i;
                            }
                        }
                    }
                    catch (Exception e) {
                        Logger.logException("Exception while processing resource deletion", e);
                    }
                }
                case 1: {
                    ProjectDescription description;
                    int i;
                    IResource resource;
                    IProject[] projects;
                    IResourceDelta[] deltas;
                    try {
                        deltas = new IResourceDelta[]{event.getDelta()};
                        projects = null;
                        if (deltas == null || deltas.length <= 0) break;
                        resource = null;
                        resource = deltas[0] != null ? deltas[0].getResource() : event.getResource();
                        if (resource != null) {
                            if (resource.getType() == 8) {
                                deltas = deltas[0].getAffectedChildren();
                                projects = new IProject[deltas.length];
                                i = 0;
                                while (i < deltas.length) {
                                    if (deltas[i].getResource().getType() == 4) {
                                        projects[i] = (IProject)deltas[i].getResource();
                                    }
                                    ++i;
                                }
                            } else {
                                projects = new IProject[]{resource.getType() != 4 ? resource.getProject() : (IProject)resource};
                            }
                        }
                        i = 0;
                        while (i < projects.length) {
                            try {
                                if (deltas[i] != null && deltas[i].getKind() != 2 && projects[i].isAccessible()) {
                                    description = TaglibIndex.this.createDescription(projects[i]);
                                    deltas[i].accept(description.getVisitor());
                                }
                                if (!projects[i].isAccessible() || deltas[i] != null && deltas[i].getKind() == 2) {
                                    if (_debugIndexCreation) {
                                        System.out.println("TaglibIndex noticed " + projects[i].getName() + " is no longer accessible");
                                    }
                                    if ((description = (ProjectDescription)TaglibIndex.this.fProjectDescriptions.remove(projects[i])) != null) {
                                        if (_debugIndexCreation) {
                                            System.out.println("removing index of " + description.fProject.getName());
                                        }
                                        description.clear();
                                    }
                                }
                            }
                            catch (CoreException e) {
                                Logger.logException(e);
                            }
                            ++i;
                        }
                        break;
                    }
                    catch (Exception e) {
                        Logger.logException("Exception while processing resource change", e);
                    }
                }
            }
        }
    }
}

