/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.internal.java.jspel;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibController;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.CMDocumentImpl;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDCMDocumentManager;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TaglibTracker;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDFunction;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslator;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTAddExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTAndExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTChoiceExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTEqualityExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTFunctionInvocation;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTLiteral;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTMultiplyExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTOperatorExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTOrExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTRelationalExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTUnaryExpression;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTValue;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTValuePrefix;
import org.eclipse.jst.jsp.core.internal.java.jspel.ASTValueSuffix;
import org.eclipse.jst.jsp.core.internal.java.jspel.JSPELParserVisitor;
import org.eclipse.jst.jsp.core.internal.java.jspel.SimpleNode;
import org.eclipse.jst.jsp.core.internal.java.jspel.Token;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;

public class ELGeneratorVisitor
implements JSPELParserVisitor {
    private static final String ENDL = "\n";
    private static final String fExpressionHeader1 = "public String _elExpression";
    private static final String fExpressionHeader2 = "()\n\t\tthrows java.io.IOException, javax.servlet.ServletException {\njavax.servlet.jsp.PageContext pageContext = null;\njava.util.Map param = null;\njava.util.Map paramValues = null;\njava.util.Map header = null;\njava.util.Map headerValues = null;\njava.util.Map cookie = null;\njava.util.Map initParam = null;\njava.util.Map pageScope = null;\njava.util.Map requestScope = null;\njava.util.Map sessionScope = null;\njava.util.Map applicationScope = null;\nreturn \"\"+";
    private static final String[] fJspImplicitObjects = new String[]{"pageContext"};
    private static final String[] fJspImplicitMaps = new String[]{"param", "paramValues", "header", "headerValues", "cookie", "initParam", "pageScope", "requestScope", "sessionScope", "applicationScope"};
    private static final HashMap fJSPImplicitObjectMap = new HashMap(fJspImplicitObjects.length);
    private static final String fFooter = " ;\n}\n";
    private StringBuffer fResult;
    private Map fCodeMap;
    private int fOffsetInUserCode;
    private int methodCounter = 0;
    private JSPTranslator fTranslator = null;
    private int fContentStart;
    private static Map fOperatorMap;
    private boolean fCanGenerate = true;

    static {
        int i = 0;
        while (i < fJspImplicitObjects.length) {
            fJSPImplicitObjectMap.put(fJspImplicitObjects[i], new Boolean(true));
            ++i;
        }
        i = 0;
        while (i < fJspImplicitMaps.length) {
            fJSPImplicitObjectMap.put(fJspImplicitMaps[i], new Boolean(false));
            ++i;
        }
        fOperatorMap = new HashMap();
        fOperatorMap.put("gt", ">");
        fOperatorMap.put("lt", "<");
        fOperatorMap.put("ge", ">=");
        fOperatorMap.put("le", "<=");
        fOperatorMap.put("mod", "%");
        fOperatorMap.put("eq", "==");
    }

    public ELGeneratorVisitor(StringBuffer result, Map codeMap, JSPTranslator translator, ITextRegionCollection jspReferenceRegion, int contentStart) {
        this.fResult = result;
        this.fCodeMap = codeMap;
        this.fOffsetInUserCode = result.length();
        this.fContentStart = contentStart;
        this.fTranslator = translator;
    }

    private void append(Token token) {
        this.append(token.image, token.beginColumn - 1, token.endColumn);
    }

    private void append(String translated, Token token) {
        this.append(translated, token.beginColumn - 1, token.endColumn);
    }

    private void append(String newText, int jspPositionStart, int jspPositionEnd) {
        this.fResult.append(newText);
        Position javaRange = new Position(this.fOffsetInUserCode, newText.length());
        Position jspRange = new Position(this.fContentStart + jspPositionStart, jspPositionEnd - jspPositionStart);
        this.fCodeMap.put(javaRange, jspRange);
        this.fOffsetInUserCode += newText.length();
    }

    private void append(String newText) {
        this.fResult.append(newText);
        this.fOffsetInUserCode += newText.length();
    }

    protected String genFunction(String fullFunctionName) {
        TLDCMDocumentManager docMgr = TaglibController.getTLDCMDocumentManager((IDocument)this.fTranslator.getStructuredDocument());
        int colonIndex = fullFunctionName.indexOf(58);
        String prefix = fullFunctionName.substring(0, colonIndex);
        String functionName = fullFunctionName.substring(colonIndex + 1);
        if (docMgr == null) {
            return null;
        }
        Iterator taglibs = docMgr.getCMDocumentTrackers(this.fTranslator.getCurrentNode().getStartOffset()).iterator();
        while (taglibs.hasNext()) {
            TaglibTracker tracker = (TaglibTracker)taglibs.next();
            if (!tracker.getPrefix().equals(prefix)) continue;
            CMDocumentImpl doc = (CMDocumentImpl)tracker.getDocument();
            List functions = doc.getFunctions();
            Iterator it = functions.iterator();
            while (it.hasNext()) {
                TLDFunction function = (TLDFunction)it.next();
                if (!function.getName().equals(functionName)) continue;
                return String.valueOf(function.getClassName()) + "." + function.getName();
            }
        }
        return null;
    }

    public Object visit(SimpleNode node, Object data) {
        return node.childrenAccept(this, data);
    }

    public Object visit(ASTExpression node, Object data) {
        int start = node.getFirstToken().beginColumn - 1;
        int end = node.lastToken.endColumn - 1;
        this.append(fExpressionHeader1, start, start);
        this.append(Integer.toString(this.methodCounter++), start, start);
        this.append(fExpressionHeader2, start, start);
        Object retval = node.childrenAccept(this, data);
        this.append(fFooter, end, end);
        if (!this.fCanGenerate) {
            this.fResult.delete(0, this.fResult.length());
            this.fCodeMap.clear();
        }
        return retval;
    }

    private void generateOperatorNode(ASTOperatorExpression node, Object data) {
        int i = 0;
        while (i < node.children.length) {
            node.children[i].jjtAccept(this, data);
            if (node.children.length - i > 1) {
                this.appendOperator((Token)node.getOperatorTokens().get(i));
            }
            ++i;
        }
    }

    private String appendOperator(Token token) {
        String tokenImage = token.image.trim();
        String translated = (String)fOperatorMap.get(tokenImage);
        if (translated != null) {
            this.append(translated, token);
        } else {
            this.append(token);
        }
        return translated;
    }

    public Object visit(ASTOrExpression node, Object data) {
        this.generateOperatorNode(node, data);
        return null;
    }

    public Object visit(ASTAndExpression node, Object data) {
        this.generateOperatorNode(node, data);
        return null;
    }

    public Object visit(ASTEqualityExpression node, Object data) {
        this.generateOperatorNode(node, data);
        return null;
    }

    public Object visit(ASTRelationalExpression node, Object data) {
        this.generateOperatorNode(node, data);
        return null;
    }

    public Object visit(ASTAddExpression node, Object data) {
        this.generateOperatorNode(node, data);
        return null;
    }

    public Object visit(ASTMultiplyExpression node, Object data) {
        this.generateOperatorNode(node, data);
        return null;
    }

    public Object visit(ASTChoiceExpression node, Object data) {
        node.children[0].jjtAccept(this, data);
        this.append("?");
        node.children[1].jjtAccept(this, data);
        this.append(":");
        node.children[2].jjtAccept(this, data);
        return null;
    }

    public Object visit(ASTUnaryExpression node, Object data) {
        if (45 == node.firstToken.kind) {
            this.append("((null == ");
            node.childrenAccept(this, data);
            this.append(") || (");
            node.childrenAccept(this, data);
            this.append(").isEmpty())");
        } else if (39 == node.firstToken.kind || 40 == node.firstToken.kind) {
            this.append("(!");
            node.childrenAccept(this, data);
            this.append(")");
        } else if (33 == node.firstToken.kind) {
            this.append("(-");
            node.childrenAccept(this, data);
            this.append(")");
        } else {
            node.childrenAccept(this, data);
        }
        return null;
    }

    public Object visit(ASTValue node, Object data) {
        return node.childrenAccept(this, data);
    }

    public Object visit(ASTValuePrefix node, Object data) {
        if (node.children == null) {
            if (this.isCompletingObject(node.firstToken.image)) {
                this.append(node.firstToken);
            } else {
                this.fCanGenerate = false;
            }
            return null;
        }
        return node.childrenAccept(this, data);
    }

    private boolean isCompletingObject(String image) {
        Boolean value = (Boolean)fJSPImplicitObjectMap.get(image);
        return value == null ? false : value;
    }

    public Object visit(ASTValueSuffix node, Object data) {
        if (30 == node.firstToken.kind) {
            this.fCanGenerate = false;
        } else if (node.getPropertyNameToken() != null) {
            Token suffix = node.getPropertyNameToken();
            String ucaseName = String.valueOf(suffix.image.substring(0, 1).toUpperCase()) + suffix.image.substring(1, suffix.image.length());
            this.append(node.firstToken);
            this.append("get" + ucaseName + "()", suffix);
        } else {
            this.append(node.firstToken);
        }
        return null;
    }

    public Object visit(ASTFunctionInvocation node, Object data) {
        String functionTranslation = this.genFunction(node.getFullFunctionName());
        if (functionTranslation != null) {
            this.append(String.valueOf(functionTranslation) + "(", node.getFirstToken());
            int i = 0;
            while (i < node.children.length) {
                node.children[i].jjtAccept(this, data);
                if (node.children.length - i > 1) {
                    this.append(",");
                }
                ++i;
            }
            this.append(")");
        }
        return null;
    }

    public Object visit(ASTLiteral node, Object data) {
        this.append(node.firstToken);
        return null;
    }
}

