/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatVersionHandler;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.TomcatPlugin;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServerBehaviour;

public class Tomcat41Handler
implements ITomcatVersionHandler {
    public boolean verifyInstallPath(IPath installPath) {
        if (installPath == null) {
            return false;
        }
        if (!TomcatPlugin.verifyTomcatVersionFromPath(installPath, "org.eclipse.jst.server.tomcat.41")) {
            return false;
        }
        return TomcatPlugin.verifyInstallPath(installPath, "org.eclipse.jst.server.tomcat.41");
    }

    public String getRuntimeClass() {
        return "org.apache.catalina.startup.Bootstrap";
    }

    public List getRuntimeClasspath(IPath installPath) {
        ArrayList<IRuntimeClasspathEntry> cp = new ArrayList<IRuntimeClasspathEntry>();
        IPath binPath = installPath.append("bin");
        if (binPath.toFile().exists()) {
            IPath path = binPath.append("bootstrap.jar");
            cp.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path));
        }
        return cp;
    }

    public String[] getRuntimeProgramArguments(IPath configPath, boolean debug, boolean starting) {
        ArrayList<String> list = new ArrayList<String>();
        if (debug) {
            list.add("-debug");
        }
        if (starting) {
            list.add("start");
        } else {
            list.add("stop");
        }
        String[] temp = new String[list.size()];
        list.toArray(temp);
        return temp;
    }

    public String[] getRuntimeVMArguments(IPath installPath, IPath configPath, boolean isTestEnv, boolean isSecure) {
        ArrayList<String> list = new ArrayList<String>();
        if (isTestEnv) {
            list.add("-Dcatalina.base=\"" + configPath.toOSString() + "\"");
        } else {
            list.add("-Dcatalina.base=\"" + installPath.toOSString() + "\"");
        }
        list.add("-Dcatalina.home=\"" + installPath.toOSString() + "\"");
        list.add("-Djava.endorsed.dirs=\"" + installPath.append("common").append("endorsed").toOSString() + "\"");
        if (isSecure) {
            list.add("-Djava.security.manager");
            IPath dir = configPath.append("conf").append("catalina.policy");
            list.add("-Djava.security.policy=\"" + dir.toOSString() + "\"");
        }
        String[] s = new String[list.size()];
        list.toArray(s);
        return s;
    }

    public IStatus canAddModule(IWebModule module) {
        if ("1.2".equals(module.getJ2EESpecificationVersion()) || "1.3".equals(module.getJ2EESpecificationVersion())) {
            return new Status(0, "org.eclipse.jst.server.tomcat.core", 0, Messages.canAddModule, null);
        }
        return new Status(4, "org.eclipse.jst.server.tomcat.core", 0, Messages.errorSpec41, null);
    }

    public IPath getRuntimeBaseDirectory(TomcatServerBehaviour serverBehaviour) {
        if (serverBehaviour.getTomcatServer().isTestEnvironment()) {
            return serverBehaviour.getTempDirectory();
        }
        return serverBehaviour.getServer().getRuntime().getLocation();
    }
}

