/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.part.multiplexer;

import org.eclipse.jface.util.Assert;
import org.eclipse.ui.internal.components.ComponentUtil;
import org.eclipse.ui.internal.components.framework.IServiceProvider;
import org.eclipse.ui.internal.components.framework.ServiceFactory;
import org.eclipse.ui.internal.part.DelegatingServiceFactory;
import org.eclipse.ui.internal.part.multiplexer.MultiplexerChild;
import org.eclipse.ui.internal.part.multiplexer.NestedContext;

public class Multiplexer {
    private MultiplexerChild activePart;
    private IServiceProvider sharedComponents;
    private ServiceFactory context;
    private DelegatingServiceFactory delegatingContext;

    public Multiplexer(IServiceProvider sharedComponents) {
        this(sharedComponents, "org.eclipse.ui.site.multiplexer", "org.eclipse.ui.part.delegator", "org.eclipse.ui.site");
    }

    public Multiplexer(IServiceProvider sharedComponents, String inputScope, String outputScope, String parentScope) {
        this.sharedComponents = sharedComponents;
        this.context = ComponentUtil.getContext(inputScope);
        this.delegatingContext = new DelegatingServiceFactory(ComponentUtil.getContext(outputScope));
        ServiceFactory parentContext = ComponentUtil.getContext(parentScope);
        Assert.isTrue((boolean)sharedComponents.hasService(parentContext));
    }

    public NestedContext createNested() {
        return new NestedContext(this.sharedComponents, this.context);
    }

    public void setActive(MultiplexerChild newActive) {
        if (this.activePart != null) {
            this.activePart.getContext().deactivate(newActive == null ? null : newActive.getContext());
        }
        this.activePart = newActive;
        if (this.activePart != null) {
            this.activePart.getContext().activate(newActive.getPart());
            this.delegatingContext.setActive(this.activePart.getPart());
        } else {
            this.delegatingContext.setActive(null);
        }
    }

    public ServiceFactory getDelegatingContext() {
        return this.delegatingContext;
    }
}

