/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.subscribers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.Assert;
import org.eclipse.team.internal.core.Messages;
import org.eclipse.team.internal.core.Policy;
import org.eclipse.team.internal.core.TeamPlugin;

public class BatchingLock {
    private static final boolean DEBUG = Policy.DEBUG_THREADING;
    static final ISchedulingRule NULL_SCHEDULING_RULE = new ISchedulingRule(){

        public boolean contains(ISchedulingRule rule) {
            return false;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return false;
        }
    };
    private Map infos = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ThreadInfo getThreadInfo() {
        Thread thisThread = Thread.currentThread();
        Map map = this.infos;
        synchronized (map) {
            ThreadInfo info = (ThreadInfo)this.infos.get(thisThread);
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadInfo getThreadInfo(IResource resource) {
        Map map = this.infos;
        synchronized (map) {
            Iterator iter = this.infos.values().iterator();
            while (iter.hasNext()) {
                ThreadInfo info = (ThreadInfo)iter.next();
                if (!info.ruleContains(resource)) continue;
                return info;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISchedulingRule acquire(ISchedulingRule resourceRule, IFlushOperation operation, IProgressMonitor monitor) {
        ThreadInfo info = this.getThreadInfo();
        boolean added = false;
        Map map = this.infos;
        synchronized (map) {
            if (info == null) {
                info = this.createThreadInfo(operation);
                Thread thisThread = Thread.currentThread();
                this.infos.put(thisThread, info);
                added = true;
                if (DEBUG) {
                    System.out.println("[" + thisThread.getName() + "] acquired batching lock on " + resourceRule);
                }
            }
        }
        try {
            return info.pushRule(resourceRule, monitor);
        }
        catch (OperationCanceledException e) {
            if (added) {
                Map map2 = this.infos;
                synchronized (map2) {
                    this.infos.remove(Thread.currentThread());
                }
            }
            throw e;
        }
    }

    protected ThreadInfo createThreadInfo(IFlushOperation operation) {
        return new ThreadInfo(operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(ISchedulingRule rule, IProgressMonitor monitor) throws TeamException {
        ThreadInfo info = this.getThreadInfo();
        Assert.isNotNull(info, "Unmatched acquire/release.");
        Assert.isTrue(info.isNested(), "Unmatched acquire/release.");
        info.popRule(rule, monitor);
        Map map = this.infos;
        synchronized (map) {
            if (!info.isNested()) {
                Thread thisThread = Thread.currentThread();
                if (DEBUG) {
                    System.out.println("[" + thisThread.getName() + "] released batching lock");
                }
                this.infos.remove(thisThread);
            }
        }
    }

    public void resourceChanged(IResource resource) {
        ThreadInfo info = this.getThreadInfo();
        Assert.isNotNull(info, "Folder changed outside of resource lock");
        info.addChangedResource(resource);
    }

    public void flush(IProgressMonitor monitor) throws TeamException {
        ThreadInfo info = this.getThreadInfo();
        Assert.isNotNull(info, "Flush requested outside of resource lock");
        info.flush(monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWithinActiveOperationScope(IResource resource) {
        Map map = this.infos;
        synchronized (map) {
            return this.getThreadInfo(resource) != null;
        }
    }

    public class ThreadInfo {
        private Set changedResources = new HashSet();
        private IFlushOperation operation;
        private List rules = new ArrayList();

        public ThreadInfo(IFlushOperation operation) {
            this.operation = operation;
        }

        /*
         * Exception decompiling
         */
        public ISchedulingRule pushRule(ISchedulingRule resource, IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 76->82)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void popRule(ISchedulingRule rule, IProgressMonitor monitor) throws TeamException {
            ISchedulingRule stackedRule2;
            block5: {
                try {
                    if (this.isFlushRequired()) {
                        this.flush(monitor);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    ISchedulingRule stackedRule2 = this.removeRule();
                    if (rule == null) {
                        rule = NULL_SCHEDULING_RULE;
                    }
                    Assert.isTrue(stackedRule2.equals(rule), "end for resource '" + rule + "' does not match stacked rule '" + stackedRule2 + "'");
                    if (rule == NULL_SCHEDULING_RULE) throw throwable;
                    Platform.getJobManager().endRule(rule);
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                    stackedRule2 = this.removeRule();
                    if (rule != null) break block5;
                    rule = NULL_SCHEDULING_RULE;
                }
            }
            Assert.isTrue(stackedRule2.equals(rule), "end for resource '" + rule + "' does not match stacked rule '" + stackedRule2 + "'");
            if (rule == NULL_SCHEDULING_RULE) return;
            Platform.getJobManager().endRule(rule);
        }

        private ISchedulingRule getRuleForResoure(ISchedulingRule resourceRule) {
            Object rule;
            if (resourceRule instanceof IResource) {
                IResource resource = (IResource)resourceRule;
                rule = resource.getType() == 8 ? NULL_SCHEDULING_RULE : (resource.getType() == 4 ? resource : resource.getParent());
            } else if (resourceRule instanceof MultiRule) {
                ISchedulingRule[] rules = ((MultiRule)resourceRule).getChildren();
                HashSet<IProject> projects = new HashSet<IProject>();
                int i = 0;
                while (i < rules.length) {
                    ISchedulingRule childRule = rules[i];
                    if (childRule instanceof IResource) {
                        projects.add(((IResource)childRule).getProject());
                    }
                    ++i;
                }
                rule = projects.isEmpty() ? NULL_SCHEDULING_RULE : (projects.size() == 1 ? (ISchedulingRule)projects.iterator().next() : new MultiRule(projects.toArray(new ISchedulingRule[projects.size()])));
            } else {
                rule = NULL_SCHEDULING_RULE;
            }
            return rule;
        }

        public boolean isNested() {
            return !this.rules.isEmpty();
        }

        public void addChangedResource(IResource resource) {
            this.changedResources.add(resource);
        }

        public boolean isEmpty() {
            return this.changedResources.isEmpty();
        }

        public IResource[] getChangedResources() {
            return this.changedResources.toArray(new IResource[this.changedResources.size()]);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void flush(IProgressMonitor monitor) throws TeamException {
            try {
                try {
                    this.operation.flush(this, monitor);
                }
                catch (OutOfMemoryError e) {
                    throw e;
                }
                catch (Error e) {
                    this.handleAbortedFlush(e);
                    throw e;
                }
                catch (RuntimeException e) {
                    this.handleAbortedFlush(e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                this.changedResources.clear();
                throw throwable;
            }
            {
                Object var3_7 = null;
                this.changedResources.clear();
                return;
            }
        }

        private boolean isFlushRequired() {
            return this.rules.size() == 1 || this.remainingRulesAreNull();
        }

        private boolean remainingRulesAreNull() {
            int i = 0;
            while (i < this.rules.size() - 1) {
                ISchedulingRule rule = (ISchedulingRule)this.rules.get(i);
                if (rule != NULL_SCHEDULING_RULE) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private void handleAbortedFlush(Throwable t) {
            TeamPlugin.log(4, Messages.BatchingLock_11, t);
        }

        private void addRule(ISchedulingRule rule) {
            this.rules.add(rule);
        }

        private ISchedulingRule removeRule() {
            return (ISchedulingRule)this.rules.remove(this.rules.size() - 1);
        }

        public boolean ruleContains(IResource resource) {
            Iterator iter = this.rules.iterator();
            while (iter.hasNext()) {
                ISchedulingRule rule = (ISchedulingRule)iter.next();
                if (rule == NULL_SCHEDULING_RULE || !rule.contains((ISchedulingRule)resource)) continue;
                return true;
            }
            return false;
        }
    }

    public static interface IFlushOperation {
        public void flush(ThreadInfo var1, IProgressMonitor var2) throws TeamException;
    }
}

