/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.command.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.ws.internal.consumption.plugin.WebServiceConsumptionPlugin;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.uri.URIException;
import org.eclipse.wst.ws.internal.parser.discovery.NetUtils;
import org.eclipse.wst.ws.internal.parser.wsil.WWWAuthenticationException;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;
import org.eclipse.wst.wsdl.internal.impl.XSDSchemaExtensibilityElementImpl;
import org.eclipse.wst.wsdl.internal.impl.wsdl4j.WSDLFactoryImpl;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDParser;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CopyWSDLCommand
extends SimpleCommand {
    private String wsdlURI;
    private WebServicesParser webServicesParser;
    private String destinationURI;
    private Definition def;
    private Vector ignoreList;

    public CopyWSDLCommand() {
        super(WebServiceConsumptionPlugin.getMessage("COMMAND_LABEL_COPY_WSDL"), WebServiceConsumptionPlugin.getMessage("COMMAND_DESC_COPY_WSDL"));
    }

    public Status execute(Environment env) {
        try {
            this.ignoreList = new Vector();
            if (this.def == null) {
                this.def = this.webServicesParser.getWSDLDefinition(this.wsdlURI);
            }
            this.copyWSDL(env, this.wsdlURI, this.getBaseURI(this.destinationURI), this.getLocalname(this.destinationURI), this.def);
            return new SimpleStatus("");
        }
        catch (Throwable t) {
            t.printStackTrace();
            SimpleStatus status = new SimpleStatus("org.eclipse.jst.ws.consumption", WebServiceConsumptionPlugin.getMessage("MSG_ERROR_COPY_WSDL", new String[]{this.wsdlURI, this.destinationURI}), 4, t);
            env.getStatusHandler().reportError((Status)status);
            return status;
        }
    }

    private void copyWSDL(Environment env, String uri, String destURI, String destLocalname) throws WSDLException, IOException, WWWAuthenticationException, TransformerException, TransformerConfigurationException, URIException {
        try {
            Definition definition = this.webServicesParser.getWSDLDefinitionVerbose(uri);
            this.copyWSDL(env, uri, destURI, destLocalname, definition);
        }
        catch (WSDLException wSDLException) {
            this.copyXMLSchema(env, uri, destURI);
        }
    }

    private void copyWSDL(Environment env, String uri, String destURI, String destLocalname, Definition definition) throws WSDLException, IOException, WWWAuthenticationException, TransformerException, TransformerConfigurationException, URIException {
        if (this.ignoreList.contains(uri)) {
            return;
        }
        this.ignoreList.add(uri);
        this.wsdlURI.lastIndexOf(47);
        String baseURI = this.getBaseURI(this.wsdlURI);
        if (destLocalname == null || destLocalname.length() <= 0) {
            destLocalname = this.getLocalname(this.wsdlURI);
        }
        StringBuffer destinationFileURI = new StringBuffer(this.addTrailingSeparator(destURI));
        destinationFileURI.append(destLocalname);
        WSDLFactoryImpl wsdlFactory = new WSDLFactoryImpl();
        WSDLWriter wsdlWriter = wsdlFactory.newWSDLWriter();
        OutputStream os = env.getURIFactory().newURI(destinationFileURI.toString()).getOutputStream();
        wsdlWriter.writeWSDL(definition, os);
        os.close();
        Map imports = definition.getImports();
        Iterator it = imports.values().iterator();
        while (it.hasNext()) {
            List list = (List)it.next();
            Iterator listIt = list.iterator();
            while (listIt.hasNext()) {
                Import wsdlImport = (Import)listIt.next();
                String wsdlImportURI = wsdlImport.getLocationURI();
                if (!this.isRelative(wsdlImportURI)) continue;
                String importBaseURI = baseURI + wsdlImportURI;
                String wsdlImportBaseURI = this.getBaseURI(wsdlImportURI);
                StringBuffer importDestURI = new StringBuffer(destURI);
                if (wsdlImportBaseURI != null) {
                    importDestURI.append(wsdlImportBaseURI);
                }
                this.copyWSDL(env, importBaseURI, importDestURI.toString(), this.getLocalname(wsdlImportURI));
            }
        }
        Types types = definition.getTypes();
        if (types != null) {
            List schemas = types.getExtensibilityElements();
            Iterator it2 = schemas.iterator();
            while (it2.hasNext()) {
                XSDSchema xsdSchema;
                UnknownExtensibilityElement schemaElement;
                ExtensibilityElement extElement = (ExtensibilityElement)it2.next();
                if (extElement instanceof UnknownExtensibilityElement) {
                    schemaElement = (UnknownExtensibilityElement)extElement;
                    xsdSchema = null;
                    try {
                        xsdSchema = XSDSchemaImpl.createSchema((Node)schemaElement.getElement());
                    }
                    catch (Throwable throwable) {}
                    this.copyXMLSchema(env, xsdSchema, baseURI, destURI);
                    continue;
                }
                if (!(extElement instanceof XSDSchemaExtensibilityElementImpl)) continue;
                schemaElement = (XSDSchemaExtensibilityElementImpl)extElement;
                xsdSchema = null;
                try {
                    xsdSchema = XSDSchemaImpl.createSchema((Node)schemaElement.getElement());
                }
                catch (Throwable throwable) {}
                this.copyXMLSchema(env, xsdSchema, baseURI, destURI);
            }
        }
    }

    private String getBaseURI(String uri) {
        int index = uri.lastIndexOf(47);
        if (index == -1) {
            index = uri.lastIndexOf(92);
        }
        if (index != -1) {
            return uri.substring(0, index + 1);
        }
        return null;
    }

    private String getLocalname(String uri) {
        int index = uri.lastIndexOf(47);
        if (index == -1) {
            index = uri.lastIndexOf(92);
        }
        if (index != -1) {
            return uri.substring(index + 1);
        }
        return uri;
    }

    private String addTrailingSeparator(String s) {
        if (!s.endsWith("/") && !s.endsWith("\\")) {
            StringBuffer sb = new StringBuffer(s);
            sb.append('/');
            return sb.toString();
        }
        return s;
    }

    private boolean isRelative(String uri) {
        return uri.indexOf(58) == -1;
    }

    private void copyXMLSchema(Environment env, String uri, String destURI) throws TransformerException, TransformerConfigurationException, IOException, URIException {
        if (this.ignoreList.contains(uri)) {
            return;
        }
        this.ignoreList.add(uri);
        XSDSchema xsdSchema = XSDSchemaImpl.getSchemaForSchema((String)uri);
        if (xsdSchema == null) {
            XSDParser p = new XSDParser();
            InputStream is = NetUtils.getURLInputStream((String)uri);
            if (is != null) {
                p.parse(is);
                xsdSchema = p.getSchema();
            }
        }
        if (xsdSchema != null) {
            Element e = xsdSchema.getElement();
            DOMSource domSource = new DOMSource(e);
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("encoding", "UTF-8");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            OutputStream os = env.getURIFactory().newURI(destURI + this.getLocalname(uri)).getOutputStream();
            serializer.transform(domSource, new StreamResult(os));
            os.close();
            this.copyXMLSchema(env, xsdSchema, this.getBaseURI(uri), destURI);
        }
    }

    private void copyXMLSchema(Environment env, XSDSchema xsdSchema, String baseURI, String destURI) throws TransformerException, TransformerConfigurationException, IOException, URIException {
        if (xsdSchema != null) {
            EList xsdSchemaContents = xsdSchema.getContents();
            Iterator it = xsdSchemaContents.iterator();
            while (it.hasNext()) {
                XSDSchemaDirective xsdSchemaDirective;
                String xsdSchemaDirectiveLocation;
                Object content = it.next();
                if (!(content instanceof XSDSchemaDirective) || (xsdSchemaDirectiveLocation = (xsdSchemaDirective = (XSDSchemaDirective)content).getSchemaLocation()) == null || !this.isRelative(xsdSchemaDirectiveLocation)) continue;
                String directiveURI = baseURI + xsdSchemaDirectiveLocation;
                String directiveBaseURI = this.getBaseURI(xsdSchemaDirectiveLocation);
                StringBuffer directiveDestURI = new StringBuffer(destURI);
                if (directiveBaseURI != null) {
                    directiveDestURI.append(directiveBaseURI);
                }
                this.copyXMLSchema(env, directiveURI, directiveDestURI.toString());
            }
        }
    }

    public void setWsdlURI(String wsdlURI) {
        this.wsdlURI = wsdlURI;
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        this.webServicesParser = webServicesParser;
    }

    public void setDestinationURI(String destinationURI) {
        this.destinationURI = destinationURI;
    }

    public void setDefinition(Definition def) {
        this.def = def;
    }
}

