/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.sampleapp.command;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.ws.internal.consumption.codegen.Generator;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.MessageUtils;
import org.eclipse.wst.command.internal.provisional.env.core.common.ProgressMonitor;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.command.internal.provisional.env.core.common.StatusHandler;
import org.eclipse.wst.command.internal.provisional.env.core.context.ResourceContext;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.Model;

public class GeneratePageCommand
extends SimpleCommand {
    private String LABEL = "GeneratePageCommand";
    private String DESCRIPTION = "Generate code based on the model";
    private MessageUtils msgUtils_;
    private Model model_;
    private Generator fGenerator;
    private IFile fIFile;
    private ResourceContext resourceContext_;
    private StringBuffer fStringBuffer;
    private Element rootElement_;

    public GeneratePageCommand() {
        String pluginId = "org.eclipse.jst.ws.consumption";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.setDescription(this.DESCRIPTION);
        this.setName(this.LABEL);
    }

    public GeneratePageCommand(ResourceContext context, Model model, Generator generator, IFile file) {
        String pluginId = "org.eclipse.jst.ws.consumption";
        this.msgUtils_ = new MessageUtils(String.valueOf(pluginId) + ".plugin", (Object)this);
        this.setDescription(this.DESCRIPTION);
        this.setName(this.LABEL);
        this.model_ = model;
        this.fGenerator = generator;
        this.fIFile = file;
        this.resourceContext_ = context;
    }

    public Model getDataModel() {
        return this.model_;
    }

    public Status execute(Environment env) {
        SimpleStatus status = new SimpleStatus("");
        try {
            this.fGenerator.visit(this.model_.getRootElement());
            this.fStringBuffer = this.fGenerator.getStringBuffer();
            String tempString = this.fStringBuffer.toString();
            OutputStream fileResource = FileResourceUtils.newFileOutputStream((ResourceContext)this.resourceContext_, (IPath)this.fIFile.getFullPath(), (ProgressMonitor)env.getProgressMonitor(), (StatusHandler)env.getStatusHandler());
            OutputStreamWriter osw = new OutputStreamWriter(fileResource, "UTF-8");
            osw.write(tempString, 0, this.fStringBuffer.length());
            osw.close();
            fileResource.close();
            return status;
        }
        catch (IOException ioexc) {
            status = new SimpleStatus("", ioexc.getMessage(), 4);
            return status;
        }
    }

    public void setRootElement(Element rootElement) {
        this.rootElement_ = rootElement;
    }
}

