/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.beaninfo.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jem.internal.beaninfo.ui.BeanInfoUIMessages;
import org.eclipse.jem.internal.beaninfo.ui.BeaninfoPathsBlock;
import org.eclipse.jem.internal.ui.core.JEMUIPlugin;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.PropertyPage;

public class BeaninfosPropertyPage
extends PropertyPage
implements IStatusChangeListener {
    private BeaninfoPathsBlock fBuildPathsBlock;
    private IResourceChangeListener listener;
    private IProject project;
    static /* synthetic */ Class class$0;

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        this.project = this.getProject();
        if (this.project == null || !this.isJavaProject(this.project)) {
            return this.createWithoutJava(parent);
        }
        if (!this.project.isOpen()) {
            return this.createForClosedProject(parent);
        }
        return this.createWithJava(parent);
    }

    private Control createWithJava(Composite parent) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.fBuildPathsBlock = new BeaninfoPathsBlock(root, this);
        final IJavaProject jproject = JavaCore.create((IProject)this.project);
        this.fBuildPathsBlock.init(jproject);
        final IPath classpathfile = this.project.getFile(".classpath").getFullPath();
        this.listener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                if (BeaninfosPropertyPage.this.fBuildPathsBlock != null && event.getDelta().findMember(classpathfile) != null) {
                    BeaninfosPropertyPage.this.getControl().getDisplay().asyncExec(new Runnable(this, jproject){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ IJavaProject val$jproject;
                        {
                            this.this$1 = var1_1;
                            this.val$jproject = iJavaProject;
                        }

                        public void run() {
                            BeaninfosPropertyPage.access$0(1.access$0(this.this$1)).init(this.val$jproject);
                        }
                    });
                }
            }

            static /* synthetic */ BeaninfosPropertyPage access$0(1 var0) {
                return var0.BeaninfosPropertyPage.this;
            }
        };
        this.project.getWorkspace().addResourceChangeListener(this.listener, 1);
        return this.fBuildPathsBlock.createControl(parent);
    }

    private Control createWithoutJava(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(BeanInfoUIMessages.BeaninfoPropertiesPage_INFO__nojavaproject);
        this.fBuildPathsBlock = null;
        this.setValid(true);
        return label;
    }

    private Control createForClosedProject(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(BeanInfoUIMessages.BeaninfoPropertiesPage_INFO__closedproject);
        this.fBuildPathsBlock = null;
        this.setValid(true);
        return label;
    }

    private IProject getProject() {
        IAdaptable adaptable = this.getElement();
        if (adaptable != null) {
            IJavaElement elem;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((elem = (IJavaElement)adaptable.getAdapter((Class)clazz)) instanceof IJavaProject) {
                return ((IJavaProject)elem).getProject();
            }
        }
        return null;
    }

    private boolean isJavaProject(IProject proj) {
        try {
            return proj.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException e) {
            JEMUIPlugin.getPlugin().getLogger().log((Object)e.getStatus());
            return false;
        }
    }

    public boolean performOk() {
        if (this.fBuildPathsBlock != null) {
            IRunnableWithProgress runnable = this.fBuildPathsBlock.getRunnable();
            WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
            Shell shell = this.getControl().getShell();
            try {
                PlatformUI.getWorkbench().getProgressService().run(false, false, (IRunnableWithProgress)op);
            }
            catch (InvocationTargetException e) {
                String title = BeanInfoUIMessages.Beaninfo_UI__errortitle;
                String message = BeanInfoUIMessages.Beaninfo_UI__error;
                ExceptionHandler.handle((InvocationTargetException)e, (Shell)shell, (String)title, (String)message);
                return false;
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        return true;
    }

    public void statusChanged(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, (IStatus)status);
    }

    public void dispose() {
        if (this.listener != null) {
            this.project.getWorkspace().removeResourceChangeListener(this.listener);
        }
        this.listener = null;
        super.dispose();
    }
}

