/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSCoreFileModificationValidator;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.actions.EditorsAction;
import org.eclipse.ui.progress.IProgressConstants;
import org.osgi.framework.Bundle;

public class FileModificationValidator
extends CVSCoreFileModificationValidator {
    protected IStatus edit(IFile[] readOnlyFiles, Object context) {
        return this.edit(readOnlyFiles, this.getShell(context));
    }

    private Shell getShell(Object context) {
        if (context instanceof Shell) {
            return (Shell)context;
        }
        return null;
    }

    private IStatus getStatus(InvocationTargetException e) {
        Throwable target = e.getTargetException();
        if (target instanceof TeamException) {
            return ((TeamException)target).getStatus();
        }
        if (target instanceof CoreException) {
            return ((CoreException)target).getStatus();
        }
        return new Status(4, "org.eclipse.team.cvs.ui", 0, CVSUIMessages.internal, target);
    }

    private IStatus edit(final IFile[] files, Shell shell) {
        if (this.isPerformEdit()) {
            try {
                if (shell != null && !this.promptToEditFiles(files, shell)) {
                    throw new InterruptedException();
                }
                IRunnableWithProgress editRunnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            FileModificationValidator.this.performEdit(files, monitor);
                        }
                        catch (CVSException e) {
                            new InvocationTargetException(e);
                        }
                    }
                };
                if (this.isRunningInUIThread()) {
                    CVSUIPlugin.runWithProgress(shell, false, editRunnable);
                }
                editRunnable.run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (InvocationTargetException e) {
                return this.getStatus(e);
            }
            catch (InterruptedException interruptedException) {
                return new Status(8, "org.eclipse.team.cvs.ui", 0, CVSUIMessages.FileModificationValidator_vetoMessage, null);
            }
        } else {
            if (this.isPerformEditInBackground()) {
                IStatus status = this.setWritable(files);
                if (status.isOK()) {
                    this.performEdit(files);
                }
                return status;
            }
            return this.setWritable(files);
        }
        return Status.OK_STATUS;
    }

    protected void scheduleEditJob(Job job) {
        job.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, (Object)Boolean.TRUE);
        job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)this.getOperationIcon());
        super.scheduleEditJob(job);
    }

    private URL getOperationIcon() {
        return Platform.find((Bundle)CVSUIPlugin.getPlugin().getBundle(), (IPath)new Path("$nl$/icons/full/eview16/cvs_persp.gif"));
    }

    private boolean isRunningInUIThread() {
        return Display.getCurrent() != null;
    }

    private boolean promptToEditFiles(IFile[] files, Shell shell) throws InvocationTargetException, InterruptedException {
        if (files.length == 0) {
            return true;
        }
        if (this.isNeverPrompt()) {
            return true;
        }
        EditorsAction editors = this.fetchEditors(files, shell);
        if (editors.isEmpty()) {
            if (this.isAlwaysPrompt()) {
                return this.promptEdit(shell);
            }
            return true;
        }
        return editors.promptToEdit(shell);
    }

    private boolean promptEdit(Shell shell) {
        final boolean[] result = new boolean[1];
        int flags = this.isRunningInUIThread() ? 0 : 1;
        CVSUIPlugin.openDialog(shell, new CVSUIPlugin.IOpenableInShell(){

            public void open(Shell shell) {
                result[0] = MessageDialog.openQuestion((Shell)shell, (String)CVSUIMessages.FileModificationValidator_3, (String)CVSUIMessages.FileModificationValidator_4);
            }
        }, flags);
        return result[0];
    }

    private boolean isPerformEdit() {
        return "edit".equals(CVSUIPlugin.getPlugin().getPreferenceStore().getString("pref_edit_action"));
    }

    private boolean isPerformEditInBackground() {
        return "editInBackground".equals(CVSUIPlugin.getPlugin().getPreferenceStore().getString("pref_edit_action"));
    }

    private EditorsAction fetchEditors(IFile[] files, Shell shell) throws InvocationTargetException, InterruptedException {
        final EditorsAction editors = new EditorsAction(this.getProvider(files), (IResource[])files);
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                editors.run(monitor);
            }
        };
        if (this.isRunningInUIThread()) {
            CVSUIPlugin.runWithProgress(shell, false, runnable);
        } else {
            runnable.run((IProgressMonitor)new NullProgressMonitor());
        }
        return editors;
    }

    private boolean isNeverPrompt() {
        return "never".equals(CVSUIPlugin.getPlugin().getPreferenceStore().getString("pref_edit_prompt"));
    }

    private boolean isAlwaysPrompt() {
        return "always".equals(CVSUIPlugin.getPlugin().getPreferenceStore().getString("pref_edit_prompt"));
    }
}

