/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.repo;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.IConnectionMethod;
import org.eclipse.team.internal.ccvs.core.IUserInfo;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryRoot;
import org.eclipse.team.internal.ccvs.ui.wizards.ConfigurationWizardMainPage;
import org.eclipse.team.internal.ui.dialogs.DetailsDialogWithProjects;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.PropertyPage;

public class CVSRepositoryPropertiesPage
extends PropertyPage {
    private static final String FAKE_PASSWORD = "*********";
    ICVSRepositoryLocation location;
    Text userText;
    Text passwordText;
    Combo methodType;
    Text hostText;
    Text pathText;
    private Text portText;
    private Button useDefaultPort;
    private Button useCustomPort;
    private Button allowCachingButton;
    private boolean allowCaching = false;
    boolean passwordChanged;
    boolean connectionInfoChanged;
    IUserInfo info;
    private Button useLocationAsLabel;
    private Button useCustomLabel;
    private Text labelText;
    static /* synthetic */ Class class$0;

    protected Control createContents(Composite parent) {
        this.initialize();
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        Composite labelGroup = new Composite(composite, 0);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        labelGroup.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        labelGroup.setLayout((Layout)layout);
        Listener labelListener = new Listener(){

            public void handleEvent(Event event) {
                CVSRepositoryPropertiesPage.this.updateWidgetEnablements();
            }
        };
        this.useLocationAsLabel = this.createRadioButton(labelGroup, CVSUIMessages.CVSRepositoryPropertiesPage_useLocationAsLabel, 3);
        this.useCustomLabel = this.createRadioButton(labelGroup, CVSUIMessages.CVSRepositoryPropertiesPage_useCustomLabel, 1);
        this.useCustomLabel.addListener(13, labelListener);
        this.labelText = this.createTextField(labelGroup);
        this.labelText.addListener(24, labelListener);
        this.createLabel(composite, "", 3);
        this.createLabel(composite, CVSUIMessages.CVSPropertiesPage_connectionType, 1);
        this.methodType = this.createCombo(composite);
        this.createLabel(composite, CVSUIMessages.CVSPropertiesPage_user, 1);
        this.userText = this.createTextField(composite);
        this.createLabel(composite, CVSUIMessages.CVSPropertiesPage_password, 1);
        this.passwordText = this.createPasswordField(composite);
        this.createLabel(composite, CVSUIMessages.CVSPropertiesPage_host, 1);
        this.hostText = this.createTextField(composite);
        this.createLabel(composite, CVSUIMessages.CVSPropertiesPage_path, 1);
        this.pathText = this.createTextField(composite);
        Composite portGroup = new Composite(composite, 0);
        data = new GridData();
        data.horizontalSpan = 3;
        portGroup.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        portGroup.setLayout((Layout)layout);
        this.useDefaultPort = this.createRadioButton(portGroup, CVSUIMessages.ConfigurationWizardMainPage_useDefaultPort, 3);
        this.useCustomPort = this.createRadioButton(portGroup, CVSUIMessages.ConfigurationWizardMainPage_usePort, 1);
        this.portText = this.createTextField(portGroup);
        this.createLabel(composite, "", 3);
        this.allowCachingButton = new Button(composite, 32);
        this.allowCachingButton.setText(CVSUIMessages.UserValidationDialog_6);
        data = new GridData(768);
        data.horizontalSpan = 3;
        this.allowCachingButton.setLayoutData((Object)data);
        this.allowCachingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CVSRepositoryPropertiesPage.this.allowCaching = CVSRepositoryPropertiesPage.this.allowCachingButton.getSelection();
            }
        });
        Composite warningComposite = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginHeight = 0;
        warningComposite.setLayout((Layout)layout);
        data = new GridData(768);
        data.horizontalSpan = 3;
        warningComposite.setLayoutData((Object)data);
        Label warningLabel = new Label(warningComposite, 0);
        warningLabel.setImage(Dialog.getImage((String)"dialog_messasge_warning_image"));
        warningLabel.setLayoutData((Object)new GridData(34));
        Label warningText = new Label(warningComposite, 64);
        warningText.setText(CVSUIMessages.UserValidationDialog_7);
        data = new GridData(768);
        data.widthHint = 300;
        warningText.setLayoutData((Object)data);
        this.createLabel(composite, "", 3);
        this.initializeValues();
        this.updateWidgetEnablements();
        Listener connectionInfoChangedListener = new Listener(){

            public void handleEvent(Event event) {
                CVSRepositoryPropertiesPage.this.connectionInfoChanged = true;
                CVSRepositoryPropertiesPage.this.updateWidgetEnablements();
            }
        };
        this.passwordText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                CVSRepositoryPropertiesPage.this.passwordChanged = !CVSRepositoryPropertiesPage.this.passwordText.getText().equals(CVSRepositoryPropertiesPage.FAKE_PASSWORD);
            }
        });
        this.userText.addListener(24, connectionInfoChangedListener);
        this.methodType.addListener(24, connectionInfoChangedListener);
        this.hostText.addListener(24, connectionInfoChangedListener);
        this.portText.addListener(24, connectionInfoChangedListener);
        this.useCustomPort.addListener(13, connectionInfoChangedListener);
        this.pathText.addListener(24, connectionInfoChangedListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.team.cvs.ui.repository_location_property_page_context");
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected Combo createCombo(Composite parent) {
        Combo combo = new Combo(parent, 8);
        GridData data = new GridData(768);
        data.widthHint = 200;
        data.horizontalSpan = 2;
        combo.setLayoutData((Object)data);
        return combo;
    }

    protected Label createLabel(Composite parent, String text, int span) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalSpan = span;
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    protected Text createTextField(Composite parent) {
        Text text = new Text(parent, 2052);
        return this.layoutTextField(text);
    }

    protected Text createPasswordField(Composite parent) {
        Text text = new Text(parent, 0x400804);
        return this.layoutTextField(text);
    }

    protected Text layoutTextField(Text text) {
        GridData data = new GridData(768);
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        data.widthHint = 200;
        data.horizontalSpan = 2;
        text.setLayoutData((Object)data);
        return text;
    }

    protected Button createRadioButton(Composite parent, String label, int span) {
        Button button = new Button(parent, 16);
        button.setText(label);
        GridData data = new GridData();
        data.horizontalSpan = span;
        button.setLayoutData((Object)data);
        return button;
    }

    private void initialize() {
        this.location = null;
        IAdaptable element = this.getElement();
        if (element instanceof ICVSRepositoryLocation) {
            this.location = (ICVSRepositoryLocation)element;
        } else {
            Object adapter;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = element.getAdapter((Class)clazz)) instanceof ICVSRepositoryLocation) {
                this.location = (ICVSRepositoryLocation)adapter;
            }
        }
    }

    private void initializeValues() {
        this.passwordChanged = false;
        this.connectionInfoChanged = false;
        IConnectionMethod[] methods = CVSRepositoryLocation.getPluggedInConnectionMethods();
        int i = 0;
        while (i < methods.length) {
            this.methodType.add(methods[i].getName());
            ++i;
        }
        String method = this.location.getMethod().getName();
        this.methodType.select(this.methodType.indexOf(method));
        this.info = this.location.getUserInfo(true);
        this.userText.setText(this.info.getUsername());
        this.passwordText.setText(FAKE_PASSWORD);
        this.hostText.setText(this.location.getHost());
        int port = this.location.getPort();
        if (port == 0) {
            this.useDefaultPort.setSelection(true);
            this.useCustomPort.setSelection(false);
            this.portText.setEnabled(false);
        } else {
            this.useDefaultPort.setSelection(false);
            this.useCustomPort.setSelection(true);
            this.portText.setText("" + port);
        }
        this.pathText.setText(this.location.getRootDirectory());
        this.allowCachingButton.setSelection(this.location.getUserInfoCached());
        String label = null;
        RepositoryRoot root = CVSUIPlugin.getPlugin().getRepositoryManager().getRepositoryRootFor(this.location);
        label = root.getName();
        this.useLocationAsLabel.setSelection(label == null);
        this.useCustomLabel.setSelection(!this.useLocationAsLabel.getSelection());
        if (label == null) {
            label = this.location.getLocation(true);
        }
        this.labelText.setText(label);
    }

    private boolean performConnectionInfoChanges() {
        if (!this.connectionInfoChanged) {
            this.location.setAllowCaching(this.allowCaching);
            if (!this.passwordChanged) {
                ((CVSRepositoryLocation)this.location).updateCache();
            }
        }
        if (!this.passwordChanged && !this.connectionInfoChanged) {
            return true;
        }
        try {
            if (this.passwordChanged && !this.connectionInfoChanged) {
                CVSRepositoryLocation oldLocation = (CVSRepositoryLocation)this.location;
                oldLocation.setPassword(this.getNewPassword());
                if (this.allowCaching) {
                    oldLocation.updateCache();
                }
                this.passwordChanged = false;
                return true;
            }
            if (!(this.location.getHost().equals(this.hostText.getText()) && this.location.getRootDirectory().equals(this.pathText.getText()) || MessageDialog.openConfirm((Shell)this.getShell(), (String)CVSUIMessages.CVSRepositoryPropertiesPage_0, (String)CVSUIMessages.CVSRepositoryPropertiesPage_1))) {
                return false;
            }
            final boolean[] result = new boolean[1];
            final ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
            progressMonitorDialog.run(false, false, (IRunnableWithProgress)new WorkspaceModifyOperation(null){

                /*
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void execute(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        CVSRepositoryLocation newLocation;
                        block14: {
                            block13: {
                                newLocation = CVSRepositoryLocation.fromProperties((Properties)CVSRepositoryPropertiesPage.this.createProperties());
                                CVSRepositoryPropertiesPage.this.location.setAllowCaching(CVSRepositoryPropertiesPage.this.allowCaching);
                                try {
                                    block12: {
                                        ArrayList<IProject> projects = new ArrayList<IProject>();
                                        IProject[] allProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                                        int i = 0;
                                        while (true) {
                                            CVSTeamProvider cvsProvider;
                                            if (i >= allProjects.length) {
                                                if (projects.size() <= 0) break block12;
                                                DetailsDialogWithProjects dialog = new DetailsDialogWithProjects(progressMonitorDialog.getShell(), CVSUIMessages.CVSRepositoryPropertiesPage_Confirm_Project_Sharing_Changes_1, CVSUIMessages.CVSRepositoryPropertiesPage_There_are_projects_in_the_workspace_shared_with_this_repository_2, NLS.bind((String)CVSUIMessages.CVSRepositoryPropertiesPage_sharedProject, (Object[])new String[]{CVSRepositoryPropertiesPage.this.location.toString()}), projects.toArray(new IProject[projects.size()]), true, "dialog_warning_image");
                                                int r = dialog.open();
                                                if (r == 0) break;
                                                result[0] = false;
                                                Object var13_11 = null;
                                                break block13;
                                            }
                                            RepositoryProvider teamProvider = RepositoryProvider.getProvider((IProject)allProjects[i], (String)CVSProviderPlugin.getTypeId());
                                            if (teamProvider != null && (cvsProvider = (CVSTeamProvider)teamProvider).getCVSWorkspaceRoot().getRemoteLocation().equals(CVSRepositoryPropertiesPage.this.location)) {
                                                projects.add(allProjects[i]);
                                            }
                                            ++i;
                                        }
                                        monitor.beginTask(null, 1000 * projects.size());
                                        try {
                                            Iterator it = projects.iterator();
                                            while (it.hasNext()) {
                                                IProject project = (IProject)it.next();
                                                RepositoryProvider teamProvider = RepositoryProvider.getProvider((IProject)project, (String)CVSProviderPlugin.getTypeId());
                                                CVSTeamProvider cvsProvider = (CVSTeamProvider)teamProvider;
                                                cvsProvider.setRemoteRoot((ICVSRepositoryLocation)newLocation, Policy.subMonitorFor(monitor, 1000));
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            Object var11_18 = null;
                                            monitor.done();
                                            throw throwable;
                                        }
                                        {
                                            Object var11_19 = null;
                                        }
                                        monitor.done();
                                    }
                                    CVSUIPlugin.getPlugin().getRepositoryManager().replaceRepositoryLocation(CVSRepositoryPropertiesPage.this.location, newLocation);
                                    break block14;
                                }
                                catch (Throwable throwable) {
                                    Object var13_12 = null;
                                    newLocation = (CVSRepositoryLocation)KnownRepositories.getInstance().addRepository((ICVSRepositoryLocation)newLocation, !KnownRepositories.getInstance().isKnownRepository(newLocation.getLocation()));
                                    throw throwable;
                                }
                            }
                            newLocation = (CVSRepositoryLocation)KnownRepositories.getInstance().addRepository((ICVSRepositoryLocation)newLocation, !KnownRepositories.getInstance().isKnownRepository(newLocation.getLocation()));
                            return;
                        }
                        Object var13_13 = null;
                        newLocation = (CVSRepositoryLocation)KnownRepositories.getInstance().addRepository((ICVSRepositoryLocation)newLocation, !KnownRepositories.getInstance().isKnownRepository(newLocation.getLocation()));
                        CVSRepositoryPropertiesPage.this.location = newLocation;
                        CVSRepositoryPropertiesPage.this.connectionInfoChanged = false;
                        CVSRepositoryPropertiesPage.this.passwordChanged = false;
                    }
                    catch (TeamException e) {
                        throw new InvocationTargetException(e);
                    }
                    result[0] = true;
                }
            });
            return result[0];
        }
        catch (InvocationTargetException e) {
            this.handle(e);
        }
        catch (InterruptedException interruptedException) {}
        return false;
    }

    private void performNonConnectionInfoChanges() {
        this.recordNewLabel((CVSRepositoryLocation)this.location);
    }

    public boolean performOk() {
        if (this.performConnectionInfoChanges()) {
            this.performNonConnectionInfoChanges();
            return true;
        }
        return false;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeValues();
    }

    protected void handle(Throwable e) {
        CVSUIPlugin.openError(this.getShell(), null, null, e);
    }

    protected void updateWidgetEnablements() {
        if (this.useLocationAsLabel.getSelection()) {
            this.labelText.setEnabled(false);
        } else {
            this.labelText.setEnabled(true);
        }
        if (this.useDefaultPort.getSelection()) {
            this.portText.setEnabled(false);
        } else {
            this.portText.setEnabled(true);
        }
        this.validateFields();
    }

    private void validateFields() {
        String port;
        if (this.labelText.isEnabled() && this.labelText.getText().length() == 0) {
            this.setValid(false);
            return;
        }
        String user = this.userText.getText();
        IStatus status = ConfigurationWizardMainPage.validateUserName(user);
        if (!this.isStatusOK(status)) {
            return;
        }
        String host = this.hostText.getText();
        status = ConfigurationWizardMainPage.validateHost(host);
        if (!this.isStatusOK(status)) {
            return;
        }
        if (this.portText.isEnabled() && !this.isStatusOK(status = ConfigurationWizardMainPage.validatePort(port = this.portText.getText()))) {
            return;
        }
        String pathString = this.pathText.getText();
        status = ConfigurationWizardMainPage.validatePath(pathString);
        if (!this.isStatusOK(status)) {
            return;
        }
        try {
            CVSRepositoryLocation l = CVSRepositoryLocation.fromProperties((Properties)this.createProperties());
            if (!l.equals((Object)this.location) && KnownRepositories.getInstance().isKnownRepository(l.getLocation())) {
                this.setErrorMessage(CVSUIMessages.ConfigurationWizardMainPage_0);
                this.setValid(false);
                return;
            }
        }
        catch (CVSException e) {
            CVSUIPlugin.log((CoreException)((Object)e));
        }
        this.setErrorMessage(null);
        this.setValid(true);
    }

    private boolean isStatusOK(IStatus status) {
        if (!status.isOK()) {
            this.setErrorMessage(status.getMessage());
            this.setValid(false);
            return false;
        }
        return true;
    }

    private void recordNewLabel(CVSRepositoryLocation location) {
        String oldLabel;
        String newLabel = this.getNewLabel(location);
        if (newLabel == null ? (oldLabel = this.getOldLabel(location)) == null || oldLabel.equals(location.getLocation()) : newLabel.equals(this.getOldLabel(location))) {
            return;
        }
        CVSUIPlugin.getPlugin().getRepositoryManager().setLabel(location, newLabel);
    }

    private String getOldLabel(CVSRepositoryLocation location) {
        return CVSUIPlugin.getPlugin().getRepositoryManager().getRepositoryRootFor((ICVSRepositoryLocation)location).getName();
    }

    private String getNewLabel(CVSRepositoryLocation location) {
        String label = null;
        if (this.useCustomLabel.getSelection() && (label = this.labelText.getText()).equals(location.getLocation())) {
            label = null;
        }
        return label;
    }

    String getNewPassword() {
        return this.passwordText.getText();
    }

    private Properties createProperties() {
        Properties result = new Properties();
        result.setProperty("connection", this.methodType.getText());
        result.setProperty("user", this.userText.getText());
        if (this.passwordChanged) {
            result.setProperty("password", this.passwordText.getText());
        }
        result.setProperty("host", this.hostText.getText());
        if (this.useCustomPort.getSelection()) {
            result.setProperty("port", this.portText.getText());
        }
        result.setProperty("root", this.pathText.getText());
        return result;
    }
}

