/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.IMemento;
import org.eclipse.wst.server.core.internal.ModuleEvent;
import org.eclipse.wst.server.core.internal.ModuleFactoryEvent;
import org.eclipse.wst.server.core.internal.ProgressUtil;
import org.eclipse.wst.server.core.internal.ProjectProperties;
import org.eclipse.wst.server.core.internal.ResourceManager;
import org.eclipse.wst.server.core.internal.Runtime;
import org.eclipse.wst.server.core.internal.RuntimeType;
import org.eclipse.wst.server.core.internal.RuntimeWorkingCopy;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerListener;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.ServerType;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.internal.XMLMemento;

public class ResourceManager {
    private static final String SERVER_DATA_FILE = "servers.xml";
    private static final byte EVENT_ADDED = 0;
    private static final byte EVENT_CHANGED = 1;
    private static final byte EVENT_REMOVED = 2;
    private static ResourceManager instance;
    protected List runtimes;
    protected List servers;
    protected IRuntime defaultRuntime;
    protected transient List runtimeListeners;
    protected transient List serverListeners;
    protected List activeBundles;
    private IResourceChangeListener modelResourceChangeListener;
    private IResourceChangeListener publishResourceChangeListener;
    private Preferences.IPropertyChangeListener pcl;
    protected boolean ignorePreferenceChanges = false;
    protected List moduleServerEventHandlers;
    protected List moduleServerEventHandlerIndexes;
    static /* synthetic */ Class class$0;

    private ResourceManager() {
        instance = this;
        this.init();
    }

    protected void init() {
        this.servers = new ArrayList();
        this.activeBundles = new ArrayList();
        this.loadRuntimesList();
        this.loadServersList();
        this.pcl = new Preferences.IPropertyChangeListener(){

            public void propertyChange(Preferences.PropertyChangeEvent event) {
                if (ResourceManager.this.ignorePreferenceChanges) {
                    return;
                }
                String property = event.getProperty();
                if (property.equals("runtimes")) {
                    ResourceManager.this.loadRuntimesList();
                    ResourceManager.this.saveRuntimesList();
                }
            }
        };
        ServerPlugin.getInstance().getPluginPreferences().addPropertyChangeListener(this.pcl);
        this.resolveServers();
        this.modelResourceChangeListener = new ServerModelResourceChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.modelResourceChangeListener, 7);
        this.publishResourceChangeListener = new PublishResourceChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.publishResourceChangeListener, 5);
        Trace.trace(Trace.FINER, "Loading workspace servers and server configurations");
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (projects != null) {
            int size = projects.length;
            int i = 0;
            while (i < size) {
                if (((ProjectProperties)ServerCore.getProjectProperties(projects[i])).isServerProject()) {
                    ResourceManager.loadFromProject(projects[i]);
                }
                ++i;
            }
        }
        this.addServerLifecycleListener(ServerListener.getInstance());
    }

    protected static void loadFromProject(IProject project) {
        Trace.trace(Trace.FINER, "Initial server resource load for " + project.getName(), null);
        ResourceManager rm = ResourceManager.getInstance();
        try {
            project.accept(new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) {
                    if (proxy.getType() == 1 && "server".equals(ResourceManager.getFileExtension(proxy.getName()))) {
                        IFile file = (IFile)proxy.requestResource();
                        try {
                            ResourceManager.this.handleNewFile(file, null);
                        }
                        catch (Exception e) {
                            Trace.trace(Trace.SEVERE, "Error during initial server resource load", e);
                        }
                        return false;
                    }
                    return true;
                }
            }, 0);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not load server project " + project.getName(), e);
        }
    }

    protected static String getFileExtension(String name) {
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        if (index == name.length() - 1) {
            return "";
        }
        return name.substring(index + 1);
    }

    public static ResourceManager getInstance() {
        if (instance == null) {
            new ResourceManager();
        }
        return instance;
    }

    public static void shutdown() {
        if (instance == null) {
            return;
        }
        try {
            instance.shutdownImpl();
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error during shutdown", e);
        }
    }

    protected boolean isActiveBundle(String bundleId) {
        return this.activeBundles.contains(bundleId);
    }

    protected void shutdownBundle(String id) {
        Iterator iterator = this.servers.iterator();
        while (iterator.hasNext()) {
            Server server = (Server)iterator.next();
            try {
                ServerType serverType = (ServerType)server.getServerType();
                if (!id.equals(serverType.getElement().getDeclaringExtension().getNamespace())) continue;
                server.dispose();
            }
            catch (Exception e) {
                Trace.trace(Trace.WARNING, "Error disposing server", e);
            }
        }
        iterator = this.runtimes.iterator();
        while (iterator.hasNext()) {
            Runtime runtime = (Runtime)iterator.next();
            try {
                RuntimeType runtimeType = (RuntimeType)runtime.getRuntimeType();
                if (!id.equals(runtimeType.getElement().getDeclaringExtension().getNamespace())) continue;
                runtime.dispose();
            }
            catch (Exception e) {
                Trace.trace(Trace.WARNING, "Error disposing server", e);
            }
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {}
    }

    protected void shutdownImpl() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null) {
            workspace.removeResourceChangeListener(this.modelResourceChangeListener);
            workspace.removeResourceChangeListener(this.publishResourceChangeListener);
        }
        ServerPlugin.getInstance().getPluginPreferences().removePropertyChangeListener(this.pcl);
        this.removeServerLifecycleListener(ServerListener.getInstance());
    }

    public void addRuntimeLifecycleListener(IRuntimeLifecycleListener listener) {
        Trace.trace(Trace.LISTENERS, "Adding server resource listener " + listener + " to " + this);
        if (this.runtimeListeners == null) {
            this.runtimeListeners = new ArrayList(3);
        }
        this.runtimeListeners.add(listener);
    }

    public void removeRuntimeLifecycleListener(IRuntimeLifecycleListener listener) {
        Trace.trace(Trace.LISTENERS, "Removing server resource listener " + listener + " from " + this);
        if (this.runtimeListeners != null) {
            this.runtimeListeners.remove(listener);
        }
    }

    public void addServerLifecycleListener(IServerLifecycleListener listener) {
        Trace.trace(Trace.LISTENERS, "Adding server resource listener " + listener + " to " + this);
        if (this.serverListeners == null) {
            this.serverListeners = new ArrayList(3);
        }
        this.serverListeners.add(listener);
    }

    public void removeServerLifecycleListener(IServerLifecycleListener listener) {
        Trace.trace(Trace.LISTENERS, "Removing server resource listener " + listener + " from " + this);
        if (this.serverListeners != null) {
            this.serverListeners.remove(listener);
        }
    }

    protected void deregisterRuntime(IRuntime runtime) {
        if (runtime == null) {
            return;
        }
        Trace.trace(Trace.RESOURCES, "Deregistering runtime: " + runtime.getName());
        if (runtime.equals(this.getDefaultRuntime())) {
            this.setDefaultRuntime(null);
        }
        ((Runtime)runtime).dispose();
        this.fireRuntimeEvent(runtime, (byte)2);
        this.runtimes.remove(runtime);
    }

    protected void deregisterServer(IServer server) {
        if (server == null) {
            return;
        }
        Trace.trace(Trace.RESOURCES, "Deregistering server: " + server.getName());
        ((Server)server).deleteLaunchConfigurations();
        ServerPlugin.getInstance().removeTempDirectory(server.getId());
        ((Server)server).dispose();
        this.fireServerEvent(server, (byte)2);
        this.servers.remove(server);
    }

    private void fireRuntimeEvent(IRuntime runtime, byte b) {
        Trace.trace(Trace.LISTENERS, "->- Firing runtime event: " + runtime.getName() + " ->-");
        if (this.runtimeListeners == null || this.runtimeListeners.isEmpty()) {
            return;
        }
        int size = this.runtimeListeners.size();
        IRuntimeLifecycleListener[] srl = new IRuntimeLifecycleListener[size];
        this.runtimeListeners.toArray(srl);
        int i = 0;
        while (i < size) {
            Trace.trace(Trace.LISTENERS, "  Firing runtime event to " + srl[i]);
            try {
                if (b == 0) {
                    srl[i].runtimeAdded(runtime);
                } else if (b == 1) {
                    srl[i].runtimeChanged(runtime);
                } else {
                    srl[i].runtimeRemoved(runtime);
                }
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "  Error firing runtime event to " + srl[i], e);
            }
            ++i;
        }
        Trace.trace(Trace.LISTENERS, "-<- Done firing runtime event -<-");
    }

    private void fireServerEvent(IServer server, byte b) {
        Trace.trace(Trace.LISTENERS, "->- Firing server event: " + server.getName() + " ->-");
        if (this.serverListeners == null || this.serverListeners.isEmpty()) {
            return;
        }
        int size = this.serverListeners.size();
        IServerLifecycleListener[] srl = new IServerLifecycleListener[size];
        this.serverListeners.toArray(srl);
        int i = 0;
        while (i < size) {
            Trace.trace(Trace.LISTENERS, "  Firing server event to " + srl[i]);
            try {
                if (b == 0) {
                    srl[i].serverAdded(server);
                } else if (b == 1) {
                    srl[i].serverChanged(server);
                } else {
                    srl[i].serverRemoved(server);
                }
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "  Error firing server event to " + srl[i], e);
            }
            ++i;
        }
        Trace.trace(Trace.LISTENERS, "-<- Done firing server event -<-");
    }

    protected void saveRuntimesList() {
        try {
            int ind;
            this.ignorePreferenceChanges = true;
            XMLMemento memento = XMLMemento.createWriteRoot("runtimes");
            if (this.defaultRuntime != null && (ind = this.runtimes.indexOf(this.defaultRuntime)) >= 0) {
                memento.putString("default", String.valueOf(ind));
            }
            Iterator iterator = this.runtimes.iterator();
            while (iterator.hasNext()) {
                Runtime runtime = (Runtime)iterator.next();
                IMemento child = memento.createChild("runtime");
                runtime.save(child);
            }
            String xmlString = memento.saveToString();
            Preferences prefs = ServerPlugin.getInstance().getPluginPreferences();
            prefs.setValue("runtimes", xmlString);
            ServerPlugin.getInstance().savePluginPreferences();
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not save runtimes", e);
        }
        this.ignorePreferenceChanges = false;
    }

    protected void saveServersList() {
        String filename = ServerPlugin.getInstance().getStateLocation().append(SERVER_DATA_FILE).toOSString();
        try {
            XMLMemento memento = XMLMemento.createWriteRoot("servers");
            Iterator iterator = this.servers.iterator();
            while (iterator.hasNext()) {
                Server server = (Server)iterator.next();
                IMemento child = memento.createChild("server");
                server.save(child);
            }
            memento.saveToFile(filename);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not save servers", e);
        }
    }

    protected void loadRuntimesList() {
        Trace.trace(Trace.FINEST, "Loading runtime info");
        Preferences prefs = ServerPlugin.getInstance().getPluginPreferences();
        String xmlString = prefs.getString("runtimes");
        this.runtimes = new ArrayList();
        if (xmlString != null && xmlString.length() > 0) {
            try {
                ByteArrayInputStream in = new ByteArrayInputStream(xmlString.getBytes("UTF-8"));
                IMemento memento = XMLMemento.loadMemento(in);
                IMemento[] children = memento.getChildren("runtime");
                int size = children.length;
                int i = 0;
                while (i < size) {
                    Runtime runtime = new Runtime(null);
                    runtime.loadFromMemento(children[i], null);
                    this.runtimes.add(runtime);
                    ++i;
                }
                String s = memento.getString("default");
                try {
                    int ind = Integer.parseInt(s);
                    this.defaultRuntime = (IRuntime)this.runtimes.get(ind);
                }
                catch (Exception exception) {}
            }
            catch (Exception e) {
                Trace.trace(Trace.WARNING, "Could not load runtimes: " + e.getMessage());
            }
        }
    }

    protected void loadServersList() {
        Trace.trace(Trace.FINEST, "Loading server info");
        String filename = ServerPlugin.getInstance().getStateLocation().append(SERVER_DATA_FILE).toOSString();
        try {
            IMemento memento = XMLMemento.loadMemento(filename);
            IMemento[] children = memento.getChildren("server");
            int size = children.length;
            int i = 0;
            while (i < size) {
                Server server = new Server(null);
                server.loadFromMemento(children[i], null);
                this.servers.add(server);
                ++i;
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.WARNING, "Could not load servers: " + e.getMessage());
        }
    }

    protected void addRuntime(IRuntime runtime) {
        if (runtime == null) {
            return;
        }
        if (!this.runtimes.contains(runtime)) {
            this.registerRuntime(runtime);
        } else {
            this.fireRuntimeEvent(runtime, (byte)1);
        }
        this.saveRuntimesList();
        this.resolveServers();
        RuntimeWorkingCopy.rebuildRuntime(runtime, true);
    }

    protected void removeRuntime(IRuntime runtime) {
        if (this.runtimes.contains(runtime)) {
            this.deregisterRuntime(runtime);
            this.saveRuntimesList();
            this.resolveServers();
            RuntimeWorkingCopy.rebuildRuntime(runtime, false);
        }
    }

    protected void addServer(IServer server) {
        if (!this.servers.contains(server)) {
            this.registerServer(server);
        } else {
            this.fireServerEvent(server, (byte)1);
        }
        this.saveServersList();
        this.resolveServers();
    }

    protected void removeServer(IServer server) {
        if (this.servers.contains(server)) {
            this.deregisterServer(server);
            this.saveServersList();
            this.resolveServers();
        }
    }

    public IRuntime[] getRuntimes() {
        ArrayList<IRuntime> list = new ArrayList<IRuntime>(this.runtimes);
        if (this.defaultRuntime != null && list.contains(this.defaultRuntime)) {
            list.remove(this.defaultRuntime);
            list.add(0, this.defaultRuntime);
        }
        IRuntime[] r = new IRuntime[list.size()];
        list.toArray(r);
        return r;
    }

    public IRuntime getRuntime(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        Iterator iterator = this.runtimes.iterator();
        while (iterator.hasNext()) {
            IRuntime runtime = (IRuntime)iterator.next();
            if (!runtime.getId().equals(id)) continue;
            return runtime;
        }
        return null;
    }

    public IRuntime getDefaultRuntime() {
        return this.defaultRuntime;
    }

    public void setDefaultRuntime(IRuntime runtime) {
        this.defaultRuntime = runtime;
        this.saveRuntimesList();
    }

    protected void resolveServers() {
        Iterator iterator = this.servers.iterator();
        while (iterator.hasNext()) {
            Server server = (Server)iterator.next();
            server.resolve();
        }
    }

    public IServer[] getServers() {
        IServer[] servers2 = new IServer[this.servers.size()];
        this.servers.toArray(servers2);
        Arrays.sort(servers2, new Comparator(){

            public int compare(Object o1, Object o2) {
                IServer a = (IServer)o1;
                IServer b = (IServer)o2;
                return a.getName().compareToIgnoreCase(b.getName());
            }
        });
        return servers2;
    }

    public IServer getServer(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        Iterator iterator = this.servers.iterator();
        while (iterator.hasNext()) {
            Server server = (Server)iterator.next();
            if (!id.equals(server.getId())) continue;
            return server;
        }
        return null;
    }

    protected boolean handleResourceDelta(IResourceDelta delta) {
        int kind = delta.getKind();
        IResource resource2 = delta.getResource();
        if (kind == 4 && (delta.getFlags() & 0x20000) != 0) {
            return false;
        }
        Trace.trace(Trace.RESOURCES, "Resource changed: " + resource2 + " " + kind);
        if (resource2 instanceof IFile) {
            IFile file = (IFile)resource2;
            IProgressMonitor monitor = null;
            if (kind == 1) {
                this.handleNewFile(file, monitor);
            } else if (kind == 2) {
                this.handleRemovedFile(file);
            } else {
                this.handleChangedFile(file, monitor);
            }
            if (monitor != null) {
                monitor.done();
            }
            return false;
        }
        IFolder folder = (IFolder)resource2;
        Iterator iterator = this.servers.iterator();
        while (iterator.hasNext()) {
            IServer server = (IServer)iterator.next();
            if (!server.getServerType().hasServerConfiguration() || !folder.equals((Object)server.getServerConfiguration())) continue;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.wst.server.core.model.ServerDelegate");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (server.getAdapter(clazz) == null) continue;
            try {
                ((Server)server).getDelegate(null).configurationChanged();
            }
            catch (Exception exception) {
                Trace.trace(Trace.WARNING, "Server failed on configuration change");
            }
        }
        return true;
    }

    protected IServer loadServer(IFile file, IProgressMonitor monitor) throws CoreException {
        Server server = new Server(file);
        server.loadFromFile(monitor);
        return server;
    }

    protected boolean handleNewFile(IFile file, IProgressMonitor monitor) {
        Trace.trace(Trace.RESOURCES, "handleNewFile: " + file);
        monitor = ProgressUtil.getMonitorFor(monitor);
        monitor.beginTask("", 2000);
        if (file.getFileExtension().equals("server")) {
            try {
                IServer server = this.loadServer(file, ProgressUtil.getSubMonitorFor(monitor, 1000));
                if (server != null) {
                    if (this.getServer(server.getId()) == null) {
                        this.registerServer(server);
                    }
                    monitor.done();
                    return true;
                }
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "Error loading server", e);
            }
        }
        monitor.done();
        return false;
    }

    public static IServer findServer(IFile file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        IServer[] servers = ServerCore.getServers();
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size) {
                if (file.equals((Object)((Server)servers[i]).getFile())) {
                    return servers[i];
                }
                ++i;
            }
        }
        return null;
    }

    protected boolean handleChangedFile(IFile file, IProgressMonitor monitor) {
        Trace.trace(Trace.RESOURCES, "handleChangedFile: " + file);
        monitor = ProgressUtil.getMonitorFor(monitor);
        monitor.beginTask("", 1000);
        boolean found = false;
        IServer server = ResourceManager.findServer(file);
        if (server != null) {
            found = true;
            try {
                Trace.trace(Trace.RESOURCES, "Reloading server: " + server);
                ((Server)server).loadFromFile(monitor);
                this.fireServerEvent(server, (byte)1);
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "Error reloading server " + server.getName() + " from " + file + ": " + e.getMessage());
                this.deregisterServer(server);
            }
        }
        Trace.trace(Trace.RESOURCES, "No server resource found at: " + file);
        monitor.done();
        return found;
    }

    protected boolean handleRemovedFile(IFile file) {
        Trace.trace(Trace.RESOURCES, "handleRemovedServerResource: " + file);
        IServer server = ResourceManager.findServer(file);
        if (server != null) {
            this.deregisterServer(server);
            return true;
        }
        Trace.trace(Trace.RESOURCES, "No server resource found at: " + file);
        return false;
    }

    protected void publishHandleProjectChange(IResourceDelta delta) {
        Trace.trace(Trace.FINEST, "> publishHandleProjectChange " + delta.getResource());
        IProject project = (IProject)delta.getResource();
        if (project == null) {
            return;
        }
        if (this.isDeltaOnlyMarkers(delta)) {
            return;
        }
        IModule[] modules = ServerUtil.getModules(project);
        if (modules == null) {
            return;
        }
        Trace.trace(Trace.FINEST, "- publishHandleProjectChange");
        if (modules != null) {
            int size2 = modules.length;
            int j = 0;
            while (j < size2) {
                IServer[] servers2 = this.getServers();
                if (servers2 != null) {
                    int size = servers2.length;
                    int i = 0;
                    while (i < size) {
                        IServer iServer = servers2[i];
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.wst.server.core.model.ServerDelegate");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (iServer.getAdapter(clazz) != null) {
                            ((Server)servers2[i]).handleModuleProjectChange(modules[j]);
                        }
                        ++i;
                    }
                }
                ++j;
            }
        }
        Trace.trace(Trace.FINEST, "< publishHandleProjectChange");
    }

    protected boolean isDeltaOnlyMarkers(IResourceDelta delta) {
        class Temp {
            boolean b;
            final /* synthetic */ ResourceManager this$0;

            Temp(ResourceManager resourceManager) {
                this.this$0 = resourceManager;
                this.b = true;
            }
        }
        final Temp t = new Temp(this);
        try {
            delta.accept(new IResourceDeltaVisitor(){
                {
                }

                public boolean visit(IResourceDelta delta2) throws CoreException {
                    if (!t.b) {
                        return false;
                    }
                    int flags = delta2.getFlags();
                    if (flags != 0 && flags != 131072) {
                        t.b = false;
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (Exception exception) {}
        return t.b;
    }

    protected void registerRuntime(IRuntime runtime) {
        if (runtime == null) {
            return;
        }
        Trace.trace(Trace.RESOURCES, "Registering runtime: " + runtime.getName());
        this.runtimes.add(runtime);
        this.fireRuntimeEvent(runtime, (byte)0);
        RuntimeType runtimeType = (RuntimeType)runtime.getRuntimeType();
        String bundleId = runtimeType.getElement().getDeclaringExtension().getNamespace();
        if (!this.activeBundles.contains(bundleId)) {
            this.activeBundles.add(bundleId);
        }
    }

    protected void registerServer(IServer server) {
        if (server == null) {
            return;
        }
        Trace.trace(Trace.RESOURCES, "Registering server: " + server.getName());
        this.servers.add(server);
        this.fireServerEvent(server, (byte)0);
        ServerType serverType = (ServerType)server.getServerType();
        String bundleId = serverType.getElement().getDeclaringExtension().getNamespace();
        if (!this.activeBundles.contains(bundleId)) {
            this.activeBundles.add(bundleId);
        }
    }

    protected void fireModuleServerEvent(ModuleFactoryEvent[] factoryEvents, ModuleEvent[] events) {
    }

    public class ServerModelResourceChangeListener
    implements IResourceChangeListener {
        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            Trace.trace(Trace.RESOURCES, "->- ServerModelResourceManager responding to resource change: " + event.getType() + " ->-");
            IResourceDelta[] children = delta.getAffectedChildren();
            if (children != null) {
                int size = children.length;
                int i = 0;
                while (i < size) {
                    IResource resource = children[i].getResource();
                    if (resource != null && resource instanceof IProject) {
                        this.projectChanged((IProject)resource, children[i]);
                    }
                    ++i;
                }
            }
            Trace.trace(Trace.RESOURCES, "-<- Done ServerModelResourceManager responding to resource change -<-");
        }

        protected void projectChanged(IProject project, IResourceDelta delta) {
            if (!((ProjectProperties)ServerCore.getProjectProperties(project)).isServerProject()) {
                Trace.trace(Trace.RESOURCES, "Not a server project: " + project.getName());
                return;
            }
            IResourceDelta[] children = delta.getAffectedChildren();
            int size = children.length;
            int i = 0;
            while (i < size) {
                IResourceDelta child = children[i];
                try {
                    child.accept(new IResourceDeltaVisitor(this){
                        final /* synthetic */ ServerModelResourceChangeListener this$1;
                        {
                            this.this$1 = serverModelResourceChangeListener;
                        }

                        public boolean visit(IResourceDelta delta2) {
                            return ServerModelResourceChangeListener.access$0(this.this$1).handleResourceDelta(delta2);
                        }
                    });
                }
                catch (Exception e) {
                    Trace.trace(Trace.SEVERE, "Error responding to resource change", e);
                }
                ++i;
            }
        }

        static /* synthetic */ ResourceManager access$0(ServerModelResourceChangeListener serverModelResourceChangeListener) {
            return serverModelResourceChangeListener.ResourceManager.this;
        }
    }

    public class PublishResourceChangeListener
    implements IResourceChangeListener {
        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            Trace.trace(Trace.FINEST, "->- PublishResourceManager responding to resource change: " + event.getType() + " ->-");
            try {
                delta.accept(new IResourceDeltaVisitor(this){
                    final /* synthetic */ PublishResourceChangeListener this$1;
                    {
                        this.this$1 = publishResourceChangeListener;
                    }

                    public boolean visit(IResourceDelta visitorDelta) {
                        IResource resource = visitorDelta.getResource();
                        if (resource != null && resource instanceof IProject) {
                            PublishResourceChangeListener.access$0(this.this$1).publishHandleProjectChange(visitorDelta);
                            return false;
                        }
                        return true;
                    }
                });
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "Error responding to resource change", e);
            }
            Trace.trace(Trace.FINEST, "-<- Done PublishResourceManager responding to resource change -<-");
        }

        static /* synthetic */ ResourceManager access$0(PublishResourceChangeListener publishResourceChangeListener) {
            return publishResourceChangeListener.ResourceManager.this;
        }
    }
}

