/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.measurement;

import java.util.Hashtable;

public class Unit {
    private static final long UNITY = Unit.createType(0, 0, 0, 0, 0, 0, 0, 0, 0);
    private static final long ZERO = 64L;
    private static final long MASK = 127L;
    private static final int m_SHIFT = 0;
    private static final int s_SHIFT = 7;
    private static final int kg_SHIFT = 14;
    private static final int K_SHIFT = 21;
    private static final int A_SHIFT = 28;
    private static final int mol_SHIFT = 35;
    private static final int cd_SHIFT = 42;
    private static final int rad_SHIFT = 49;
    private static final int x_SHIFT = 56;
    private static final long x_MASK = 0x7F00000000000000L;
    public static final Unit unity = new Unit("", UNITY);
    public static final Unit m = new Unit("m", Unit.createType(0, 0, 0, 0, 0, 0, 0, 0, 1));
    public static final Unit s = new Unit("s", Unit.createType(0, 0, 0, 0, 0, 0, 0, 1, 0));
    public static final Unit kg = new Unit("kg", Unit.createType(0, 0, 0, 0, 0, 0, 1, 0, 0));
    public static final Unit K = new Unit("K", Unit.createType(0, 0, 0, 0, 0, 1, 0, 0, 0));
    public static final Unit A = new Unit("A", Unit.createType(0, 0, 0, 0, 1, 0, 0, 0, 0));
    public static final Unit mol = new Unit("mol", Unit.createType(0, 0, 0, 1, 0, 0, 0, 0, 0));
    public static final Unit cd = new Unit("cd", Unit.createType(0, 0, 1, 0, 0, 0, 0, 0, 0));
    public static final Unit m_s = new Unit("m/s", Unit.createType(0, 0, 0, 0, 0, 0, 0, -1, 1));
    public static final Unit m_s2 = new Unit("m/s2", Unit.createType(0, 0, 0, 0, 0, 0, 0, -2, 1));
    public static final Unit m2 = new Unit("m2", Unit.createType(0, 0, 0, 0, 0, 0, 0, 0, 2));
    public static final Unit m3 = new Unit("m3", Unit.createType(0, 0, 0, 0, 0, 0, 0, 0, 3));
    public static final Unit Hz = new Unit("Hz", Unit.createType(0, 0, 0, 0, 0, 0, 0, -1, 0));
    public static final Unit N = new Unit("N", Unit.createType(0, 0, 0, 0, 0, 0, 1, -2, 1));
    public static final Unit Pa = new Unit("Pa", Unit.createType(0, 0, 0, 0, 0, 0, 1, -2, -1));
    public static final Unit J = new Unit("J", Unit.createType(0, 0, 0, 0, 0, 0, 1, -2, 2));
    public static final Unit W = new Unit("W", Unit.createType(0, 0, 0, 0, 0, 0, 1, -3, 2));
    public static final Unit C = new Unit("C", Unit.createType(0, 0, 0, 0, 1, 0, 0, 1, 0));
    public static final Unit V = new Unit("V", Unit.createType(0, 0, 0, 0, -1, 0, 1, -3, 2));
    public static final Unit F = new Unit("F", Unit.createType(0, 0, 0, 0, 2, 0, -1, 4, -2));
    public static final Unit Ohm = new Unit("Ohm", Unit.createType(0, 0, 0, 0, -2, 0, 1, -3, 2));
    public static final Unit S = new Unit("S", Unit.createType(0, 0, 0, 0, 2, 0, -1, 3, -2));
    public static final Unit Wb = new Unit("Wb", Unit.createType(0, 0, 0, 0, -1, 0, 1, -2, 2));
    public static final Unit T = new Unit("T", Unit.createType(0, 0, 0, 0, -1, 0, 1, -2, 0));
    public static final Unit lx = new Unit("lx", Unit.createType(0, 0, 1, 0, 0, 0, 0, 0, -2));
    public static final Unit Gy = new Unit("Gy", Unit.createType(0, 0, 0, 0, 0, 0, 0, -2, 2));
    public static final Unit kat = new Unit("kat", Unit.createType(0, 0, 0, 1, 0, 0, 0, -1, 0));
    public static final Unit rad = new Unit("rad", Unit.createType(0, 1, 0, 0, 0, 0, 0, 0, 0));
    private static final Unit[] allUnits = new Unit[]{m, s, kg, K, A, mol, cd, rad, m_s, m_s2, m2, m3, Hz, N, Pa, J, W, C, V, F, Ohm, S, Wb, T, lx, Gy, kat, unity};
    private static Hashtable base;
    private String name;
    private long type;
    static /* synthetic */ Class class$0;

    private Unit(String name, long type) {
        this.name = name;
        this.type = type;
    }

    private static long createType(int x, int rad, int cd, int mol, int A, int K, int kg, int s, int m) {
        return (64L + (long)m & 0x7FL) << 0 | (64L + (long)s & 0x7FL) << 7 | (64L + (long)kg & 0x7FL) << 14 | (64L + (long)K & 0x7FL) << 21 | (64L + (long)A & 0x7FL) << 28 | (64L + (long)mol & 0x7FL) << 35 | (64L + (long)cd & 0x7FL) << 42 | (64L + (long)rad & 0x7FL) << 49 | (long)x << 56;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Unit)) {
            return false;
        }
        return ((Unit)obj).type == this.type;
    }

    public int hashCode() {
        return (int)(this.type >>> 32 ^ this.type);
    }

    Unit mul(Unit that) {
        if (this.isSpecial() && that.isSpecial()) {
            throw new ArithmeticException("Cannot multiply " + this + " with " + that);
        }
        return Unit.find(this.type - UNITY + that.type);
    }

    Unit div(Unit that) {
        if (this.isSpecial() && that.isSpecial()) {
            if (this.type == that.type) {
                return unity;
            }
            throw new ArithmeticException("Cannot divide " + this + " by " + that);
        }
        return Unit.find(this.type - that.type + UNITY);
    }

    Unit add(Unit that) {
        if (!this.equals(that)) {
            throw new ArithmeticException("Cannot add " + this + " to " + that);
        }
        return this;
    }

    Unit sub(Unit that) {
        if (!this.equals(that)) {
            throw new ArithmeticException("Cannot subtract " + that + " from " + this);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static Unit find(long type) {
        Unit unit;
        Unit out;
        if (base == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.osgi.util.measurement.Unit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class<?> clazz2 = clazz;
            // MONITORENTER : clazz
            if (base == null) {
                int size = allUnits.length;
                base = new Hashtable(size << 1);
                int i = 0;
                while (i < size) {
                    base.put(allUnits[i], allUnits[i]);
                    ++i;
                }
            }
            // MONITOREXIT : clazz2
        }
        if ((out = (Unit)base.get(unit = new Unit(null, type))) != null) return out;
        base.put(unit, unit);
        return unit;
    }

    public String toString() {
        if (this.name == null) {
            int m = (int)((this.type >> 0 & 0x7FL) - 64L);
            int s = (int)((this.type >> 7 & 0x7FL) - 64L);
            int kg = (int)((this.type >> 14 & 0x7FL) - 64L);
            int K = (int)((this.type >> 21 & 0x7FL) - 64L);
            int A = (int)((this.type >> 28 & 0x7FL) - 64L);
            int mol = (int)((this.type >> 35 & 0x7FL) - 64L);
            int cd = (int)((this.type >> 42 & 0x7FL) - 64L);
            int rad = (int)((this.type >> 49 & 0x7FL) - 64L);
            StringBuffer numerator = new StringBuffer();
            StringBuffer denominator = new StringBuffer();
            this.addSIname(m, "m", numerator, denominator);
            this.addSIname(s, "s", numerator, denominator);
            this.addSIname(kg, "kg", numerator, denominator);
            this.addSIname(K, "K", numerator, denominator);
            this.addSIname(A, "A", numerator, denominator);
            this.addSIname(mol, "mol", numerator, denominator);
            this.addSIname(cd, "cd", numerator, denominator);
            this.addSIname(rad, "rad", numerator, denominator);
            if (denominator.length() > 0) {
                if (numerator.length() == 0) {
                    numerator.append("1");
                }
                numerator.append("/");
                numerator.append((Object)denominator);
            }
            this.name = numerator.toString();
        }
        return this.name;
    }

    private void addSIname(int si, String name, StringBuffer numerator, StringBuffer denominator) {
        if (si != 0) {
            StringBuffer sb;
            StringBuffer stringBuffer = sb = si > 0 ? numerator : denominator;
            if (sb.length() > 0) {
                sb.append("*");
            }
            sb.append(name);
            int power = Math.abs(si);
            if (power > 1) {
                sb.append("^");
                sb.append(power);
            }
        }
    }

    private boolean isSpecial() {
        return (this.type & 0x7F00000000000000L) != 0L;
    }
}

