/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnDoCommonMessages;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.wst.sse.core.internal.Logger;

public class CompoundCommand
extends AbstractCommand {
    protected List commandList;
    public static final int LAST_COMMAND_ALL = Integer.MIN_VALUE;
    public static final int MERGE_COMMAND_ALL = Integer.MAX_VALUE;
    protected int resultIndex = Integer.MAX_VALUE;

    public CompoundCommand() {
        this.commandList = new ArrayList();
    }

    public CompoundCommand(String label) {
        super(label);
        this.commandList = new ArrayList();
    }

    public CompoundCommand(String label, String description) {
        super(label, description);
        this.commandList = new ArrayList();
    }

    public CompoundCommand(List commandList) {
        this.commandList = commandList;
    }

    public CompoundCommand(String label, List commandList) {
        super(label);
        this.commandList = commandList;
    }

    public CompoundCommand(String label, String description, List commandList) {
        super(label, description);
        this.commandList = commandList;
    }

    public CompoundCommand(int resultIndex) {
        this.resultIndex = resultIndex;
        this.commandList = new ArrayList();
    }

    public CompoundCommand(int resultIndex, String label) {
        super(label);
        this.resultIndex = resultIndex;
        this.commandList = new ArrayList();
    }

    public CompoundCommand(int resultIndex, String label, String description) {
        super(label, description);
        this.resultIndex = resultIndex;
        this.commandList = new ArrayList();
    }

    public CompoundCommand(int resultIndex, List commandList) {
        this.resultIndex = resultIndex;
        this.commandList = commandList;
    }

    public CompoundCommand(int resultIndex, String label, List commandList) {
        super(label);
        this.resultIndex = resultIndex;
        this.commandList = commandList;
    }

    public CompoundCommand(int resultIndex, String label, String description, List commandList) {
        super(label, description);
        this.resultIndex = resultIndex;
        this.commandList = commandList;
    }

    public boolean isEmpty() {
        return this.commandList.isEmpty();
    }

    public List getCommandList() {
        return Collections.unmodifiableList(this.commandList);
    }

    public int getResultIndex() {
        return this.resultIndex;
    }

    protected boolean prepare() {
        if (this.commandList.isEmpty()) {
            return false;
        }
        ListIterator commands = this.commandList.listIterator();
        while (commands.hasNext()) {
            Command command = (Command)commands.next();
            if (command.canExecute()) continue;
            return false;
        }
        return true;
    }

    public void execute() {
        ListIterator commands = this.commandList.listIterator();
        while (commands.hasNext()) {
            try {
                Command command = (Command)commands.next();
                command.execute();
                continue;
            }
            catch (RuntimeException exception) {
                commands.previous();
                try {
                    while (commands.hasPrevious()) {
                        Command command = (Command)commands.previous();
                        if (command.canUndo()) {
                            command.undo();
                        }
                    }
                }
                catch (RuntimeException nestedException) {
                    Logger.logException(UnDoCommonMessages._UI_IgnoreException_exception, nestedException);
                }
            }
            throw exception;
        }
    }

    public boolean canUndo() {
        ListIterator commands = this.commandList.listIterator();
        while (commands.hasNext()) {
            Command command = (Command)commands.next();
            if (command.canUndo()) continue;
            return false;
        }
        return true;
    }

    public void undo() {
        ListIterator commands = this.commandList.listIterator(this.commandList.size());
        while (commands.hasPrevious()) {
            try {
                Command command = (Command)commands.previous();
                command.undo();
                continue;
            }
            catch (RuntimeException exception) {
                commands.next();
                try {
                    while (commands.hasNext()) {
                        Command command = (Command)commands.next();
                        command.redo();
                    }
                }
                catch (RuntimeException runtimeException) {
                    Logger.logException(UnDoCommonMessages._UI_IgnoreException_exception, exception);
                }
            }
            throw exception;
        }
    }

    public void redo() {
        ListIterator commands = this.commandList.listIterator();
        while (commands.hasNext()) {
            try {
                Command command = (Command)commands.next();
                command.redo();
                continue;
            }
            catch (RuntimeException exception) {
                commands.previous();
                try {
                    while (commands.hasPrevious()) {
                        Command command = (Command)commands.previous();
                        command.undo();
                    }
                }
                catch (RuntimeException nestedException) {
                    Logger.logException(UnDoCommonMessages._UI_IgnoreException_exception, nestedException);
                }
            }
            throw exception;
        }
    }

    public Collection getResult() {
        if (this.commandList.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (this.resultIndex == Integer.MIN_VALUE) {
            return ((Command)this.commandList.get(this.commandList.size() - 1)).getResult();
        }
        if (this.resultIndex == Integer.MAX_VALUE) {
            return this.getMergedResultCollection();
        }
        if (this.resultIndex < this.commandList.size()) {
            return ((Command)this.commandList.get(this.resultIndex)).getResult();
        }
        return Collections.EMPTY_LIST;
    }

    protected Collection getMergedResultCollection() {
        ArrayList result = new ArrayList();
        Iterator commands = this.commandList.iterator();
        while (commands.hasNext()) {
            Command command = (Command)commands.next();
            result.addAll(command.getResult());
        }
        return result;
    }

    public Collection getAffectedObjects() {
        if (this.commandList.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        if (this.resultIndex == Integer.MIN_VALUE) {
            return ((Command)this.commandList.get(this.commandList.size() - 1)).getAffectedObjects();
        }
        if (this.resultIndex == Integer.MAX_VALUE) {
            return this.getMergedAffectedObjectsCollection();
        }
        if (this.resultIndex < this.commandList.size()) {
            return ((Command)this.commandList.get(this.resultIndex)).getAffectedObjects();
        }
        return Collections.EMPTY_LIST;
    }

    protected Collection getMergedAffectedObjectsCollection() {
        ArrayList result = new ArrayList();
        Iterator commands = this.commandList.iterator();
        while (commands.hasNext()) {
            Command command = (Command)commands.next();
            result.addAll(command.getAffectedObjects());
        }
        return result;
    }

    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        if (this.commandList.isEmpty()) {
            return UnDoCommonMessages._UI_CompoundCommand_label;
        }
        if (this.resultIndex == Integer.MIN_VALUE || this.resultIndex == Integer.MAX_VALUE) {
            return ((Command)this.commandList.get(this.commandList.size() - 1)).getLabel();
        }
        if (this.resultIndex < this.commandList.size()) {
            return ((Command)this.commandList.get(this.resultIndex)).getLabel();
        }
        return UnDoCommonMessages._UI_CompoundCommand_label;
    }

    public String getDescription() {
        if (this.description != null) {
            return this.description;
        }
        if (this.commandList.isEmpty()) {
            return UnDoCommonMessages._UI_CompoundCommand_description;
        }
        if (this.resultIndex == Integer.MIN_VALUE || this.resultIndex == Integer.MAX_VALUE) {
            return ((Command)this.commandList.get(this.commandList.size() - 1)).getDescription();
        }
        if (this.resultIndex < this.commandList.size()) {
            return ((Command)this.commandList.get(this.resultIndex)).getDescription();
        }
        return UnDoCommonMessages._UI_CompoundCommand_description;
    }

    public void append(Command command) {
        if (command != null) {
            this.commandList.add(command);
        }
    }

    public boolean appendAndExecute(Command command) {
        if (command != null) {
            if (!this.isPrepared) {
                if (this.commandList.isEmpty()) {
                    this.isPrepared = true;
                    this.isExecutable = true;
                } else {
                    this.isExecutable = this.prepare();
                    this.isPrepared = true;
                    if (this.isExecutable) {
                        this.execute();
                    }
                }
            }
            if (command.canExecute()) {
                try {
                    command.execute();
                    this.commandList.add(command);
                    return true;
                }
                catch (RuntimeException exception) {
                    Logger.logException(UnDoCommonMessages._UI_IgnoreException_exception, exception);
                }
            }
            command.dispose();
        }
        return false;
    }

    public boolean appendIfCanExecute(Command command) {
        if (command == null) {
            return false;
        }
        if (command.canExecute()) {
            this.commandList.add(command);
            return true;
        }
        command.dispose();
        return false;
    }

    public void dispose() {
        ListIterator commands = this.commandList.listIterator();
        while (commands.hasNext()) {
            Command command = (Command)commands.next();
            command.dispose();
        }
    }

    public Command unwrap() {
        switch (this.commandList.size()) {
            case 0: {
                this.dispose();
                return UnexecutableCommand.INSTANCE;
            }
            case 1: {
                Command result = (Command)this.commandList.remove(0);
                this.dispose();
                return result;
            }
        }
        return this;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append("" + this.commandList.size());
        result.append("" + this.resultIndex);
        return result.toString();
    }
}

