/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.actions.AbstractListenerActionDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class TerminateAllAction
extends AbstractListenerActionDelegate {
    protected void doAction(Object element) throws DebugException {
        ILaunch launch;
        if (element instanceof ILaunch && !(launch = (ILaunch)element).isTerminated() && DebugPlugin.getDefault().getLaunchManager().isRegistered(launch)) {
            launch.terminate();
        }
    }

    protected boolean isRunInBackground() {
        return true;
    }

    protected void update(IAction action, ISelection selection) {
        ILaunchManager lManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] launches = lManager.getLaunches();
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            if (!launch.isTerminated()) {
                action.setEnabled(true);
                return;
            }
            ++i;
        }
        action.setEnabled(false);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setAction(action);
    }

    protected void doHandleDebugEvent(DebugEvent event) {
        switch (event.getKind()) {
            case 8: {
                this.update(this.getAction(), null);
                break;
            }
            case 4: {
                this.update(this.getAction(), null);
            }
        }
    }

    protected IStructuredSelection getSelection() {
        return new StructuredSelection((Object[])DebugPlugin.getDefault().getLaunchManager().getLaunches());
    }
}

