/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.util.HashSet;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointContainer;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsContentProvider;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsView;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.activities.IWorkbenchActivitySupport;

public class BreakpointsViewEventHandler
implements IBreakpointsListener,
IActivityManagerListener,
IBreakpointManagerListener {
    private BreakpointsView fView;

    public BreakpointsViewEventHandler(BreakpointsView view) {
        this.fView = view;
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        breakpointManager.addBreakpointListener((IBreakpointsListener)this);
        breakpointManager.addBreakpointManagerListener((IBreakpointManagerListener)this);
        IWorkbenchActivitySupport activitySupport = PlatformUI.getWorkbench().getActivitySupport();
        if (activitySupport != null) {
            activitySupport.getActivityManager().addActivityManagerListener((IActivityManagerListener)this);
        }
    }

    public void dispose() {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        breakpointManager.removeBreakpointListener((IBreakpointsListener)this);
        breakpointManager.removeBreakpointManagerListener((IBreakpointManagerListener)this);
        IWorkbenchActivitySupport activitySupport = PlatformUI.getWorkbench().getActivitySupport();
        if (activitySupport != null) {
            activitySupport.getActivityManager().removeActivityManagerListener((IActivityManagerListener)this);
        }
    }

    public void breakpointsAdded(final IBreakpoint[] breakpoints) {
        if (this.fView.isAvailable() && this.fView.isVisible()) {
            this.fView.asyncExec(new Runnable(){

                public void run() {
                    if (BreakpointsViewEventHandler.this.fView.isAvailable()) {
                        CheckboxTreeViewer viewer = BreakpointsViewEventHandler.this.fView.getCheckboxViewer();
                        viewer.getControl().setRedraw(false);
                        BreakpointsContentProvider provider = (BreakpointsContentProvider)viewer.getContentProvider();
                        provider.reorganize();
                        int i = 0;
                        while (i < breakpoints.length) {
                            IBreakpoint breakpoint = breakpoints[i];
                            BreakpointContainer[] roots = provider.getRoots(breakpoint);
                            if (roots != null) {
                                int j = 0;
                                while (j < roots.length) {
                                    viewer.expandToLevel((Object)roots[j], -1);
                                    ++j;
                                }
                            }
                            ++i;
                        }
                        BreakpointsViewEventHandler.this.fView.initializeCheckedState();
                        viewer.setSelection((ISelection)new StructuredSelection((Object[])breakpoints));
                        viewer.getControl().setRedraw(true);
                        BreakpointsViewEventHandler.this.fView.updateObjects();
                    }
                }
            });
        }
    }

    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        if (this.fView.isAvailable() && this.fView.isVisible()) {
            this.fView.asyncExec(new Runnable(){

                public void run() {
                    if (BreakpointsViewEventHandler.this.fView.isAvailable()) {
                        CheckboxTreeViewer viewer = (CheckboxTreeViewer)BreakpointsViewEventHandler.this.fView.getViewer();
                        viewer.getControl().setRedraw(false);
                        ((BreakpointsContentProvider)viewer.getContentProvider()).reorganize();
                        BreakpointsViewEventHandler.this.fView.initializeCheckedState();
                        viewer.getControl().setRedraw(true);
                        BreakpointsViewEventHandler.this.fView.updateObjects();
                    }
                }
            });
        }
    }

    public void breakpointsChanged(final IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        if (this.fView.isAvailable() & this.fView.isVisible()) {
            this.fView.asyncExec(new Runnable(){

                public void run() {
                    if (BreakpointsViewEventHandler.this.fView.isAvailable()) {
                        CheckboxTreeViewer viewer = (CheckboxTreeViewer)BreakpointsViewEventHandler.this.fView.getViewer();
                        viewer.getControl().setRedraw(false);
                        BreakpointsContentProvider provider = (BreakpointsContentProvider)viewer.getContentProvider();
                        HashSet<BreakpointContainer> updates = new HashSet<BreakpointContainer>();
                        int i = 0;
                        while (i < breakpoints.length) {
                            IBreakpoint breakpoint = breakpoints[i];
                            viewer.update((Object)breakpoint, null);
                            BreakpointContainer[] containers = provider.getContainers(breakpoint);
                            if (containers != null) {
                                int j = 0;
                                while (j < containers.length) {
                                    updates.add(containers[j]);
                                    ++j;
                                }
                            } else {
                                updates.add((BreakpointContainer)breakpoint);
                            }
                            ++i;
                        }
                        Object[] objects = updates.toArray();
                        int i2 = 0;
                        while (i2 < objects.length) {
                            BreakpointsViewEventHandler.this.fView.updateCheckedState(objects[i2]);
                            ++i2;
                        }
                        viewer.getControl().setRedraw(true);
                        BreakpointsViewEventHandler.this.fView.updateObjects();
                    }
                }
            });
        }
    }

    public void activityManagerChanged(ActivityManagerEvent activityManagerEvent) {
        if (this.fView.isAvailable() & this.fView.isVisible() && activityManagerEvent.haveEnabledActivityIdsChanged()) {
            this.fView.asyncExec(new Runnable(){

                public void run() {
                    BreakpointsViewEventHandler.this.fView.getViewer().refresh();
                }
            });
        }
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        if (this.fView.isAvailable() & this.fView.isVisible()) {
            this.fView.asyncExec(new Runnable(){

                public void run() {
                    BreakpointsViewEventHandler.this.fView.getViewer().refresh();
                }
            });
        }
    }
}

