/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.memory.AbstractMemoryViewPane;
import org.eclipse.debug.internal.ui.views.memory.AddMemoryRenderingAction;
import org.eclipse.debug.internal.ui.views.memory.IMemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.MemoryView;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewTab;
import org.eclipse.debug.internal.ui.views.memory.MemoryViewUtil;
import org.eclipse.debug.internal.ui.views.memory.RemoveMemoryRenderingAction;
import org.eclipse.debug.internal.ui.views.memory.ViewPaneRenderingMgr;
import org.eclipse.debug.internal.ui.views.memory.renderings.CreateRendering;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IMemoryRenderingSite;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class RenderingViewPane
extends AbstractMemoryViewPane
implements IMemoryRenderingContainer {
    public static final String RENDERING_VIEW_PANE_ID = String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".MemoryView.RenderingViewPane";
    private Hashtable fTabFolderForMemoryBlock = new Hashtable();
    private Hashtable fMemoryBlockFromTabFolder = new Hashtable();
    private AddMemoryRenderingAction fAddMemoryRenderingAction;
    private IAction fRemoveMemoryRenderingAction;
    private ViewPaneRenderingMgr fRenderingMgr;
    private IMemoryRenderingSite fRenderingSite;
    private Set fAddedRenderings = new HashSet();
    private Set fAddedMemoryBlocks = new HashSet();
    static /* synthetic */ Class class$0;

    public RenderingViewPane(IViewPart parent) {
        super(parent);
        if (parent instanceof IMemoryRenderingSite) {
            this.fRenderingSite = (IMemoryRenderingSite)parent;
        } else {
            DebugUIPlugin.logErrorMessage("Parent for the rendering view pane is invalid.");
        }
    }

    public void memoryBlocksAdded(final IMemoryBlock[] memoryBlocks) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (memoryBlocks == null || memoryBlocks.length <= 0) {
                    return;
                }
                int i = 0;
                while (i < memoryBlocks.length) {
                    IMemoryBlock memory = memoryBlocks[i];
                    if (RenderingViewPane.this.fTabFolderForMemoryBlock.containsKey(memory)) {
                        if (RenderingViewPane.this.fStackLayout.topControl != (TabFolder)RenderingViewPane.this.fTabFolderForMemoryBlock.get(memory)) {
                            if (RenderingViewPane.this.fParent instanceof MemoryView) {
                                MemoryView mv = (MemoryView)RenderingViewPane.this.fParent;
                                if (!mv.isPinMBDisplay() || RenderingViewPane.this.isFirstMemoryBlockForRetrieval(RenderingViewPane.this.getMemoryBlockRetrieval(memory)) || mv.isMemoryBlockRegistered(memory)) {
                                    if (RenderingViewPane.this.getTopMemoryTab() != null) {
                                        RenderingViewPane.this.getTopMemoryTab().setEnabled(false);
                                    }
                                    RenderingViewPane.this.setTabFolder((TabFolder)RenderingViewPane.this.fTabFolderForMemoryBlock.get(memory));
                                }
                            } else {
                                if (RenderingViewPane.this.getTopMemoryTab() != null) {
                                    RenderingViewPane.this.getTopMemoryTab().setEnabled(false);
                                }
                                RenderingViewPane.this.setTabFolder((TabFolder)RenderingViewPane.this.fTabFolderForMemoryBlock.get(memory));
                            }
                            RenderingViewPane.this.fTabFolderForDebugView.put(RenderingViewPane.this.getMemoryBlockRetrieval(memory), RenderingViewPane.this.fTabFolderForMemoryBlock.get(memory));
                            RenderingViewPane.this.fViewPaneCanvas.layout();
                        }
                    } else {
                        TabFolder folder = new TabFolder(RenderingViewPane.this.fViewPaneCanvas, 0);
                        RenderingViewPane.this.fTabFolderForMemoryBlock.put(memory, folder);
                        RenderingViewPane.this.fMemoryBlockFromTabFolder.put(folder, memory);
                        RenderingViewPane.this.fTabFolderForDebugView.put(RenderingViewPane.this.getMemoryBlockRetrieval(memory), folder);
                        IMemoryRendering[] renderings = RenderingViewPane.this.fRenderingMgr.getRenderingsFromMemoryBlock(memory);
                        MemoryViewTab createTab = null;
                        if (renderings.length == 0) {
                            TabItem newItem = new TabItem(folder, 0);
                            CreateRendering rendering = new CreateRendering(RenderingViewPane.this.getInstance());
                            rendering.init(RenderingViewPane.this.getInstance(), memory);
                            createTab = new MemoryViewTab(newItem, rendering, RenderingViewPane.this.getInstance());
                            folder.setSelection(0);
                        }
                        if (RenderingViewPane.this.fParent instanceof MemoryView) {
                            MemoryView mv = (MemoryView)RenderingViewPane.this.fParent;
                            if (!mv.isPinMBDisplay() || RenderingViewPane.this.isFirstMemoryBlockForRetrieval(RenderingViewPane.this.getMemoryBlockRetrieval(memory)) || mv.isMemoryBlockRegistered(memory)) {
                                if (RenderingViewPane.this.getTopMemoryTab() != null) {
                                    RenderingViewPane.this.getTopMemoryTab().setEnabled(false);
                                }
                                RenderingViewPane.this.setTabFolder((TabFolder)RenderingViewPane.this.fTabFolderForMemoryBlock.get(memory));
                                if (createTab != null) {
                                    RenderingViewPane.this.setRenderingSelection(createTab.getRendering());
                                }
                            }
                        } else {
                            if (RenderingViewPane.this.getTopMemoryTab() != null) {
                                RenderingViewPane.this.getTopMemoryTab().setEnabled(false);
                            }
                            RenderingViewPane.this.setTabFolder((TabFolder)RenderingViewPane.this.fTabFolderForMemoryBlock.get(memory));
                            if (createTab != null) {
                                RenderingViewPane.this.setRenderingSelection(createTab.getRendering());
                            }
                        }
                        RenderingViewPane.this.fViewPaneCanvas.layout();
                    }
                    RenderingViewPane.this.fAddedMemoryBlocks.add(memory);
                    RenderingViewPane.this.updateToolBarActionsEnablement();
                    ++i;
                }
            }
        });
    }

    private boolean isFirstMemoryBlockForRetrieval(IMemoryBlockRetrieval retrieval) {
        Iterator iter = this.fAddedMemoryBlocks.iterator();
        while (iter.hasNext()) {
            IMemoryBlock memoryBlock = (IMemoryBlock)iter.next();
            IMemoryBlockRetrieval memRetrieval = this.getMemoryBlockRetrieval(memoryBlock);
            if (memRetrieval != retrieval) continue;
            return false;
        }
        return true;
    }

    private IMemoryBlockRetrieval getMemoryBlockRetrieval(IMemoryBlock memoryBlock) {
        IMemoryBlockRetrieval retrieval;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((retrieval = (IMemoryBlockRetrieval)memoryBlock.getAdapter((Class)clazz)) == null) {
            retrieval = memoryBlock.getDebugTarget();
        }
        return retrieval;
    }

    public void memoryBlocksRemoved(final IMemoryBlock[] memoryBlocks) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                int j = 0;
                while (j < memoryBlocks.length) {
                    IMemoryBlock memory = memoryBlocks[j];
                    if (RenderingViewPane.this.fTabFolderForMemoryBlock == null) {
                        return;
                    }
                    IMemoryRendering[] renderings = RenderingViewPane.this.fRenderingMgr.getRenderingsFromMemoryBlock(memory);
                    int k = 0;
                    while (k < renderings.length) {
                        RenderingViewPane.this.removeMemoryRendering(renderings[k]);
                        ++k;
                    }
                    TabFolder tabFolder = (TabFolder)RenderingViewPane.this.fTabFolderForMemoryBlock.get(memory);
                    if (tabFolder != null) {
                        RenderingViewPane.this.fTabFolderForMemoryBlock.remove(memory);
                        RenderingViewPane.this.fMemoryBlockFromTabFolder.remove(tabFolder);
                        RenderingViewPane.this.fTabFolderForDebugView.remove(RenderingViewPane.this.getMemoryBlockRetrieval(memory));
                        if (!tabFolder.isDisposed()) {
                            IMemoryBlockRetrieval retrieve;
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if ((retrieve = (IMemoryBlockRetrieval)memory.getAdapter((Class)clazz)) == null) {
                                retrieve = memory.getDebugTarget();
                            }
                            if (RenderingViewPane.this.fTabFolderForDebugView.contains(tabFolder)) {
                                RenderingViewPane.this.fTabFolderForDebugView.remove(retrieve);
                            }
                            TabItem[] items = tabFolder.getItems();
                            int i = 0;
                            while (i < items.length) {
                                RenderingViewPane.this.disposeTab(items[i]);
                                ++i;
                            }
                            tabFolder.dispose();
                            if (tabFolder == RenderingViewPane.this.fStackLayout.topControl) {
                                ISelection selection = DebugUIPlugin.getActiveWorkbenchWindow().getSelectionService().getSelection("org.eclipse.debug.ui.MemoryView");
                                IMemoryBlock blk = RenderingViewPane.this.getMemoryBlock(selection);
                                if (blk != null) {
                                    if (blk != memory) {
                                        RenderingViewPane.this.handleMemoryBlockSelection(null, blk);
                                    } else if (MemoryViewUtil.getMemoryBlockManager().getMemoryBlocks(memory.getDebugTarget()).length > 0) {
                                        blk = MemoryViewUtil.getMemoryBlockManager().getMemoryBlocks(memory.getDebugTarget())[0];
                                        RenderingViewPane.this.handleMemoryBlockSelection(null, blk);
                                    } else {
                                        RenderingViewPane.this.emptyFolder();
                                    }
                                } else if (MemoryViewUtil.getMemoryBlockManager().getMemoryBlocks(memory.getDebugTarget()).length > 0) {
                                    blk = MemoryViewUtil.getMemoryBlockManager().getMemoryBlocks(memory.getDebugTarget())[0];
                                    RenderingViewPane.this.handleMemoryBlockSelection(null, blk);
                                } else {
                                    RenderingViewPane.this.emptyFolder();
                                }
                            }
                        }
                        RenderingViewPane.this.fAddedMemoryBlocks.remove(memory);
                        RenderingViewPane.this.updateToolBarActionsEnablement();
                    }
                    ++j;
                }
            }
        });
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        block16: {
            try {
                if (part == this) {
                    return;
                }
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                if (selection == AbstractMemoryViewPane.EMPTY) {
                    return;
                }
                if (selection == null || selection.isEmpty()) {
                    if (part.getSite().getId().equals("org.eclipse.debug.ui.MemoryView") && part == this.getMemoryRenderingSite().getSite().getPart()) {
                        IMemoryViewTab lastViewTab = this.getTopMemoryTab();
                        if (lastViewTab != null) {
                            lastViewTab.setEnabled(false);
                        }
                        this.emptyFolder();
                    }
                    return;
                }
                IMemoryViewTab lastViewTab = this.getTopMemoryTab();
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                Object elem = ((IStructuredSelection)selection).getFirstElement();
                if (elem instanceof IMemoryBlock) {
                    if (part == this.getMemoryRenderingSite()) {
                        IMemoryBlock memBlock = (IMemoryBlock)elem;
                        if (this.fTabFolderForMemoryBlock == null) {
                            if (lastViewTab != null) {
                                lastViewTab.setEnabled(false);
                            }
                            this.emptyFolder();
                            return;
                        }
                        this.handleMemoryBlockSelection(lastViewTab, memBlock);
                    }
                    break block16;
                }
                if (elem instanceof IDebugElement) {
                    this.handleDebugElementSelection(lastViewTab, (IDebugElement)elem);
                    break block16;
                }
                if (part.getSite().getId().equals("org.eclipse.debug.ui.DebugView")) {
                    if (lastViewTab != null) {
                        lastViewTab.setEnabled(false);
                    }
                    this.emptyFolder();
                }
                this.updateToolBarActionsEnablement();
                return;
            }
            catch (SWTException se) {
                DebugUIPlugin.log(se);
            }
        }
    }

    public void handleMemoryBlockSelection(IMemoryViewTab lastViewTab, IMemoryBlock memBlock) {
        IMemoryViewTab viewTab;
        IMemoryBlock currentBlk;
        if (memBlock.getDebugTarget().isDisconnected() || memBlock.getDebugTarget().isTerminated()) {
            this.emptyFolder();
            return;
        }
        TabFolder currentFolder = (TabFolder)this.fStackLayout.topControl;
        if (currentFolder != null && !currentFolder.isDisposed() && (currentBlk = (IMemoryBlock)this.fMemoryBlockFromTabFolder.get(currentFolder)) != null && currentBlk == memBlock) {
            return;
        }
        if (this.getTopMemoryTab() != null && this.getTopMemoryTab().getRendering().getMemoryBlock() == memBlock) {
            return;
        }
        if (this.fTabFolderForMemoryBlock.containsKey(memBlock)) {
            if (this.fStackLayout.topControl != (TabFolder)this.fTabFolderForMemoryBlock.get(memBlock)) {
                this.setTabFolder((TabFolder)this.fTabFolderForMemoryBlock.get(memBlock));
                this.fViewPaneCanvas.layout();
            }
        } else {
            TabFolder folder = new TabFolder(this.fViewPaneCanvas, 0);
            this.fTabFolderForMemoryBlock.put(memBlock, folder);
            this.fMemoryBlockFromTabFolder.put(folder, memBlock);
            this.setTabFolder((TabFolder)this.fTabFolderForMemoryBlock.get(memBlock));
            this.fViewPaneCanvas.layout();
        }
        IMemoryRendering[] renderings = this.fRenderingMgr.getRenderingsFromMemoryBlock(memBlock);
        TabFolder toDisplay = (TabFolder)this.fStackLayout.topControl;
        this.fTabFolderForDebugView.put(this.getMemoryBlockRetrieval(memBlock), toDisplay);
        if (toDisplay.getItemCount() == 0) {
            this.restoreViewTabs(renderings);
        }
        IMemoryViewTab newViewTab = this.getTopMemoryTab();
        if (lastViewTab != null && lastViewTab != newViewTab) {
            lastViewTab.setEnabled(false);
        }
        if (newViewTab != null && !newViewTab.isEnabled() && this.fVisible) {
            newViewTab.setEnabled(this.fVisible);
        }
        if ((viewTab = this.getTopMemoryTab()) != null) {
            this.setRenderingSelection(viewTab.getRendering());
        }
        if (viewTab == null && toDisplay != this.fEmptyTabFolder) {
            TabItem newItem = new TabItem(toDisplay, 0);
            CreateRendering rendering = new CreateRendering(this.getInstance());
            rendering.init(this.getInstance(), memBlock);
            MemoryViewTab createTab = new MemoryViewTab(newItem, rendering, this.getInstance());
            this.setRenderingSelection(createTab.getRendering());
        }
        this.updateToolBarActionsEnablement();
    }

    public void memoryBlockRenderingAdded(final IMemoryRendering rendering) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MemoryViewTab viewTab;
                TabItem item;
                if (RenderingViewPane.this.fAddedRenderings.contains(rendering)) {
                    return;
                }
                IMemoryBlock memoryblk = rendering.getMemoryBlock();
                if (RenderingViewPane.this.getTopMemoryTab() != null) {
                    RenderingViewPane.this.deactivateRendering(RenderingViewPane.this.getTopMemoryTab());
                    RenderingViewPane.this.getTopMemoryTab().setEnabled(false);
                }
                if (RenderingViewPane.this.fTabFolderForMemoryBlock.containsKey(memoryblk)) {
                    if (RenderingViewPane.this.fStackLayout.topControl != (TabFolder)RenderingViewPane.this.fTabFolderForMemoryBlock.get(memoryblk)) {
                        RenderingViewPane.this.setTabFolder((TabFolder)RenderingViewPane.this.fTabFolderForMemoryBlock.get(memoryblk));
                        RenderingViewPane.this.fViewPaneCanvas.layout();
                    }
                } else {
                    TabFolder folder = new TabFolder(RenderingViewPane.this.fViewPaneCanvas, 0);
                    RenderingViewPane.this.fTabFolderForMemoryBlock.put(memoryblk, folder);
                    RenderingViewPane.this.fMemoryBlockFromTabFolder.put(folder, memoryblk);
                    RenderingViewPane.this.setTabFolder((TabFolder)RenderingViewPane.this.fTabFolderForMemoryBlock.get(memoryblk));
                    RenderingViewPane.this.fViewPaneCanvas.layout();
                }
                TabFolder tabFolder = (TabFolder)RenderingViewPane.this.fStackLayout.topControl;
                RenderingViewPane.this.fTabFolderForDebugView.put(RenderingViewPane.this.getMemoryBlockRetrieval(memoryblk), tabFolder);
                if (tabFolder.getItemCount() >= 1 && (item = tabFolder.getItem(0)) != null && item.getData() instanceof MemoryViewTab && (viewTab = (MemoryViewTab)item.getData()).getRendering() instanceof CreateRendering) {
                    RenderingViewPane.this.disposeTab(item);
                }
                RenderingViewPane.this.fAddedRenderings.add(rendering);
                TabItem tab = new TabItem(tabFolder, 0);
                viewTab = new MemoryViewTab(tab, rendering, RenderingViewPane.this.getInstance());
                tabFolder.setSelection(tabFolder.indexOf(tab));
                RenderingViewPane.this.setRenderingSelection(viewTab.getRendering());
                IMemoryViewTab top = RenderingViewPane.this.getTopMemoryTab();
                if (top != null) {
                    top.setEnabled(RenderingViewPane.this.fVisible);
                }
                if (RenderingViewPane.this.fVisible) {
                    RenderingViewPane.this.activateRendering(top);
                }
                RenderingViewPane.this.updateToolBarActionsEnablement();
            }
        });
    }

    public void memoryBlockRenderingRemoved(final IMemoryRendering rendering) {
        final IMemoryBlock memory = rendering.getMemoryBlock();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                IDebugTarget target;
                IMemoryViewTab top;
                if (!RenderingViewPane.this.fAddedRenderings.contains(rendering)) {
                    return;
                }
                RenderingViewPane.this.fAddedRenderings.remove(rendering);
                TabFolder tabFolder = (TabFolder)RenderingViewPane.this.fStackLayout.topControl;
                if (tabFolder.isDisposed()) {
                    return;
                }
                TabItem[] tabs = tabFolder.getItems();
                boolean foundTab = false;
                int i = 0;
                while (i < tabs.length) {
                    IMemoryViewTab viewTab = (IMemoryViewTab)tabs[i].getData();
                    if (!tabs[i].isDisposed() && viewTab.getRendering().getMemoryBlock() == memory && viewTab.getRendering() == rendering) {
                        foundTab = true;
                        RenderingViewPane.this.disposeTab(tabs[i]);
                        break;
                    }
                    ++i;
                }
                if (!foundTab) {
                    Enumeration enumeration = RenderingViewPane.this.fTabFolderForMemoryBlock.elements();
                    block1: while (enumeration.hasMoreElements()) {
                        TabFolder otherTabFolder = (TabFolder)enumeration.nextElement();
                        tabs = otherTabFolder.getItems();
                        IMemoryViewTab viewTab = null;
                        int i2 = 0;
                        while (i2 < tabs.length) {
                            viewTab = (IMemoryViewTab)tabs[i2].getData();
                            if (viewTab.getRendering().getMemoryBlock() == memory && viewTab.getRendering() == rendering) {
                                foundTab = true;
                                RenderingViewPane.this.disposeTab(tabs[i2]);
                                continue block1;
                            }
                            ++i2;
                        }
                    }
                }
                if ((top = RenderingViewPane.this.getTopMemoryTab()) != null) {
                    RenderingViewPane.this.setRenderingSelection(top.getRendering());
                } else if (!(tabFolder == RenderingViewPane.this.fEmptyTabFolder || (target = memory.getDebugTarget()).isDisconnected() || target.isTerminated() || RenderingViewPane.this.isMeomryBlockRemoved(memory))) {
                    TabItem newItem = new TabItem(tabFolder, 0);
                    CreateRendering createRendering = new CreateRendering(RenderingViewPane.this.getInstance());
                    createRendering.init(RenderingViewPane.this.getInstance(), memory);
                    MemoryViewTab viewTab = new MemoryViewTab(newItem, createRendering, RenderingViewPane.this.getInstance());
                    tabFolder.setSelection(0);
                    RenderingViewPane.this.setRenderingSelection(viewTab.getRendering());
                }
                RenderingViewPane.this.updateToolBarActionsEnablement();
            }
        });
    }

    private boolean isMeomryBlockRemoved(IMemoryBlock memoryBlock) {
        IMemoryBlockRetrieval retrieval = this.getMemoryBlockRetrieval(memoryBlock);
        IMemoryBlock[] memoryBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks(retrieval);
        boolean removed = true;
        int i = 0;
        while (i < memoryBlocks.length) {
            if (memoryBlocks[i] == memoryBlock) {
                removed = false;
            }
            ++i;
        }
        return removed;
    }

    protected void setRenderingSelection(IMemoryRendering rendering) {
        if (rendering != null) {
            this.fSelectionProvider.setSelection((ISelection)new StructuredSelection((Object)rendering));
        }
    }

    private void restoreViewTabs(IMemoryRendering[] renderings) {
        int i = 0;
        while (i < renderings.length) {
            this.memoryBlockRenderingAdded(renderings[i]);
            ++i;
        }
    }

    private void handleDebugElementSelection(IMemoryViewTab lastViewTab, IDebugElement element) {
        Class<?> clazz;
        if (element.getDebugTarget() == null) {
            return;
        }
        if (element.getDebugTarget().isDisconnected() || element.getDebugTarget().isTerminated()) {
            this.emptyFolder();
            return;
        }
        IMemoryBlockRetrieval currentRetrieve = null;
        TabFolder tabFolder = (TabFolder)this.fStackLayout.topControl;
        IMemoryBlock currentBlock = (IMemoryBlock)this.fMemoryBlockFromTabFolder.get(tabFolder);
        if (currentBlock != null) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((currentRetrieve = (IMemoryBlockRetrieval)currentBlock.getAdapter((Class)clazz2)) == null) {
                currentRetrieve = currentBlock.getDebugTarget();
            }
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMemoryBlockRetrieval retrieve = (IMemoryBlockRetrieval)element.getAdapter((Class)clazz);
        IDebugTarget debugTarget = element.getDebugTarget();
        if (retrieve == null) {
            retrieve = debugTarget;
        }
        if (debugTarget == null || debugTarget.isTerminated() || debugTarget.isDisconnected()) {
            this.emptyFolder();
            return;
        }
        if (retrieve != currentRetrieve) {
            TabFolder folder = (TabFolder)this.fTabFolderForDebugView.get(retrieve);
            if (folder != null) {
                this.setTabFolder(folder);
                this.fTabFolderForDebugView.put(retrieve, folder);
                this.fViewPaneCanvas.layout();
            } else {
                IMemoryBlock[] blocks = MemoryViewUtil.getMemoryBlockManager().getMemoryBlocks(retrieve);
                if (blocks.length > 0) {
                    this.handleMemoryBlockSelection(null, blocks[0]);
                } else {
                    this.emptyFolder();
                    this.fTabFolderForDebugView.put(retrieve, this.fEmptyTabFolder);
                    this.fViewPaneCanvas.layout();
                }
            }
        }
        IMemoryViewTab newViewTab = this.getTopMemoryTab();
        if (lastViewTab != null && lastViewTab != newViewTab) {
            lastViewTab.setEnabled(false);
        }
        if (newViewTab != null) {
            if (!newViewTab.isEnabled() && this.fVisible) {
                newViewTab.setEnabled(this.fVisible);
            }
            this.setRenderingSelection(newViewTab.getRendering());
        }
        this.updateToolBarActionsEnablement();
    }

    protected void addListeners() {
        super.addListeners();
    }

    protected void removeListeners() {
        super.removeListeners();
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.getTopMemoryTab() == null) {
            return;
        }
        IMemoryRendering rendering = this.getTopMemoryTab().getRendering();
        if (rendering != null) {
            this.fSelectionProvider.setSelection((ISelection)new StructuredSelection((Object)rendering));
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public Object getCurrentSelection() {
        if (this.getTopMemoryTab() != null && this.getTopMemoryTab().getRendering() != null) {
            return this.getTopMemoryTab().getRendering();
        }
        return null;
    }

    public IMemoryViewTab[] getAllViewTabs() {
        TabFolder folder = (TabFolder)this.fStackLayout.topControl;
        TabItem[] items = folder.getItems();
        IMemoryViewTab[] viewTabs = new IMemoryViewTab[folder.getItemCount()];
        int i = 0;
        while (i < items.length) {
            viewTabs[i] = (IMemoryViewTab)items[i].getData();
            ++i;
        }
        return viewTabs;
    }

    public void moveToTop(IMemoryViewTab viewTab) {
        IMemoryViewTab lastViewTab = this.getTopMemoryTab();
        if (viewTab == lastViewTab) {
            return;
        }
        TabFolder folder = (TabFolder)this.fStackLayout.topControl;
        TabItem[] items = folder.getItems();
        int i = 0;
        while (i < items.length) {
            IMemoryViewTab tab = (IMemoryViewTab)items[i].getData();
            if (viewTab == tab) {
                boolean isEnabled = lastViewTab.isEnabled();
                lastViewTab.setEnabled(false);
                folder.setSelection(i);
                this.setRenderingSelection(tab.getRendering());
                this.getTopMemoryTab().setEnabled(isEnabled && this.fVisible);
                break;
            }
            ++i;
        }
    }

    public void restoreViewPane() {
        ISelection selection = null;
        if (this.fParent.getSite().getSelectionProvider() != null) {
            selection = this.fParent.getSite().getSelectionProvider().getSelection();
        }
        IMemoryBlock memoryBlock = null;
        if (selection != null) {
            memoryBlock = this.getMemoryBlock(selection);
        }
        if (memoryBlock == null && MemoryViewUtil.isValidSelection(selection = this.fSelectionProvider.getSelection())) {
            Object elem = ((IStructuredSelection)selection).getFirstElement();
            if (!(elem instanceof IMemoryBlock)) {
                return;
            }
            memoryBlock = (IMemoryBlock)elem;
        }
        if (memoryBlock != null) {
            IMemoryViewTab top;
            TabFolder toDisplay;
            if (!this.fTabFolderForMemoryBlock.containsKey(memoryBlock)) {
                TabFolder folder = new TabFolder(this.fViewPaneCanvas, 0);
                this.fTabFolderForMemoryBlock.put(memoryBlock, folder);
                this.fMemoryBlockFromTabFolder.put(folder, memoryBlock);
                this.setTabFolder((TabFolder)this.fTabFolderForMemoryBlock.get(memoryBlock));
                this.fTabFolderForDebugView.put(this.getMemoryBlockRetrieval(memoryBlock), this.fTabFolderForMemoryBlock.get(memoryBlock));
                this.fViewPaneCanvas.layout();
            }
            if (this.fTabFolderForMemoryBlock.containsKey(memoryBlock) && (toDisplay = (TabFolder)this.fTabFolderForMemoryBlock.get(memoryBlock)) != null) {
                this.setTabFolder(toDisplay);
                this.fTabFolderForDebugView.put(this.getMemoryBlockRetrieval(memoryBlock), toDisplay);
                this.fViewPaneCanvas.layout();
                IMemoryRendering[] renderings = this.fRenderingMgr.getRenderingsFromMemoryBlock(memoryBlock);
                if (toDisplay.getItemCount() == 0 || this.getTopMemoryTab().getRendering() instanceof CreateRendering) {
                    this.restoreViewTabs(renderings);
                }
            }
            if ((top = this.getTopMemoryTab()) != null) {
                top.setEnabled(this.fVisible);
            } else {
                TabFolder folder = (TabFolder)this.fStackLayout.topControl;
                if (folder != this.fEmptyTabFolder) {
                    TabItem newItem = new TabItem(folder, 0);
                    CreateRendering rendering = new CreateRendering(this);
                    rendering.init(this.getInstance(), memoryBlock);
                    new MemoryViewTab(newItem, rendering, this);
                    folder.setSelection(0);
                    this.setRenderingSelection(rendering);
                }
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.fAddMemoryRenderingAction.dispose();
        this.fTabFolderForMemoryBlock.clear();
        this.fTabFolderForMemoryBlock = null;
        this.fMemoryBlockFromTabFolder.clear();
        this.fMemoryBlockFromTabFolder = null;
        this.fRenderingMgr.dispose();
        this.fRenderingMgr = null;
        this.fAddedMemoryBlocks.clear();
        this.fAddedRenderings.clear();
    }

    public Control createViewPane(Composite parent, String paneId, String label) {
        Control control = super.createViewPane(parent, paneId, label);
        this.fRenderingMgr = new ViewPaneRenderingMgr(this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".MemoryRenderingView_context");
        return control;
    }

    public IAction[] getActions() {
        ArrayList<AddMemoryRenderingAction> actions = new ArrayList<AddMemoryRenderingAction>();
        if (this.fAddMemoryRenderingAction == null) {
            this.fAddMemoryRenderingAction = new AddMemoryRenderingAction(this);
        }
        actions.add(this.fAddMemoryRenderingAction);
        if (this.fRemoveMemoryRenderingAction == null) {
            this.fRemoveMemoryRenderingAction = new RemoveMemoryRenderingAction(this);
        }
        this.fRemoveMemoryRenderingAction.setEnabled(false);
        actions.add((AddMemoryRenderingAction)this.fRemoveMemoryRenderingAction);
        return actions.toArray(new IAction[actions.size()]);
    }

    protected void updateToolBarActionsEnablement() {
        IDebugTarget target = this.getSelectedDebugTarget();
        if (target != null) {
            IMemoryBlock[] blocks = MemoryViewUtil.getMemoryBlockManager().getMemoryBlocks(target);
            if (blocks.length > 0) {
                this.fRemoveMemoryRenderingAction.setEnabled(true);
            } else {
                this.fRemoveMemoryRenderingAction.setEnabled(false);
            }
        } else {
            this.fRemoveMemoryRenderingAction.setEnabled(false);
        }
    }

    private IDebugTarget getSelectedDebugTarget() {
        ISelection selection = this.fParent.getViewSite().getPage().getSelection("org.eclipse.debug.ui.DebugView");
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Object elem = ((IStructuredSelection)selection).getFirstElement();
            if (elem != null && elem instanceof IDebugElement) {
                return ((IDebugElement)elem).getDebugTarget();
            }
            return null;
        }
        return null;
    }

    protected void emptyFolder() {
        super.emptyFolder();
        this.updateToolBarActionsEnablement();
        this.fSelectionProvider.setSelection((ISelection)AbstractMemoryViewPane.EMPTY);
    }

    public void addMemoryRendering(IMemoryRendering rendering) {
        if (rendering == null) {
            return;
        }
        this.memoryBlockRenderingAdded(rendering);
        this.fRenderingMgr.addMemoryBlockRendering(rendering);
    }

    public void removeMemoryRendering(IMemoryRendering rendering) {
        if (rendering == null) {
            return;
        }
        this.memoryBlockRenderingRemoved(rendering);
        if (this.fRenderingMgr != null) {
            this.fRenderingMgr.removeMemoryBlockRendering(rendering);
        }
    }

    private RenderingViewPane getInstance() {
        return this;
    }

    private IMemoryBlock getMemoryBlock(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        if (selection == null || selection.isEmpty() || ((IStructuredSelection)selection).size() > 1) {
            return null;
        }
        Object elem = ((IStructuredSelection)selection).getFirstElement();
        if (elem instanceof IMemoryBlock) {
            return (IMemoryBlock)elem;
        }
        if (elem instanceof IMemoryRendering) {
            return ((IMemoryRendering)elem).getMemoryBlock();
        }
        return null;
    }

    private void activateRendering(IMemoryViewTab viewTab) {
        if (viewTab == null) {
            return;
        }
        if (!viewTab.isDisposed()) {
            viewTab.getRendering().activated();
            this.setRenderingSelection(viewTab.getRendering());
            this.fSelectionProvider.fireChanged();
        }
    }

    private void deactivateRendering(IMemoryViewTab viewTab) {
        if (viewTab == null) {
            return;
        }
        if (!viewTab.isDisposed()) {
            viewTab.getRendering().deactivated();
        }
    }

    public IMemoryRenderingSite getMemoryRenderingSite() {
        return this.fRenderingSite;
    }

    public String getId() {
        return this.getPaneId();
    }

    public IMemoryRendering[] getRenderings() {
        return this.fRenderingMgr.getRenderings();
    }

    public IMemoryRendering getActiveRendering() {
        return this.getTopMemoryTab().getRendering();
    }
}

