/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.IRemoteTreeViewerUpdateListener;
import org.eclipse.debug.internal.ui.views.RemoteTreeViewer;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.progress.UIJob;

public class VariablesViewer
extends RemoteTreeViewer {
    private ArrayList fUpdateListeners = new ArrayList();
    private StateRestorationJob fStateRestorationJob = new StateRestorationJob(DebugUIViewsMessages.RemoteTreeViewer_0);
    private VariablesView fView = null;

    public VariablesViewer(Composite parent, int style, VariablesView view) {
        super(parent, style);
        this.fView = view;
    }

    protected Item newItem(Widget parent, int style, int index) {
        Item item = super.newItem(parent, style, index);
        if (index != -1 && this.getSelection(this.getControl()).length == 0) {
            this.showItem(item);
        }
        return item;
    }

    public void setExpandedElements(Object[] elements) {
        this.getControl().setRedraw(false);
        super.setExpandedElements(elements);
        this.getControl().setRedraw(true);
    }

    protected void runDeferredUpdates() {
        super.runDeferredUpdates();
        this.fStateRestorationJob.schedule();
    }

    public void collapseAll() {
        if (this.getRoot() != null) {
            super.collapseAll();
        }
    }

    protected synchronized void restoreExpansionState() {
        this.cancelJobs();
        Iterator i = this.fUpdateListeners.iterator();
        while (i.hasNext()) {
            IRemoteTreeViewerUpdateListener listener = (IRemoteTreeViewerUpdateListener)i.next();
            listener.treeUpdated();
        }
    }

    public void addUpdateListener(IRemoteTreeViewerUpdateListener listener) {
        this.fUpdateListeners.add(listener);
    }

    public void removeUpdateListener(IRemoteTreeViewerUpdateListener listener) {
        this.fUpdateListeners.remove(listener);
    }

    public synchronized void replace(Object parent, Object[] children, int offset) {
        if (this.fView != null) {
            if (children.length == 1 && children[0] instanceof DebugException) {
                String message;
                IStatus status = ((DebugException)((Object)children[0])).getStatus();
                if (status != null && (message = status.getMessage()) != null) {
                    this.fView.showMessage(message);
                }
                return;
            }
            this.fView.showViewer();
        }
        super.replace(parent, children, offset);
    }

    public boolean expandPath(IPath path) {
        String[] strings = path.segments();
        Item[] children = this.getChildren((Widget)this.getControl());
        return this.internalExpandPath(strings, 0, children);
    }

    protected boolean internalExpandPath(String[] segments, int index, Item[] children) {
        try {
            String pathSegment = segments[index];
            int j = 0;
            while (j < children.length) {
                Item child = children[j];
                Object data = child.getData();
                String name = null;
                if (data instanceof IVariable) {
                    IVariable var = (IVariable)data;
                    name = var.getName();
                } else if (data instanceof IRegisterGroup) {
                    IRegisterGroup registerGroup = (IRegisterGroup)data;
                    name = registerGroup.getName();
                }
                if (name != null && pathSegment.equals(name)) {
                    ITreeContentProvider provider = (ITreeContentProvider)this.getContentProvider();
                    provider.getChildren(child.getData());
                    this.setExpanded(child, true);
                    if (++index < segments.length) {
                        Item[] newChildren = this.getChildren((Widget)child);
                        return this.internalExpandPath(segments, index, newChildren);
                    }
                    return true;
                }
                ++j;
            }
        }
        catch (DebugException debugException) {}
        return false;
    }

    private class StateRestorationJob
    extends UIJob {
        public StateRestorationJob(String name) {
            super(name);
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            VariablesViewer.this.restoreExpansionState();
            return Status.OK_STATUS;
        }
    }
}

