/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.common.internal.annotations.controller.AnnotationsController;
import org.eclipse.jst.common.internal.annotations.controller.AnnotationsControllerManager;
import org.eclipse.jst.j2ee.internal.common.operations.NewJavaClassDataModel;
import org.eclipse.jst.j2ee.internal.project.WTPJETEmitter;
import org.eclipse.jst.j2ee.internal.web.operations.CreateServletTemplateModel;
import org.eclipse.jst.j2ee.internal.web.operations.NewServletClassDataModel;
import org.eclipse.wst.common.componentcore.internal.operation.ArtifactEditOperation;
import org.eclipse.wst.common.componentcore.internal.operation.ArtifactEditOperationDataModel;
import org.eclipse.wst.common.frameworks.internal.enablement.nonui.WFTWrappedException;

public class NewServletClassOperation
extends ArtifactEditOperation {
    private static final String DOT_JAVA = ".java";
    private static final String PLATFORM_PLUGIN = "platform:/plugin/";
    protected static final String WEB_PLUGIN = "WEB_PLUGIN";
    protected static final String TEMPLATE_DIR = "/templates/";
    protected static final String TEMPLATE_EMITTER = "org.eclipse.jst.j2ee.ejb.annotations.emitter.template";
    protected static final String BUILDER_ID = "builderId";

    public NewServletClassOperation(ArtifactEditOperationDataModel dataModel) {
        super(dataModel);
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        this.createJavaSourceFolder();
        IPackageFragment pack = this.createJavaPackage();
        this.generateUsingTemplates(monitor, pack);
    }

    protected final IPackageFragment createJavaPackage() {
        NewJavaClassDataModel model = (NewJavaClassDataModel)this.operationDataModel;
        String packageName = model.getStringProperty("NewJavaClassDataModel.JAVA_PACKAGE");
        IPackageFragmentRoot packRoot = model.getJavaPackageFragmentRoot();
        IPackageFragment pack = packRoot.getPackageFragment(packageName);
        if (pack == null) {
            pack = packRoot.getPackageFragment("");
        }
        if (!pack.exists()) {
            String packName = pack.getElementName();
            try {
                pack = packRoot.createPackageFragment(packName, true, null);
            }
            catch (JavaModelException e) {
                Logger.getLogger().log((Throwable)e);
            }
        }
        return pack;
    }

    protected void generateUsingTemplates(IProgressMonitor monitor, IPackageFragment fragment) throws WFTWrappedException, CoreException {
        String source;
        CreateServletTemplateModel tempModel = this.createTemplateModel();
        IProject project = ((ArtifactEditOperationDataModel)this.getOperationDataModel()).getTargetProject();
        try {
            source = this.generateTemplateSource(tempModel, monitor);
        }
        catch (JETException e) {
            throw new WFTWrappedException((Throwable)e);
        }
        if (fragment != null) {
            String javaFileName = String.valueOf(tempModel.getServletClassName()) + DOT_JAVA;
            ICompilationUnit cu = fragment.getCompilationUnit(javaFileName);
            if (cu == null || !cu.exists()) {
                cu = fragment.createCompilationUnit(javaFileName, source, true, monitor);
            }
            IFile aFile = (IFile)cu.getResource();
            AnnotationsController controller = AnnotationsControllerManager.INSTANCE.getAnnotationsController(project);
            if (controller != null) {
                controller.process((IResource)aFile);
            }
        }
        this.addAnnotationsBuilder();
    }

    private void addAnnotationsBuilder() {
        AnnotationsControllerManager.Descriptor descriptor = AnnotationsControllerManager.INSTANCE.getDescriptor(this.getComponent().getComponentHandle().getProject());
        if (descriptor != null) {
            return;
        }
        try {
            NewServletClassDataModel dataModel = (NewServletClassDataModel)this.operationDataModel;
            IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(TEMPLATE_EMITTER);
            String builderID = String.valueOf(configurationElements[0].getNamespace()) + "." + configurationElements[0].getAttribute(BUILDER_ID);
            IProject project = dataModel.getTargetProject();
            IProjectDescription description = project.getDescription();
            ICommand[] commands = description.getBuildSpec();
            boolean found = false;
            int i = 0;
            while (i < commands.length) {
                if (commands[i].getBuilderName().equals(builderID)) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                ICommand command = description.newCommand();
                command.setBuilderName(builderID);
                ICommand[] newCommands = new ICommand[commands.length + 1];
                System.arraycopy(commands, 0, newCommands, 0, commands.length);
                newCommands[commands.length] = command;
                IProjectDescription desc = project.getDescription();
                desc.setBuildSpec(newCommands);
                project.setDescription(desc, null);
            }
        }
        catch (Exception exception) {}
    }

    private String generateTemplateSource(CreateServletTemplateModel tempModel, IProgressMonitor monitor) throws JETException {
        String templateURI = ((NewServletClassDataModel)this.getOperationDataModel()).getBooleanProperty("IAnnotationsDataModel.useAnnotations") ? "platform:/plugin/org.eclipse.jst.j2ee.web/templates/servletXDoclet.javajet" : "platform:/plugin/org.eclipse.jst.j2ee.web/templates/servletXDocletNonAnnotated.javajet";
        WTPJETEmitter emitter = new WTPJETEmitter(templateURI, ((Object)((Object)this)).getClass().getClassLoader());
        emitter.setIntelligentLinkingEnabled(true);
        emitter.addVariable(WEB_PLUGIN, "org.eclipse.jst.j2ee.web");
        return emitter.generate(monitor, new Object[]{tempModel});
    }

    private CreateServletTemplateModel createTemplateModel() {
        CreateServletTemplateModel model = new CreateServletTemplateModel((NewServletClassDataModel)this.getOperationDataModel());
        return model;
    }

    protected final IFolder createJavaSourceFolder() {
        NewJavaClassDataModel model = (NewJavaClassDataModel)this.operationDataModel;
        String folderFullPath = model.getStringProperty("NewJavaClassDataModel.SOURCE_FOLDER");
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFolder folder = root.getFolder((IPath)new Path(folderFullPath));
        if (!folder.exists()) {
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                Logger.getLogger().log((Throwable)e);
            }
        }
        return folder;
    }
}

