/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal.ui;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.eclipse.wst.common.snippets.internal.ISnippetVariable;
import org.eclipse.wst.common.snippets.internal.SnippetDefinitions;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteItem;
import org.eclipse.wst.common.snippets.internal.palette.SnippetVariable;
import org.eclipse.wst.common.snippets.internal.provisional.ISnippetsEntry;
import org.eclipse.wst.common.snippets.internal.util.CommonXML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EntryDeserializer {
    private static EntryDeserializer reader = null;

    public static synchronized EntryDeserializer getInstance() {
        reader = new EntryDeserializer();
        return reader;
    }

    protected EntryDeserializer() {
    }

    protected void addItem(SnippetDefinitions definitions, Element element) {
        SnippetPaletteItem item = this.createItem(element);
        definitions.getItems().add(item);
    }

    protected void assignEntryProperties(Element element, ISnippetsEntry entry) {
        entry.setId(element.getAttribute("id"));
        entry.setIconName(element.getAttribute("icon"));
        String description = this.createDescription(element);
        String label = element.getAttribute("label");
        if ((label == null || label.length() == 0) && description != null) {
            label = description;
            description = "";
        }
        entry.setDescription(description);
        entry.setLabel(label);
    }

    protected String createContent(Node item) {
        return this.readCDATAofChild(item, "content");
    }

    protected String createDescription(Node entryElement) {
        return this.readCDATAofChild(entryElement, "description");
    }

    protected SnippetPaletteItem createItem(Element element) {
        SnippetPaletteItem item = new SnippetPaletteItem(element.getAttribute("id"));
        this.assignEntryProperties(element, item);
        item.setContentString(this.createContent(element));
        item.setCategoryName(element.getAttribute("category"));
        item.setClassName(element.getAttribute("class"));
        item.setEditorClassName(element.getAttribute("editorclass"));
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        int i = 0;
        while (i < length) {
            ISnippetVariable var;
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals("variable") && (var = this.createVariable((Element)child)) != null) {
                item.addVariable(var);
            }
            ++i;
        }
        return item;
    }

    protected ISnippetVariable createVariable(Element element) {
        SnippetVariable var = new SnippetVariable();
        var.setId(element.getAttribute("id"));
        var.setName(element.getAttribute("name"));
        var.setDescription(this.createDescription(element));
        var.setDefaultValue(element.getAttribute("default"));
        return var;
    }

    public ISnippetsEntry fromXML(byte[] xml) {
        SnippetPaletteItem entry = null;
        try {
            Document document = CommonXML.getDocumentBuilder().parse(new InputSource(new ByteArrayInputStream(xml)));
            Element el = document.getDocumentElement();
            if (el != null && el.hasChildNodes()) {
                Node child = el.getFirstChild();
                while (child.getNodeType() != 1) {
                    child = child.getNextSibling();
                }
                if (child.getNodeName().equals("item")) {
                    SnippetPaletteItem item = this.createItem((Element)child);
                    item.setCategoryName(null);
                    item.setCategory(null);
                    item.setClassName(null);
                    item.setEditorClassName(null);
                    item.setIconName(null);
                    entry = item;
                } else {
                    child.getNodeName().equals("category");
                }
            }
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
        return entry;
    }

    protected String readCDATAofChild(Node node, String childName) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals(childName)) {
                NodeList descriptionChildren = child.getChildNodes();
                int j = 0;
                while (j < descriptionChildren.getLength()) {
                    String value;
                    Node descriptionChild = descriptionChildren.item(j);
                    if (descriptionChild.getNodeType() == 4 && (value = descriptionChild.getNodeValue()) != null) {
                        return value;
                    }
                    ++j;
                }
                return "";
            }
            ++i;
        }
        return "";
    }
}

