/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.derby.internal.ui.connection.dialogs;

import java.text.MessageFormat;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wst.rdb.connection.internal.ui.factories.RSCCoreUIWidgetFactory;
import org.eclipse.wst.rdb.connection.internal.ui.providers.IServerConnectionInformation;
import org.eclipse.wst.rdb.connection.internal.ui.providers.IServerConnectionUIProvider;
import org.eclipse.wst.rdb.connection.internal.ui.wizards.NewConnectionWizard;
import org.eclipse.wst.rdb.derby.internal.ui.util.ResourceLoader;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;

public class DerbyUniversalNewConnectionProvider
implements IServerConnectionUIProvider,
Listener {
    private static final RSCCoreUIWidgetFactory factory = RSCCoreUIWidgetFactory.INSTANCE;
    private static final ResourceLoader resource = ResourceLoader.INSTANCE;
    private static final String CUI_NEWCW_DATABASE_LBL_UI_ = resource.queryString("CUI_NEWCW_UNI_DATABASE_LBL_UI_");
    private static final String CUI_NEWCW_CREATEDB_BTN_UI_ = resource.queryString("CUI_NEWCW_CREATEDB_BTN_UI_");
    private static final String CUI_NEWCW_HOST_LBL_UI_ = resource.queryString("CUI_NEWCW_UNI_HOST_LBL_UI_");
    private static final String CUI_NEWCW_PORT_LBL_UI_ = resource.queryString("CUI_NEWCW_UNI_PORT_LBL_UI_");
    private static final String CUI_NEWCW_JDBCDRIVERCLS_LBL_UI_ = resource.queryString("CUI_NEWCW_UNI_JDBCDRIVERCLS_LBL_UI_");
    private static final String CUI_NEWCW_JDBCCLSLOCATION_LBL_UI_ = resource.queryString("CUI_NEWCW_UNI_JDBCCLSLOCATION_LBL_UI_");
    private static final String CUI_NEWCW_JARBROWSE_BTN_UI_ = resource.queryString("CUI_NEWCW_UNI_JARBROWSE_BTN_UI_");
    private static final String CUI_NEWCW_CONNECTIONURL_LBL_UI_ = resource.queryString("CUI_NEWCW_UNI_CONNECTIONURL_LBL_UI_");
    private static final String DRIVER_CLASS_NAME = "com.ibm.db2.jcc.DB2Driver";
    private static final String CREATE_EQUALS_TRUE_TEXT = "create=true";
    private static final String RETURN_MESSAGES = ":retrieveMessagesFromServerOnGetMessage=true;";
    private IServerConnectionInformation connectionInformation;
    private Label databaseLabel;
    private Text databaseCombo;
    private Button createCheck;
    private Label hostLabel;
    private Text hostCombo;
    private Label portLabel;
    private Label driverLabel;
    private Text driverDisplay;
    private Label locationLabel;
    private Text locationCombo;
    private Button browseLocation;
    private Label urlLabel;
    private Text urlDisplay;
    private Text portCombo;
    private WizardPage parentPage;
    private Composite parentComposite;

    private void createLayout(Composite parentComposite) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        parentComposite.setLayout((Layout)layout);
    }

    public boolean determinePageCompletion() {
        return this.validateControl();
    }

    private void setConnectionInformation() {
        this.connectionInformation.setDriverClassName(DRIVER_CLASS_NAME);
        this.connectionInformation.setDatabaseName(this.databaseCombo.getText());
        this.connectionInformation.setLoadingPath(this.locationCombo.getText());
        this.connectionInformation.setURL(this.urlDisplay.getText());
        if (this.determinePageCompletion()) {
            this.connectionInformation.setInformationComplete(true);
        }
    }

    private boolean validateControl() {
        if (this.databaseCombo.getText() == null || this.databaseCombo.getText().equals("")) {
            this.parentPage.setErrorMessage(MessageFormat.format(NewConnectionWizard.getResourceString((String)"CUI_NEWCW_VALIDATE_DATABASE_REQ_UI_"), NewConnectionWizard.getResourceString((String)"CUI_NEWCW_DEFDBNAME_VAL_UI_")));
            return false;
        }
        if (this.hostCombo != null && this.hostCombo.isEnabled() && this.hostCombo.getText().length() < 1) {
            this.parentPage.setErrorMessage(NewConnectionWizard.getResourceString((String)"CUI_NEWCW_VALIDATE_HOST_REQ_UI_"));
            return false;
        }
        if (this.portCombo != null && this.portCombo.isEnabled() && this.portCombo.getText().length() < 1) {
            this.parentPage.setErrorMessage(NewConnectionWizard.getResourceString((String)"CUI_NEWCW_VALIDATE_PORT_REQ_UI_"));
            return false;
        }
        if (this.driverDisplay != null && this.driverDisplay.getEnabled() && this.driverDisplay.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(NewConnectionWizard.getResourceString((String)"CUI_NEWCW_VALIDATE_DRIVERCLASS_REQ_UI_"));
            return false;
        }
        if (this.locationCombo != null && this.locationCombo.getText().trim().length() < 1) {
            this.parentPage.setErrorMessage(NewConnectionWizard.getResourceString((String)"CUI_NEWCW_VALIDATE_CLASSLOCATION_REQ_UI_"));
            return false;
        }
        if (this.urlDisplay != null && this.urlDisplay.getText().trim().length() == 0) {
            this.parentPage.setErrorMessage(NewConnectionWizard.getResourceString((String)"CUI_NEWCW_VALIDATE_URL_REQ_UI_"));
            return false;
        }
        return true;
    }

    private void addListeners() {
        this.locationCombo.addListener(24, (Listener)this);
        this.browseLocation.addListener(13, (Listener)this);
        this.databaseCombo.addListener(24, (Listener)this);
        this.createCheck.addListener(13, (Listener)this);
        this.hostCombo.addListener(24, (Listener)this);
        this.portCombo.addListener(24, (Listener)this);
        this.urlDisplay.addListener(24, (Listener)this);
    }

    private void initialize() {
        this.driverDisplay.setText(DRIVER_CLASS_NAME);
        this.connectionInformation.setDriverClassName(DRIVER_CLASS_NAME);
        this.databaseCombo.setText("sample");
        this.hostCombo.setText("localhost");
        this.portCombo.setText("1527");
        this.updateURL();
        this.addListeners();
        this.determinePageCompletion();
    }

    private void updateURL() {
        String url = "jdbc:derby:net://" + this.hostCombo.getText() + ":" + this.portCombo.getText() + "/" + this.encodeDatabaseName(this.databaseCombo.getText()) + RETURN_MESSAGES;
        this.urlDisplay.setText(url);
        this.connectionInformation.setURL(url);
    }

    private String encodeDatabaseName(String name) {
        String processedName = name;
        processedName = String.valueOf(processedName) + (!this.createCheck.getSelection() ? "" : ";create=true");
        if (name.indexOf(47) > -1 || name.indexOf(92) > -1) {
            processedName = "\"" + processedName + "\"";
        }
        return processedName;
    }

    private String decodeDatabaseName(String name) {
        String processedName = name;
        if (name.indexOf(34) > -1) {
            String remainingName = name.substring(name.indexOf(34) + 1);
            processedName = remainingName.substring(0, remainingName.indexOf(34));
        } else if (name.indexOf(58) > -1) {
            processedName = name.substring(0, name.indexOf(58));
        }
        return processedName;
    }

    private void removeListeners() {
        this.locationCombo.removeListener(24, (Listener)this);
        this.browseLocation.removeListener(13, (Listener)this);
        this.databaseCombo.removeListener(24, (Listener)this);
        this.createCheck.removeListener(13, (Listener)this);
        this.hostCombo.removeListener(24, (Listener)this);
        this.portCombo.removeListener(24, (Listener)this);
        this.urlDisplay.removeListener(24, (Listener)this);
    }

    private Composite createServerConnectionUI(Composite parent) {
        this.parentComposite = factory.createComposite(parent, 0);
        this.createLayout(this.parentComposite);
        this.databaseLabel = factory.createLabel(this.parentComposite, 0);
        this.databaseLabel.setText(CUI_NEWCW_DATABASE_LBL_UI_);
        GridData gd = new GridData();
        gd.verticalAlignment = 1;
        this.databaseLabel.setLayoutData((Object)gd);
        this.databaseCombo = factory.createText(this.parentComposite, 2052);
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        this.databaseCombo.setLayoutData((Object)gd);
        this.createCheck = factory.createButton(this.parentComposite, 32);
        this.createCheck.setText(CUI_NEWCW_CREATEDB_BTN_UI_);
        this.createCheck.setSelection(true);
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalSpan = 3;
        this.createCheck.setLayoutData((Object)gd);
        this.hostLabel = factory.createLabel(this.parentComposite, 0);
        this.hostLabel.setText(CUI_NEWCW_HOST_LBL_UI_);
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalSpan = 1;
        this.hostLabel.setLayoutData((Object)gd);
        this.hostCombo = factory.createText(this.parentComposite, 2052);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        this.hostCombo.setLayoutData((Object)gd);
        this.portLabel = factory.createLabel(this.parentComposite, 0);
        this.portLabel.setText(CUI_NEWCW_PORT_LBL_UI_);
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalSpan = 1;
        this.portLabel.setLayoutData((Object)gd);
        this.portCombo = factory.createText(this.parentComposite, 2052);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.portCombo.setLayoutData((Object)gd);
        this.driverLabel = factory.createLabel(this.parentComposite, 0);
        this.driverLabel.setText(CUI_NEWCW_JDBCDRIVERCLS_LBL_UI_);
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalSpan = 1;
        this.driverLabel.setLayoutData((Object)gd);
        this.driverDisplay = factory.createText(this.parentComposite, 2060);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.driverDisplay.setLayoutData((Object)gd);
        this.locationLabel = factory.createLabel(this.parentComposite, 0);
        this.locationLabel.setText(CUI_NEWCW_JDBCCLSLOCATION_LBL_UI_);
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalSpan = 1;
        this.locationLabel.setLayoutData((Object)gd);
        this.locationCombo = factory.createText(this.parentComposite, 2052);
        gd = new GridData();
        gd.widthHint = 200;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.locationCombo.setLayoutData((Object)gd);
        this.browseLocation = factory.createButton(this.parentComposite, 8);
        this.browseLocation.setText(CUI_NEWCW_JARBROWSE_BTN_UI_);
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 1;
        this.browseLocation.setLayoutData((Object)gd);
        this.urlLabel = factory.createLabel(this.parentComposite, 0);
        this.urlLabel.setText(CUI_NEWCW_CONNECTIONURL_LBL_UI_);
        gd = new GridData();
        gd.verticalAlignment = 1;
        gd.horizontalSpan = 1;
        this.urlLabel.setLayoutData((Object)gd);
        this.urlDisplay = factory.createText(this.parentComposite, 2060);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        gd.widthHint = 200;
        this.urlDisplay.setLayoutData((Object)gd);
        this.initialize();
        return this.parentComposite;
    }

    public Composite getServerConnectionUI(Composite parent) {
        if (this.parentComposite == null || this.parentComposite.isDisposed()) {
            this.parentComposite = this.createServerConnectionUI(parent);
        }
        this.setConnectionInformation();
        return this.parentComposite;
    }

    public void setServerConnectionInformation(IServerConnectionInformation connectionInformation) {
        this.connectionInformation = connectionInformation;
    }

    public void setDatabaseDefinition(DatabaseDefinition definition) {
    }

    public void setWizardPage(WizardPage parentPage) {
        this.parentPage = parentPage;
    }

    public void handleEvent(Event event) {
        Widget source = event.widget;
        if (source == this.databaseCombo) {
            this.updateURL();
        } else if (source == this.createCheck) {
            this.updateURL();
        } else if (source != this.locationCombo) {
            String file;
            if (source == this.hostCombo) {
                this.updateURL();
            } else if (source == this.portCombo) {
                this.updateURL();
            } else if (source == this.browseLocation && (file = NewConnectionWizard.getFile((Wizard)((Wizard)this.parentPage.getWizard()), (String[])NewConnectionWizard.fExtensions)) != null && file.length() > 0) {
                this.locationCombo.removeListener(24, (Listener)this);
                this.locationCombo.setText(file);
                this.locationCombo.addListener(24, (Listener)this);
                this.connectionInformation.setLoadingPath(file);
            }
        }
        this.setConnectionInformation();
    }

    public void loadProperties() {
        this.removeListeners();
        String rawURL = this.connectionInformation.getURL();
        if (rawURL.indexOf(CREATE_EQUALS_TRUE_TEXT) <= -1) {
            this.createCheck.setSelection(false);
        } else {
            rawURL = rawURL.replaceFirst(";create=true", "");
            this.createCheck.setSelection(true);
        }
        DerbyUniversalJDBCURL url = new DerbyUniversalJDBCURL(rawURL);
        this.locationCombo.setText(this.connectionInformation.getLoadingPath());
        this.hostCombo.setText(url.getNode());
        this.portCombo.setText(url.getPort());
        this.databaseCombo.setText(url.getDatabaseName());
        this.updateURL();
        this.addListeners();
        this.setConnectionInformation();
    }

    private class DerbyUniversalJDBCURL {
        private String subprotocol = "";
        private String node = "";
        private String port = "";
        private String databaseName = "";
        private String properties = "";

        public DerbyUniversalJDBCURL(String url) {
            this.parseURL(url);
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getNode() {
            return this.node;
        }

        public String getSubprotocol() {
            return this.subprotocol;
        }

        private void parseURL(String url) {
            try {
                String remainingURL = url.substring(url.indexOf(58) + 1);
                this.subprotocol = remainingURL.substring(0, remainingURL.indexOf(58));
                remainingURL = remainingURL.substring(remainingURL.indexOf(58) + 1);
                this.subprotocol = String.valueOf(this.subprotocol) + remainingURL.substring(0, remainingURL.indexOf(58));
                remainingURL = remainingURL.substring(remainingURL.indexOf(58) + 3);
                this.node = remainingURL.substring(0, remainingURL.indexOf(47));
                if (this.node.indexOf(58) > -1) {
                    this.port = this.node.substring(this.node.indexOf(58) + 1);
                    this.node = this.node.substring(0, this.node.indexOf(58));
                }
                remainingURL = remainingURL.substring(remainingURL.indexOf(47) + 1);
                this.databaseName = DerbyUniversalNewConnectionProvider.this.decodeDatabaseName(remainingURL);
            }
            catch (Exception exception) {}
        }

        public String getPort() {
            return this.port;
        }

        public String getProperties() {
            return this.properties;
        }
    }
}

