/***************************************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 **************************************************************************************************/
package org.eclipse.wst.common.navigator.internal.provisional.views;

import org.eclipse.jface.viewers.ILabelProvider;

/**
 * <p>
 * A custom interface for Common Navigator extensions that either (1) require more information about
 * the specific {@see org.eclipse.wst.common.navigator.views.CommonViewer}&nbsp;they are associated
 * with, or (2) would like to return a custom description for use in the Status Bar. Clients may
 * choose to implement this interface for the <i>labelProvider</i> attribute of the
 * <b>org.eclipse.wst.common.navigator.views.navigatorContent </b> extension point.
 * </p>
 * <p>
 * Clients need not implement this interface if there is no cause to do so.
 * {@see org.eclipse.jface.viewers.ILabelProvider}&nbsp;is respected by the Common Navigator.
 * <p>
 * The following class is experimental until fully documented.
 * </p>
 */
public interface ICommonLabelProvider extends ILabelProvider, IDescriptionProvider {

	/**
	 * <p>
	 * Provides the viewer id for any label provider initialization.
	 * </p>
	 * 
	 * @param aViewerId
	 *            The ID of the viewer that will be associated with the current ICommonLabelProvider
	 */
	void initialize(String aViewerId);



}