/***************************************************************************************************
 * Copyright (c) 2003, 2004 IBM Corporation and others. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: IBM Corporation - initial API and implementation
 **************************************************************************************************/
package org.eclipse.wst.common.navigator.internal.views.dnd;

import org.eclipse.core.internal.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.internal.ActionExpression;
import org.eclipse.wst.common.navigator.internal.views.NavigatorMessages;
import org.eclipse.wst.common.navigator.internal.views.NavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.dnd.SerializerCollectionDescriptor.ExtensionPointElements;

public class SerializerDescriptor {

	public final String id;

	protected final IConfigurationElement serializerElement;

	public final ActionExpression enablement;

	private ISerializer serializer;

	public SerializerDescriptor(String dropHandlerId, IConfigurationElement serializer, ActionExpression dragEnablement) {

		Assert.isNotNull(serializer, NavigatorMessages.getString("SerializerDescriptor.0")); //$NON-NLS-1$

		String localId = serializer.getAttribute(ExtensionPointElements.ATT_ID);
		Assert.isNotNull(localId, NavigatorMessages.getString("SerializerDescriptor.1")); //$NON-NLS-1$

		this.id = dropHandlerId + ":" + localId; //$NON-NLS-1$
		this.serializerElement = serializer;

		IConfigurationElement[] enablementConfigElement = this.serializerElement.getChildren(ExtensionPointElements.ENABLEMENT);

		if (enablementConfigElement.length == 0)
			this.enablement = dragEnablement;
		else if (enablementConfigElement.length == 1)
			this.enablement = new ActionExpression(enablementConfigElement[0]);
		else {
			NavigatorPlugin.log(NavigatorMessages.format("SerializerDescriptor.3", new Object[]{this.id})); //$NON-NLS-1$ 
			this.enablement = dragEnablement;
		}
	}

	public ISerializer getSerializer() {
		if (serializer == null)
			try {
				serializer = (ISerializer) serializerElement.createExecutableExtension(ExtensionPointElements.ATT_CLASS);
			} catch (CoreException e) {
				NavigatorPlugin.log(NavigatorMessages.format("SerializerDescriptor.5", new Object[]{id, e.toString()})); //$NON-NLS-1$ //$NON-NLS-2$
				serializer = null;
			}
		return serializer;
	}

}