/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.wst.rdb.data.internal.core.common;

import java.io.*;
import java.sql.*;


public class ResultSetReader {

    public static Object read(ResultSet rs, int column) throws SQLException, IOException {
        return read(rs, column, -1);
    }
    
    public static Object read(ResultSet rs, int column, int lobLimit) throws SQLException, IOException
    {

//        try {
//	        int type = rs.getMetaData().getColumnType(column+1);
	        
	        Object o = rs.getObject(column+1);
	        if (o==null)
	            return null;
	        
	        if (o instanceof Blob)
	            return readBinaryStream( ((Blob)o).getBinaryStream(), lobLimit );
	        else if (o instanceof Clob)
	            return readCharacterString( ((Clob)o).getCharacterStream(), lobLimit );
	        return o;
	        
	        
	        
	        
//	        if (type==Types.TINYINT)
//	            return new Byte(rs.getByte(column+1));
//	        else if (type==Types.SMALLINT)
//	            return new Short(rs.getShort(column+1));
//	        else if (type==Types.INTEGER)
//	            return new Integer(rs.getInt(column+1));
//	        else if (type==Types.BIGINT)
//	            return new Long(rs.getLong(column+1));
//	        else if (type==Types.REAL)
//	            return new Float(rs.getFloat(column+1));
//	        else if (type==Types.FLOAT)
//	            return new Double(rs.getDouble(column+1));
//	        else if (type==Types.DOUBLE)
//	            return new Double(rs.getDouble(column+1));
//	        else if (type==Types.DECIMAL)
//	            return rs.getBigDecimal(column+1);
//	        else if (type==Types.NUMERIC)
//	            return rs.getBigDecimal(column+1);
//	        else if (type==Types.BIT)
//	            return new Boolean(rs.getBoolean(column+1));
//	        else if (type==Types.CHAR)
//	            return rs.getString(column+1);
//	        else if (type==Types.VARCHAR)
//	            return rs.getString(column+1);
//	        else if (type==Types.LONGVARCHAR)
//	            return readCharacterString( new InputStreamReader( rs.getAsciiStream(column+1) ) );
//	        else if (type==Types.BINARY)
//	            return rs.getBytes(column+1);
//	        else if (type==Types.VARBINARY)
//	            return rs.getBytes(column+1);
//	        else if (type==Types.LONGVARBINARY)
//	            return readBinaryStream( rs.getBinaryStream(column+1) );
//	        else if (type==Types.DATE)
//	            return rs.getDate(column+1);
//	        else if (type==Types.TIME)
//	            return rs.getTime(column+1);
//	        else if (type==Types.TIMESTAMP)
//	            return rs.getTimestamp(column+1);
//	        else if (type==Types.CLOB)
//	            return readCharacterString( rs.getClob(column+1).getCharacterStream() );
//	        else if (type==Types.BLOB)
//	            return readBinaryStream( rs.getBlob(column+1).getBinaryStream() );
//	        else if (type==Types.ARRAY || type==Types.REF || type==Types.STRUCT
//	                || type==Types.JAVA_OBJECT || type==Types.OTHER)
//	            return rs.getString(column+1);
//	        else
//	            return rs.getString(column+1);
//        } catch (NullPointerException ex) {
//            return null;
//        }

    }

    
    protected static String readCharacterString(Reader r, int limit) throws SQLException, IOException
    {
        StringWriter w = new StringWriter();
        char[] buf = new char[256];
        int remaining = limit;
        for (int n = r.read(buf); n != -1; n = r.read(buf)) {
            w.write(buf, 0, n);
            if (limit!=-1) {
                remaining -= n;
                if (remaining<=0)
                    break;
            }
        }
        r.close();
        w.close();
        String s = w.toString();
        if (limit!=-1 && s.length()>limit)
            s = s.substring(0, limit);
        return s;
    }
    
    protected static Object readBinaryStream(InputStream is, int limit) throws SQLException, IOException
    {
        InputStream bis = new BufferedInputStream(is);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        for (int n=bis.read(); n!=-1; n=bis.read()) {
            os.write(n);
            if (limit!=-1) {
                limit--;
                if (limit<=0)
                    break;
            }
        }
        bis.close();
        byte[] bytes = os.toByteArray();
        os.close();
        return bytes;
    }
    
}
