/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.connection.internal.ui.wizards;

import org.eclipse.wst.rdb.connection.internal.ui.util.resource.ResourceLoader;

/**
 * Represents a DB2 alias (for a database).
 */
public class NewCWAliasObject implements Comparable
{
	/**
	 * The alias.  This must be unique within the context of
	 * of this object's parent.
	 */
	protected String _name;
	/**
	 * The comment.
	 */
	protected String _comment;
	/**
	 * The host name of the machine where the database is.
	 * A URL for the AS/400 toolbox driver wants this value
	 * instead of the alias name.
	 */
	protected String _hostname;
	
	/**
	 * Creates an AliasObject with the specified name.  If the name is <b>null</b>
	 * we generate a name. We also give "" as the hostname.
	 *
	 * @param     name The name of this object.
	 */
	public NewCWAliasObject(String name, String comment)
	{
		this(name, comment, ""); //$NON-NLS-1$
	}
	/**
	 * Creates an AliasObject with the specified name.  If the name is <b>null</b>
	 * we generate a name.
	 *
	 * @param name The alias.
	 * @param comment The remarks on the alias.
	 */
	public NewCWAliasObject(String name, String comment, String hostname)
	{
		_name = (name == null) ? ResourceLoader.INSTANCE.queryString("DEFAULT_ALIAS_NAME_UI_") : name; //$NON-NLS-1$
		_comment = (comment == null) ? "" : comment; //$NON-NLS-1$
		_hostname = (hostname == null) ? "" : hostname; //$NON-NLS-1$
	}
	
	/**
	 * Returns a string describing this object (its name):
	 */
	public String toString()
	{
		return _name;
	}
	
	/**
	 * Sets the alias.
	 * @param value, a new name for this object.
	 */
	public void setName(String value) { _name = value; }
	
	/**
	 * Sets the comment.
	 * @param value, a new comment for this object.
	 */
	public void setComment(String value) { _comment = value; }
	
	/**
	 * Sets the hostname.
	 * @param value, a new hostname for this object.
	 */
	public void setHostname(String value) { _hostname = value; }
	
	/**
	 * Gets this alias.
	 *
	 * @return This alias.
	 */
	public String getName() { return _name; }
	
	/**
	 * Gets the comment.
	 *
	 * @return The comment.
	 */
	public String getComment() { return _comment; }
	
	/**
	 * Gets the hostname where the database is.
	 *
	 * @return The hostname.
	 */
	public String getHostname() { return _hostname; }

	/**
	 * Compares this object with the specified object for order.  Returns a
	 * negative integer, zero, or a positive integer as this object is less
	 * than, equal to, or greater than the specified object.<p>
	 *
	 * @param   o the Object to be compared.
	 * @return  a negative integer, zero, or a positive integer as this object
	 *      is less than, equal to, or greater than the specified object.
	 *
	 * @throws ClassCastException if the specified object's type prevents it
	 *         from being compared to this Object.
	 */
	public int compareTo(Object o)
   {
      if (o instanceof NewCWAliasObject)
      {
         return getName().compareTo(((NewCWAliasObject)o).getName());
      }
      return 0;
   }
}

