/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.wst.rdb.internal.models.sql.schema.Dependency;
import org.eclipse.wst.rdb.server.internal.ui.services.IServicesManager;


/**
 * @author ljulien
 */
public class DependencyNavigation extends AbstractAction
{
    private ISelection selection;

    /**
     * @see org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup.AbstractAction#setSelection(org.eclipse.jface.viewers.ISelection)
     */
    protected void setSelection(ISelection selection)
    {
        this.selection = selection;
    }

    /**
     * @see org.eclipse.wst.rdb.server.internal.ui.explorer.actions.popup.AbstractAction#getSelection()
     */
    protected ISelection getSelection()
    {
        return this.selection;
    }

    /**
     * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
     */
    public void run(IAction action)
    {
        Dependency dependency = (Dependency) ((IStructuredSelection) selection).getFirstElement();
        IServicesManager.INSTANCE.getServerExplorerContentService().expandNode(dependency.getTargetEnd());
        IServicesManager.INSTANCE.getServerExplorerContentService().selectAndReveal(new StructuredSelection(dependency.getTargetEnd()));
    }
}
