/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.server.internal.ui.explorer.providers.label;

import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.common.navigator.internal.provisional.views.ICommonLabelProvider;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IVirtualNode;
import org.eclipse.wst.rdb.core.internal.ui.services.IDataToolsUIServiceManager;
import org.eclipse.wst.rdb.internal.models.sql.schema.Dependency;
import org.eclipse.wst.rdb.server.internal.ui.util.resources.ResourceLoader;


/**
 * @author ljulien
 */
public class ServerExplorerLabelProvider extends LabelProvider implements ICommonLabelProvider
{
	private static final ResourceLoader resourceLoader = ResourceLoader.INSTANCE;
	private static final IDataToolsUIServiceManager imageService = IDataToolsUIServiceManager.INSTANCE;
	private static final String EXTERNAL_DEPENDENCY = resourceLoader.queryString("DATATOOLS.SERVER.UI.EXPLORER.EXTERNAL_DEPENDENCY");

	/**
     * @return the Image associated with this element
     */
    public Image getImage(Object element)
    {
        return imageService.getLabelService(element).getIcon();
    }

    /**
     * @return the Text associated with this element
     */
    public String getText(Object element)
    {
		if (element instanceof IVirtualNode)
		{
			return ((IVirtualNode) element).getDisplayName();
		}
		else if (element instanceof Dependency)
		{
		    return EXTERNAL_DEPENDENCY;
		}
		else if (element instanceof ENamedElement)
		{
		    return ((ENamedElement)element).getName();
		}
		else 
		{
		    return super.getText(element);
		}
    }

	public void initialize(String aViewerId) {
		// TODO Auto-generated method stub
		
	}

	public String getDescription(Object selection) {
        return IDataToolsUIServiceManager.INSTANCE.getLabelService(selection).getName();
	}
}
