/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.wst.rdb.fe.internal.ui.wizards;

import java.util.Vector;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.wst.rdb.fe.internal.ui.util.ResourceLoader;
import org.eclipse.wst.rdb.internal.core.rte.EngineeringOption;
import org.eclipse.wst.rdb.internal.core.rte.EngineeringOptionCategoryID;


public class FESelectOptionsWizardPage extends WizardPage {
    private static final String GENERATE_NO_MNEMONIC_LABEL_TEXT = ResourceLoader.INSTANCE
            .queryString("GENERATE_NO_MNEMONIC_LABEL_TEXT"); //$NON-NLS-1$

    private static final String FE_SELECT_OPTIONS_PAGE_HEADER_SUBTITLE = ResourceLoader.INSTANCE
            .queryString("FE_SELECT_OPTIONS_PAGE_HEADER_SUBTITLE"); //$NON-NLS-1$
    private static final String FE_SELECT_OPTIONS_PAGE_HEADER_TITLE = ResourceLoader.INSTANCE
    .queryString("FE_SELECT_OPTIONS_PAGE_HEADER_TITLE"); //$NON-NLS-1$

    private Label m_label;
    private FEConfigurationData configurationData;
    private FEConfigurationData filteredConfigurationData = new FEConfigurationData(new EngineeringOption[0]);

    public FESelectOptionsWizardPage(String pageName, FEConfigurationData configurationData) {
        super(pageName); 
        this.configurationData = configurationData;
        setTitle(FE_SELECT_OPTIONS_PAGE_HEADER_TITLE);
        setDescription(FE_SELECT_OPTIONS_PAGE_HEADER_SUBTITLE);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
     */
    public void createControl(Composite parent) {

        Composite composite = new Composite(parent, SWT.NULL);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout(layout);
        composite.setLayoutData(new GridData(GridData.FILL_BOTH));

        WorkbenchHelp.setHelp(composite, "org.eclipse.wst.rdb.fe.ui.infopop.genddl_wiz_options");
    	
        m_label = new Label(composite, SWT.NONE);
        GridData generateData = new GridData();
        generateData.horizontalSpan = 2;
        m_label.setLayoutData(generateData);
        m_label.setText(GENERATE_NO_MNEMONIC_LABEL_TEXT);

        Composite composite1 = new Composite(composite, SWT.NONE);
        composite1.setLayout(new GridLayout());
        composite1.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
        Composite composite2 = new Composite(composite, SWT.NONE);
        composite2.setLayout(new GridLayout());
        composite2.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));

        		EngineeringOption [] options = configurationData.getOptions();
        		Vector filteredOptions = new Vector();
        		for (int index = 0; index < options.length; index++){
        			if (options[index].getCategory().getId().equals(EngineeringOptionCategoryID.GENERATE_OPTIONS)){
        				filteredOptions.add(options[index]);
        			}
        		}
        		EngineeringOption[] filteredOptionsArray = new EngineeringOption[filteredOptions.size()];
        		filteredOptions.copyInto(filteredOptionsArray);
        		filteredConfigurationData =  new FEConfigurationData(filteredOptionsArray);
        		
        		for (int i = 0; i < filteredOptionsArray.length / 2; i++)
        		{	
        			addButton (composite1, filteredOptionsArray[i]);
        		}
        		for (int i = filteredOptionsArray.length / 2; i < filteredOptionsArray.length; i++)
        		{
        			addButton (composite2, filteredOptionsArray[i]);
        		}
        this.setControl(composite);
        setPageComplete(true);
    }

    /**
     * @param composite
     * @param option
     */
    private void addButton(Composite composite, EngineeringOption option) {
        final Button button = new Button(composite, SWT.CHECK);
        button.setText(option.getOptionName());
        button.setData(option);
        button.setSelection(option.getBoolean());
        button.addSelectionListener(new SelectionListener() {
            public void widgetSelected(SelectionEvent e) {
                ((EngineeringOption) button.getData()).setBoolean(button
                        .getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }
    
    public FEConfigurationData getOptions(){
        return this.filteredConfigurationData;
    }
}