/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - Initial API and implementation
 *******************************************************************************/
package org.eclipse.jst.server.geronimo.core.internal;

import java.net.URL;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.generic.core.internal.GenericServer;
import org.eclipse.jst.server.generic.core.internal.Trace;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.internal.ServerMonitorManager;

public class GeronimoServer extends GenericServer {

	public URL getModuleRootURL(IModule module) {
		try {			
            if (module == null || module.loadAdapter(IWebModule.class, null)==null )
				return null;

			String url = "http://localhost";
			int port = 0;
			
			port = getHttpPort();
			port =ServerMonitorManager.getInstance().getMonitoredPort(getServer(), port, "web");
			if (port != 80)
				url += ":" + port;

			String moduleId=GeronimoUtils.getContextRoot(module);
			if (!moduleId.startsWith("/"))
				url += "/";
			url += moduleId;

			if (!url.endsWith("/"))
				url += "/";

			return new URL(url);
		} catch (Exception e) {
			Trace.trace("Could not get root URL", e);
			return null;
		}

	}
}