/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.tomcat.core.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.tomcat.core.internal.FileUtil;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatServerBehaviour;
import org.eclipse.jst.server.tomcat.core.internal.ITomcatVersionHandler;
import org.eclipse.jst.server.tomcat.core.internal.Messages;
import org.eclipse.jst.server.tomcat.core.internal.PingThread;
import org.eclipse.jst.server.tomcat.core.internal.ProgressUtil;
import org.eclipse.jst.server.tomcat.core.internal.TomcatConfiguration;
import org.eclipse.jst.server.tomcat.core.internal.TomcatRuntime;
import org.eclipse.jst.server.tomcat.core.internal.TomcatServer;
import org.eclipse.jst.server.tomcat.core.internal.Trace;
import org.eclipse.jst.server.tomcat.core.internal.WebModule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.eclipse.wst.server.core.util.SocketUtil;

public class TomcatServerBehaviour
extends ServerBehaviourDelegate
implements ITomcatServerBehaviour {
    private static final String ATTR_STOP = "stop-server";
    protected transient PingThread ping = null;
    protected transient IProcess process;
    protected transient IDebugEventSetListener processListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void initialize(IProgressMonitor monitor) {
    }

    public TomcatRuntime getTomcatRuntime() {
        if (this.getServer().getRuntime() == null) {
            return null;
        }
        IRuntime iRuntime = this.getServer().getRuntime();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.server.tomcat.core.internal.TomcatRuntime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (TomcatRuntime)iRuntime.loadAdapter((Class)clazz, null);
    }

    public ITomcatVersionHandler getTomcatVersionHandler() {
        if (this.getServer().getRuntime() == null || this.getTomcatRuntime() == null) {
            return null;
        }
        return this.getTomcatRuntime().getVersionHandler();
    }

    public TomcatConfiguration getTomcatConfiguration() throws CoreException {
        return this.getTomcatServer().getTomcatConfiguration();
    }

    public TomcatServer getTomcatServer() {
        IServer iServer = this.getServer();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jst.server.tomcat.core.internal.TomcatServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (TomcatServer)iServer.getAdapter((Class)clazz);
    }

    public String getRuntimeClass() {
        return this.getTomcatVersionHandler().getRuntimeClass();
    }

    public IPath getRuntimeBaseDirectory() {
        return this.getTomcatVersionHandler().getRuntimeBaseDirectory(this);
    }

    protected String[] getRuntimeProgramArguments(boolean starting) {
        IPath configPath = null;
        if (this.getTomcatServer().isTestEnvironment()) {
            configPath = this.getTempDirectory();
        }
        return this.getTomcatVersionHandler().getRuntimeProgramArguments(configPath, this.getTomcatServer().isDebug(), starting);
    }

    protected String[] getRuntimeVMArguments() {
        IPath installPath = this.getServer().getRuntime().getLocation();
        IPath configPath = null;
        configPath = this.getTomcatServer().isTestEnvironment() ? this.getTempDirectory() : installPath;
        return this.getTomcatVersionHandler().getRuntimeVMArguments(installPath, configPath, this.getTomcatServer().isTestEnvironment(), this.getTomcatServer().isSecure());
    }

    protected static String renderCommandLine(String[] commandLine, String separator) {
        if (commandLine == null || commandLine.length < 1) {
            return "";
        }
        StringBuffer buf = new StringBuffer(commandLine[0]);
        int i = 1;
        while (i < commandLine.length) {
            buf.append(separator);
            buf.append(commandLine[i]);
            ++i;
        }
        return buf.toString();
    }

    public void setProcess(IProcess newProcess) {
        if (this.process != null) {
            return;
        }
        this.process = newProcess;
        if (this.processListener != null) {
            DebugPlugin.getDefault().removeDebugEventListener(this.processListener);
        }
        if (newProcess == null) {
            return;
        }
        this.processListener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                if (events != null) {
                    int size = events.length;
                    int i = 0;
                    while (i < size) {
                        if (TomcatServerBehaviour.this.process != null && TomcatServerBehaviour.this.process.equals(events[i].getSource()) && events[i].getKind() == 8) {
                            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                            TomcatServerBehaviour.this.stopImpl();
                        }
                        ++i;
                    }
                }
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(this.processListener);
    }

    protected void setServerStarted() {
        this.setServerState(2);
    }

    protected void stopImpl() {
        if (this.ping != null) {
            this.ping.stop();
            this.ping = null;
        }
        if (this.process != null) {
            this.process = null;
            DebugPlugin.getDefault().removeDebugEventListener(this.processListener);
            this.processListener = null;
        }
        this.setServerState(4);
    }

    protected void publishServer(int kind, IProgressMonitor monitor) throws CoreException {
        IStatus status;
        IPath installDir = this.getServer().getRuntime().getLocation();
        IPath confDir = null;
        if (this.getTomcatServer().isTestEnvironment()) {
            confDir = this.getTempDirectory();
            status = this.getTomcatConfiguration().prepareRuntimeDirectory(confDir);
            if (status != null && !status.isOK()) {
                throw new CoreException(status);
            }
        } else {
            confDir = installDir;
        }
        monitor = ProgressUtil.getMonitorFor(monitor);
        monitor.beginTask(Messages.publishServerTask, 500);
        status = this.getTomcatConfiguration().cleanupServer(confDir, installDir, ProgressUtil.getSubMonitorFor(monitor, 100));
        if (status != null && !status.isOK()) {
            throw new CoreException(status);
        }
        status = this.getTomcatConfiguration().backupAndPublish(confDir, !this.getTomcatServer().isTestEnvironment(), ProgressUtil.getSubMonitorFor(monitor, 400));
        if (status != null && !status.isOK()) {
            throw new CoreException(status);
        }
        monitor.done();
        this.setServerPublishState(1);
    }

    protected void publishModule(int kind, int deltaKind, IModule[] moduleTree, IProgressMonitor monitor) throws CoreException {
        if (this.getServer().getServerState() != 4 && (deltaKind == 1 || deltaKind == 3)) {
            this.setServerRestartState(true);
        }
        if (this.getTomcatServer().isTestEnvironment()) {
            return;
        }
        IPath path = this.getTempDirectory().append("publish.txt");
        Properties p = new Properties();
        try {
            p.load(new FileInputStream(path.toFile()));
        }
        catch (Exception exception) {}
        IModule module = moduleTree[0];
        if (deltaKind == 3) {
            try {
                String publishPath = (String)p.get(module.getId());
                FileUtil.deleteDirectory(new File(publishPath), monitor);
            }
            catch (Exception e) {
                throw new CoreException((IStatus)new Status(2, "org.eclipse.jst.server.tomcat.core", 0, "Could not remove module", (Throwable)e));
            }
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jst.server.core.IWebModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IWebModule webModule = (IWebModule)module.loadAdapter((Class)clazz, null);
        IPath from = webModule.getLocation();
        IPath to = this.getServer().getRuntime().getLocation().append("webapps").append(webModule.getContextRoot());
        FileUtil.smartCopyDirectory(from.toOSString(), to.toOSString(), monitor);
        p.put(module.getId(), to.toOSString());
        this.setModulePublishState(moduleTree, 1);
        try {
            p.store(new FileOutputStream(path.toFile()), "Tomcat publish data");
        }
        catch (Exception exception) {}
    }

    public void setupLaunch(ILaunch launch, String launchMode, IProgressMonitor monitor) throws CoreException {
        if ("true".equals(launch.getLaunchConfiguration().getAttribute(ATTR_STOP, "false"))) {
            return;
        }
        IStatus status = this.getTomcatRuntime().validate();
        if (status != null && status.getSeverity() == 4) {
            throw new CoreException(status);
        }
        TomcatConfiguration configuration = this.getTomcatConfiguration();
        Iterator iterator = configuration.getServerPorts().iterator();
        ArrayList<ServerPort> usedPorts = new ArrayList<ServerPort>();
        while (iterator.hasNext()) {
            ServerPort sp = (ServerPort)iterator.next();
            if (sp.getPort() < 0) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, Messages.errorPortInvalid, null));
            }
            if (!SocketUtil.isPortInUse((int)sp.getPort(), (int)5)) continue;
            usedPorts.add(sp);
        }
        if (usedPorts.size() == 1) {
            ServerPort port = (ServerPort)usedPorts.get(0);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorPortInUse, (Object[])new String[]{String.valueOf(port.getPort()), this.getServer().getName()}), null));
        }
        if (usedPorts.size() > 1) {
            String portStr = "";
            iterator = usedPorts.iterator();
            boolean first = true;
            while (iterator.hasNext()) {
                if (!first) {
                    portStr = String.valueOf(portStr) + ", ";
                }
                first = false;
                ServerPort sp = (ServerPort)iterator.next();
                portStr = String.valueOf(portStr) + sp.getPort();
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorPortsInUse, (Object[])new String[]{portStr, this.getServer().getName()}), null));
        }
        iterator = configuration.getWebModules().iterator();
        ArrayList<String> contextRoots = new ArrayList<String>();
        while (iterator.hasNext()) {
            WebModule module = (WebModule)iterator.next();
            String contextRoot = module.getPath();
            if (contextRoots.contains(contextRoot)) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.tomcat.core", 0, NLS.bind((String)Messages.errorDuplicateContextRoot, (Object[])new String[]{contextRoot}), null));
            }
            contextRoots.add(contextRoot);
        }
        this.setServerRestartState(false);
        this.setServerState(1);
        this.setMode(launchMode);
        try {
            String url = "http://localhost";
            int port = configuration.getMainPort().getPort();
            if (port != 80) {
                url = String.valueOf(url) + ":" + port;
            }
            this.ping = new PingThread(this.getServer(), url, 50, this);
        }
        catch (Exception exception) {
            Trace.trace(Trace.SEVERE, "Can't ping for Tomcat startup.");
        }
    }

    public void stop(boolean force) {
        if (force) {
            this.terminate();
            return;
        }
        int state = this.getServer().getServerState();
        if (state == 4) {
            return;
        }
        if (state == 1 || state == 3) {
            this.terminate();
            return;
        }
        try {
            Trace.trace(Trace.FINER, "Stopping Tomcat");
            if (state != 4) {
                this.setServerState(3);
            }
            ILaunchConfiguration launchConfig = ((Server)this.getServer()).getLaunchConfiguration(true, null);
            ILaunchConfigurationWorkingCopy wc = launchConfig.getWorkingCopy();
            String args = TomcatServerBehaviour.renderCommandLine(this.getRuntimeProgramArguments(false), " ");
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, args);
            wc.setAttribute(ATTR_STOP, "true");
            wc.launch("run", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error stopping Tomcat", e);
        }
    }

    protected void terminate() {
        if (this.getServer().getServerState() == 4) {
            return;
        }
        try {
            this.setServerState(3);
            Trace.trace(Trace.FINER, "Killing the Tomcat process");
            if (this.process != null && !this.process.isTerminated()) {
                this.process.terminate();
                this.stopImpl();
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error killing the process", e);
        }
    }

    public IPath getTempDirectory() {
        return super.getTempDirectory();
    }

    public String toString() {
        return "TomcatServer";
    }

    protected static int getNextToken(String s, int start) {
        int i = start;
        int length = s.length();
        int lookFor = 32;
        while (i < length) {
            int c = s.charAt(i);
            if (lookFor == c) {
                if (lookFor == 34) {
                    return i + 1;
                }
                return i;
            }
            if (c == 34) {
                lookFor = 34;
            }
            ++i;
        }
        return -1;
    }

    public static String mergeArguments(String originalArg, String[] vmArgs) {
        if (vmArgs == null) {
            return originalArg;
        }
        if (originalArg == null) {
            originalArg = "";
        }
        int size = vmArgs.length;
        int i = 0;
        while (i < size) {
            int index2;
            String s;
            int index;
            int ind = vmArgs[i].indexOf(" ");
            int ind2 = vmArgs[i].indexOf("=");
            if (ind >= 0 && (ind2 == -1 || ind < ind2)) {
                index = originalArg.indexOf(vmArgs[i].substring(0, ind + 1));
                if (index == 0 || index > 0 && originalArg.charAt(index - 1) == ' ') {
                    s = originalArg.substring(0, index);
                    index2 = TomcatServerBehaviour.getNextToken(originalArg, index + ind + 1);
                    originalArg = index2 >= 0 ? String.valueOf(s) + vmArgs[i] + originalArg.substring(index2) : String.valueOf(s) + vmArgs[i];
                    vmArgs[i] = null;
                }
            } else if (ind2 >= 0) {
                index = originalArg.indexOf(vmArgs[i].substring(0, ind2 + 1));
                if (index == 0 || index > 0 && originalArg.charAt(index - 1) == ' ') {
                    s = originalArg.substring(0, index);
                    index2 = TomcatServerBehaviour.getNextToken(originalArg, index);
                    originalArg = index2 >= 0 ? String.valueOf(s) + vmArgs[i] + originalArg.substring(index2) : String.valueOf(s) + vmArgs[i];
                    vmArgs[i] = null;
                }
            } else {
                index = originalArg.indexOf(vmArgs[i]);
                if (index == 0 || index > 0 && originalArg.charAt(index - 1) == ' ') {
                    s = originalArg.substring(0, index);
                    index2 = TomcatServerBehaviour.getNextToken(originalArg, index);
                    originalArg = index2 >= 0 ? String.valueOf(s) + vmArgs[i] + originalArg.substring(index2) : String.valueOf(s) + vmArgs[i];
                    vmArgs[i] = null;
                }
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            if (vmArgs[i] != null) {
                if (originalArg.length() > 0 && !originalArg.endsWith(" ")) {
                    originalArg = String.valueOf(originalArg) + " ";
                }
                originalArg = String.valueOf(originalArg) + vmArgs[i];
            }
            ++i;
        }
        return originalArg;
    }

    public static void replaceJREContainer(List cp, IRuntimeClasspathEntry entry) {
        int size = cp.size();
        int i = 0;
        while (i < size) {
            IRuntimeClasspathEntry entry2 = (IRuntimeClasspathEntry)cp.get(i);
            if (entry2.getPath().uptoSegment(2).isPrefixOf(entry.getPath())) {
                cp.set(i, entry);
                return;
            }
            ++i;
        }
        cp.add(0, entry);
    }

    public static void mergeClasspath(List cp, IRuntimeClasspathEntry entry) {
        Iterator iterator = cp.iterator();
        while (iterator.hasNext()) {
            IRuntimeClasspathEntry entry2 = (IRuntimeClasspathEntry)iterator.next();
            if (!entry2.getPath().equals((Object)entry.getPath())) continue;
            return;
        }
        cp.add(entry);
    }

    public void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IProgressMonitor monitor) throws CoreException {
        String existingProgArgs = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, null);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, TomcatServerBehaviour.mergeArguments(existingProgArgs, this.getRuntimeProgramArguments(true)));
        String existingVMArgs = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, null);
        if (existingVMArgs != null && !this.getTomcatServer().isSecure()) {
            int index2;
            int index = existingVMArgs.indexOf("-Djava.security.manager");
            if (index >= 0) {
                if (index > 0 && existingVMArgs.charAt(index - 1) == ' ') {
                    --index;
                }
                index2 = existingVMArgs.indexOf(" ", index + 2);
                existingVMArgs = String.valueOf(existingVMArgs.substring(0, index)) + existingVMArgs.substring(index2);
            }
            if ((index = existingVMArgs.indexOf("-Djava.security.policy=")) >= 0) {
                if (index > 0 && existingVMArgs.charAt(index - 1) == ' ') {
                    --index;
                }
                index2 = existingVMArgs.indexOf("\"", index);
                index2 = existingVMArgs.indexOf("\"", index2 + 1);
                existingVMArgs = String.valueOf(existingVMArgs.substring(0, index)) + existingVMArgs.substring(index2 + 1);
            }
        }
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, TomcatServerBehaviour.mergeArguments(existingVMArgs, this.getRuntimeVMArguments()));
        TomcatRuntime runtime = this.getTomcatRuntime();
        IVMInstall vmInstall = runtime.getVMInstall();
        if (vmInstall != null) {
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, vmInstall.getVMInstallType().getId());
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, vmInstall.getName());
        }
        IRuntimeClasspathEntry[] originalClasspath = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)workingCopy);
        int size = originalClasspath.length;
        ArrayList<IRuntimeClasspathEntry> oldCp = new ArrayList<IRuntimeClasspathEntry>(originalClasspath.length + 2);
        int i = 0;
        while (i < size) {
            oldCp.add(originalClasspath[i]);
            ++i;
        }
        List cp2 = runtime.getRuntimeClasspath();
        Iterator iterator = cp2.iterator();
        while (iterator.hasNext()) {
            IRuntimeClasspathEntry entry = (IRuntimeClasspathEntry)iterator.next();
            TomcatServerBehaviour.mergeClasspath(oldCp, entry);
        }
        if (vmInstall != null) {
            IPath toolsPath;
            try {
                String typeId = vmInstall.getVMInstallType().getId();
                TomcatServerBehaviour.replaceJREContainer(oldCp, JavaRuntime.newRuntimeContainerClasspathEntry((IPath)new Path(JavaRuntime.JRE_CONTAINER).append(typeId).append(vmInstall.getName()), (int)2));
            }
            catch (Exception exception) {}
            Path jrePath = new Path(vmInstall.getInstallLocation().getAbsolutePath());
            if (jrePath != null && (toolsPath = jrePath.append("lib").append("tools.jar")).toFile().exists()) {
                TomcatServerBehaviour.mergeClasspath(oldCp, JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)toolsPath));
            }
        }
        iterator = oldCp.iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (iterator.hasNext()) {
            IRuntimeClasspathEntry entry = (IRuntimeClasspathEntry)iterator.next();
            try {
                list.add(entry.getMemento());
            }
            catch (Exception e) {
                Trace.trace(Trace.SEVERE, "Could not resolve classpath entry: " + entry, e);
            }
        }
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, list);
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
    }

    protected IModuleResourceDelta[] getPublishedResourceDelta(IModule[] module) {
        return super.getPublishedResourceDelta(module);
    }

    public void handleResourceChange() {
        if (this.getServer().getServerRestartState()) {
            return;
        }
        Iterator iterator = this.getAllModules().iterator();
        while (iterator.hasNext()) {
            IModule[] module = (IModule[])iterator.next();
            IModuleResourceDelta[] delta = this.getPublishedResourceDelta(module);
            if (delta == null || delta.length == 0 || !this.containsNonResourceChange(delta)) continue;
            this.setServerRestartState(true);
            return;
        }
    }

    protected boolean containsNonResourceChange(IModuleResourceDelta[] delta) {
        int size = delta.length;
        int i = 0;
        while (i < size) {
            IModuleResourceDelta d = delta[i];
            if ("WEB-INF".equals(d.getModuleResource().getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

