/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.data.internal.core.editor;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.rdb.data.internal.core.DataCorePlugin;
import org.eclipse.wst.rdb.data.internal.core.common.ResultSetReader;
import org.eclipse.wst.rdb.data.internal.core.editor.IRowData;
import org.eclipse.wst.rdb.data.internal.core.editor.ITableData;
import org.eclipse.wst.rdb.data.internal.core.editor.Messages;
import org.eclipse.wst.rdb.data.internal.core.editor.RowDataImpl;
import org.eclipse.wst.rdb.data.internal.core.editor.TableDataSaveStatus;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.models.sql.constraints.TableConstraint;
import org.eclipse.wst.rdb.internal.models.sql.constraints.UniqueConstraint;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.DataType;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.PredefinedDataType;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.eclipse.wst.rdb.internal.models.sql.tables.BaseTable;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;
import org.eclipse.wst.rdb.internal.outputview.OutputItem;
import org.eclipse.wst.rdb.internal.outputview.OutputViewAPI;

public class TableDataImpl
implements ITableData {
    protected Table sqlTable;
    protected Connection con;
    protected Vector rows = new Vector();
    protected int[] colTtypes;
    protected String[] colNames;
    protected int[] key = null;
    protected boolean readonly;

    public TableDataImpl(Table sqlTable) throws SQLException, IOException {
        this.sqlTable = sqlTable;
        this.con = ((ICatalogObject)sqlTable).getConnection();
        if (sqlTable instanceof BaseTable) {
            this.findKey((BaseTable)sqlTable);
            this.readonly = false;
        } else {
            this.readonly = true;
        }
        Statement stmt = this.con.createStatement();
        boolean setLimit = RDBCorePlugin.getDefault().getPluginPreferences().getBoolean("OUTPUT_PREFERENCE_LIMIT_ROWS_RETRIEVED");
        if (setLimit) {
            int integer = RDBCorePlugin.getDefault().getPluginPreferences().getInt("OUTPUT_PREFERENCE_MAX_ROW_RETRIEVED");
            stmt.setMaxRows(integer);
        } else {
            stmt.setMaxRows(0);
        }
        ResultSet rs = stmt.executeQuery("SELECT * FROM " + this.getQualifiedTableName());
        ResultSetMetaData rsmd = rs.getMetaData();
        int cc = rsmd.getColumnCount();
        this.colTtypes = new int[cc];
        this.colNames = new String[cc];
        int i = 0;
        while (i < cc) {
            this.colTtypes[i] = rsmd.getColumnType(i + 1);
            this.colNames[i] = rsmd.getColumnName(i + 1);
            ++i;
        }
        int lobLimit = RDBCorePlugin.getDefault().getPluginPreferences().getInt("OUTPUT_PREFERENCE_MAX_LOB_LENGTH");
        if (lobLimit <= 0) {
            lobLimit = -1;
        }
        while (rs.next()) {
            Object[] a = new Object[cc];
            int col = 0;
            while (col < cc) {
                a[col] = ResultSetReader.read(rs, col, lobLimit);
                ++col;
            }
            RowDataImpl row = new RowDataImpl(this, 0, a);
            this.rows.add(row);
        }
        rs.close();
        stmt.close();
    }

    protected void findKey(BaseTable baseTable) {
        EList cols;
        EList constraints = baseTable.getConstraints();
        UniqueConstraint chosenConstr = null;
        Iterator it = constraints.iterator();
        while (it.hasNext()) {
            TableConstraint constr = (TableConstraint)it.next();
            if (!(constr instanceof UniqueConstraint)) continue;
            UniqueConstraint uniqueConstr = (UniqueConstraint)constr;
            if (chosenConstr != null && uniqueConstr.getMembers().size() >= chosenConstr.getMembers().size()) continue;
            chosenConstr = uniqueConstr;
        }
        if (chosenConstr == null) {
            cols = this.sqlTable.getColumns();
            this.key = new int[cols.size()];
            int i = 0;
            while (i < cols.size()) {
                this.key[i] = i;
                ++i;
            }
        } else {
            cols = chosenConstr.getMembers();
            this.key = new int[cols.size()];
            int i = 0;
            while (i < cols.size()) {
                Column col = (Column)cols.get(i);
                this.key[i] = col.getTable().getColumns().indexOf((Object)col);
                ++i;
            }
        }
    }

    public void dispose() {
    }

    public int getColumnCount() {
        return this.sqlTable.getColumns().size();
    }

    public String getColumnHeader(int col) {
        Column sqlCol = (Column)this.sqlTable.getColumns().get(col);
        return String.valueOf(sqlCol.getName()) + " [" + TableDataImpl.getFormattedTypeName(sqlCol) + "]";
    }

    protected static String getFormattedTypeName(Column sqlCol) {
        Table table = sqlCol.getTable();
        Schema schema = table.getSchema();
        Database db = schema.getDatabase();
        DatabaseDefinition dbDef = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(db);
        DataType dt = sqlCol.getDataType();
        if (dt != null) {
            if (dt instanceof PredefinedDataType) {
                return dbDef.getPredefinedDataTypeFormattedName((PredefinedDataType)dt);
            }
            return dt.getName();
        }
        return "";
    }

    public String getColumnName(int col) {
        Column sqlCol = (Column)this.sqlTable.getColumns().get(col);
        return sqlCol.getName();
    }

    public String getQuotedColumnName(int col) {
        return DataCorePlugin.quoteIdentifier((SQLObject)this.sqlTable, this.getColumnName(col));
    }

    public int getColumnType(int col) {
        return this.colTtypes[col];
    }

    public Vector getRows() {
        Vector<RowDataImpl> v = new Vector<RowDataImpl>();
        Iterator it = this.rows.iterator();
        while (it.hasNext()) {
            RowDataImpl row = (RowDataImpl)it.next();
            if (row.getState() == 2) continue;
            v.add(row);
        }
        return v;
    }

    public int[] getKeyColumns() {
        return this.key;
    }

    public Connection getConnection() {
        return this.con;
    }

    public boolean save() throws SQLException {
        boolean res;
        boolean autocomit = this.con.getAutoCommit();
        this.con.setAutoCommit(false);
        this.con.commit();
        Exception resEx = null;
        TableDataSaveStatus status = new TableDataSaveStatus();
        try {
            Iterator it = this.rows.iterator();
            while (it.hasNext()) {
                RowDataImpl row = (RowDataImpl)it.next();
                row.save(status);
            }
            this.con.commit();
            this.con.setAutoCommit(autocomit);
            res = true;
        }
        catch (Exception ex) {
            this.con.rollback();
            this.con.setAutoCommit(autocomit);
            res = false;
            resEx = ex;
            status.reset();
        }
        if (res) {
            this.resetRowsToOriginal();
        }
        this.writeOutputView(res, resEx, status);
        return res;
    }

    public void revert() {
        int i = 0;
        while (i < this.rows.size()) {
            RowDataImpl row = (RowDataImpl)this.rows.elementAt(i);
            if (row.getState() == 1 || row.getState() == 2) {
                row.revertToOriginal();
                ++i;
                continue;
            }
            if (row.getState() == 3) {
                this.rows.remove(i);
                continue;
            }
            if (row.getState() != 0) continue;
            ++i;
        }
    }

    protected void resetRowsToOriginal() {
        int i = 0;
        while (i < this.rows.size()) {
            RowDataImpl row = (RowDataImpl)this.rows.elementAt(i);
            if (row.getState() == 1 || row.getState() == 3) {
                row.resetToOriginal();
                ++i;
                continue;
            }
            if (row.getState() == 2) {
                this.rows.remove(i);
                continue;
            }
            if (row.getState() != 0) continue;
            ++i;
        }
    }

    protected void writeOutputView(boolean res, Exception resEx, TableDataSaveStatus status) {
        String endl = System.getProperty("line.separator");
        int statusCode = res ? (status.duplicateRow ? 3 : 2) : 4;
        OutputItem item = OutputViewAPI.getInstance().findOutputItem(this.getQualifiedTableName(), 31, true);
        if (item == null) {
            item = new OutputItem(statusCode, 31, this.sqlTable.getName(), this.getQualifiedTableName());
            OutputViewAPI.getInstance().addOutputItem(item, true);
        } else {
            OutputViewAPI.getInstance().resetOutputItem(item, true);
            OutputViewAPI.getInstance().updateStatus(item, statusCode, true);
        }
        if (res) {
            OutputViewAPI.getInstance().showMessage(item, Messages.getString("TableDataImpl.DataSuccessfullySaved"), true);
        } else {
            OutputViewAPI.getInstance().showMessage(item, Messages.getString("TableDataImpl.ErrorSavingData"), true);
        }
        if (resEx != null) {
            OutputViewAPI.getInstance().showMessage(item, resEx.toString(), true);
        }
        if (status.duplicateRow) {
            OutputViewAPI.getInstance().showMessage(item, Messages.getString("TableDataImpl.DuplicateRows"), true);
        }
        String msg = "";
        msg = String.valueOf(msg) + Messages.getString("TableDataImpl.Inserted") + String.valueOf(status.inserted) + Messages.getString("TableDataImpl.rows") + endl;
        msg = String.valueOf(msg) + Messages.getString("TableDataImpl.Updated") + String.valueOf(status.updated) + Messages.getString("TableDataImpl.rows") + endl;
        msg = String.valueOf(msg) + Messages.getString("TableDataImpl.Deleted") + String.valueOf(status.deleted) + Messages.getString("TableDataImpl.rows");
        OutputViewAPI.getInstance().showMessage(item, msg, true);
    }

    public void deleteRow(IRowData row) {
        if (((RowDataImpl)row).getState() == 3) {
            this.rows.remove(row);
        } else {
            ((RowDataImpl)row).setState(2);
        }
    }

    public IRowData insertRow() {
        Object[] data = new Object[this.getColumnCount()];
        RowDataImpl row = new RowDataImpl(this, 3, data);
        this.rows.add(row);
        return row;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public String getQualifiedTableName() {
        return DataCorePlugin.getQualifiedTableName(this.sqlTable);
    }
}

