/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.data.internal.core.load;

import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.wst.rdb.data.internal.core.DataCorePlugin;
import org.eclipse.wst.rdb.data.internal.core.load.DataFileTokenizer;
import org.eclipse.wst.rdb.data.internal.core.load.Messages;
import org.eclipse.wst.rdb.data.internal.core.load.TableLoader;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;
import org.eclipse.wst.rdb.internal.outputview.OutputItem;
import org.eclipse.wst.rdb.internal.outputview.OutputViewAPI;

public class LoadData {
    protected Table table;
    protected String filePath;
    protected String colDelim = ",";
    protected static final String ENDL = System.getProperty("line.separator");
    protected String stringDelim = "\"";
    protected boolean replace = true;
    protected TableLoader loader = null;

    public LoadData(Table table, String filePath) {
        this.table = table;
        this.filePath = filePath;
    }

    public void setDelims(String colDelim, String stringDelim) {
        this.colDelim = colDelim;
        this.stringDelim = stringDelim;
    }

    public void setReplace(boolean replace) {
        this.replace = replace;
    }

    public int doLoad(OutputItem item) {
        OutputViewAPI.getInstance().showMessage(item, String.valueOf(Messages.getString("LoadData.Loading")) + " " + this.getFullyQualifiedName() + "...", true);
        try {
            this.doLoad1();
        }
        catch (Exception ex) {
            DataCorePlugin.getDefault().writeLog(4, 0, ex.getMessage(), ex);
            OutputViewAPI.getInstance().showMessage(item, ex.toString(), true);
            OutputViewAPI.getInstance().showMessage(item, Messages.getString("LoadData.DataLoadingFailed"), true);
            return 4;
        }
        OutputViewAPI.getInstance().showMessage(item, Messages.getString("LoadData.DataLoadingSuccessful"), true);
        String report = "";
        String endl = System.getProperty("line.separator");
        if (this.loader.getDeletedRows() > 0) {
            report = String.valueOf(report) + String.valueOf(this.loader.getDeletedRows()) + Messages.getString("LoadData.RowsDeleted");
        }
        if (report.length() > 0) {
            report = String.valueOf(report) + endl;
        }
        report = String.valueOf(report) + String.valueOf(this.loader.getInsertedRows()) + Messages.getString("LoadData.RowsLoaded");
        if (this.loader.getFailedRows() > 0) {
            report = String.valueOf(report) + endl + String.valueOf(this.loader.getFailedRows()) + Messages.getString("LoadData.RowsFailed");
            report = String.valueOf(report) + endl + endl + this.loader.getFailedRowError();
        }
        OutputViewAPI.getInstance().showMessage(item, report, true);
        if (this.loader.getErrorColumns().size() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(Messages.getString("LoadData.ErrorSetting"));
            Iterator it = this.loader.getErrorColumns().iterator();
            while (it.hasNext()) {
                sb.append(it.next().toString());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            OutputViewAPI.getInstance().showMessage(item, sb.toString(), true);
        }
        if (this.loader.getFailedRows() > 0 || this.loader.getErrorColumns().size() > 0) {
            return 3;
        }
        return 2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doLoad1() throws Exception {
        DataFileTokenizer tokens = new DataFileTokenizer(this.filePath, String.valueOf(this.colDelim) + this.stringDelim);
        this.loader = new TableLoader(this.table);
        try {
            tokens.open();
            this.loader.open();
            if (this.replace) {
                this.loader.emptyTable();
            }
            this.parseFile(tokens);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            tokens.close();
            this.loader.close();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        tokens.close();
        this.loader.close();
    }

    protected void parseFile(DataFileTokenizer tokens) throws Exception {
        while (tokens.peek() != null) {
            Vector values = this.parseRow(tokens);
            this.loader.loadRow(values.toArray(new String[0]));
        }
    }

    protected Vector parseRow(DataFileTokenizer tokens) throws Exception {
        Vector<String> values = new Vector<String>();
        values.add(this.parseCol(tokens));
        while (tokens.peek() != null && !tokens.peek().equals(ENDL)) {
            tokens.consume(this.colDelim);
            values.add(this.parseCol(tokens));
        }
        if (tokens.peek() != null) {
            tokens.consume(ENDL);
        }
        return values;
    }

    protected String parseCol(DataFileTokenizer tokens) throws Exception {
        if (tokens.peek() == null || tokens.peek().equals(this.colDelim) || tokens.peek().equals(ENDL)) {
            return null;
        }
        return this.parseString(tokens);
    }

    protected String parseString(DataFileTokenizer tokens) throws Exception {
        if (tokens.peek().equals(this.stringDelim)) {
            return this.parseQuotedString(tokens);
        }
        return this.parseUnquotedString(tokens);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String parseQuotedString(DataFileTokenizer tokens) throws Exception {
        StringBuffer sb = new StringBuffer();
        tokens.consume(this.stringDelim);
        String token = tokens.nextToken();
        while (true) {
            if (token.equals(this.stringDelim)) {
                if (tokens.peek() == null || !tokens.peek().equals(this.stringDelim)) return sb.toString();
                sb.append(tokens.nextToken());
            } else {
                sb.append(token);
            }
            token = tokens.nextToken();
        }
    }

    protected String parseUnquotedString(DataFileTokenizer tokens) throws IOException {
        return tokens.nextToken();
    }

    protected String getFullyQualifiedName() {
        return "\"" + this.table.getSchema().getName() + "\".\"" + this.table.getName() + "\"";
    }
}

