/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.internet.cache.internal;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.wst.internet.cache.internal.LicenseRegistry;

public class LicenseRegistryTest
extends TestCase {
    private LicenseRegistry registry = LicenseRegistry.getInstance();
    static /* synthetic */ Class class$0;

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.internet.cache.internal.CacheTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testAddLicenseToRegistry() {
        String licenseURL = "http://somelicense";
        LicenseRegistry registry = new LicenseRegistry();
        registry.addLicense(licenseURL);
        LicenseRegistryTest.assertEquals((String)"The registry does not have 1 license.", (int)1, (int)registry.licenses.size());
        LicenseRegistryTest.assertTrue((String)("The registry does not conain the license " + licenseURL), (boolean)registry.licenses.containsKey(licenseURL));
        LicenseRegistryTest.assertEquals((String)"The registry does not have the correct value for the license.", (Object)LicenseRegistry.LICENSE_UNSPECIFIED, registry.licenses.get(licenseURL));
    }

    public void testAddLicenseToRegistryTwice() {
        String licenseURL = "http://somelicense";
        LicenseRegistry registry = new LicenseRegistry();
        registry.addLicense(licenseURL);
        registry.addLicense(licenseURL);
        LicenseRegistryTest.assertEquals((String)"The registry contains more than one license.", (int)1, (int)registry.licenses.size());
    }

    public void testAgreeToLicense() {
        String licenseURL = "http://somelicense";
        LicenseRegistry registry = new LicenseRegistry();
        registry.addLicense(licenseURL);
        registry.agreeLicense(licenseURL);
        LicenseRegistryTest.assertEquals((String)"The registry does not have the correct value for the license.", (Object)LicenseRegistry.LICENSE_AGREE, registry.licenses.get(licenseURL));
    }

    public void testAgreeToLicenseNotInRegistry() {
        String licenseURL = "http://somelicense";
        LicenseRegistry registry = new LicenseRegistry();
        registry.agreeLicense(licenseURL);
        LicenseRegistryTest.assertEquals((String)"The registry registered the license but it should not have.", (int)0, (int)registry.licenses.size());
    }

    public void testDisgreeToLicense() {
        String licenseURL = "http://somelicense";
        LicenseRegistry registry = new LicenseRegistry();
        registry.addLicense(licenseURL);
        registry.disagreeLicense(licenseURL);
        LicenseRegistryTest.assertEquals((String)"The registry does not have the correct value for the license.", (Object)LicenseRegistry.LICENSE_DISAGREE, registry.licenses.get(licenseURL));
    }

    public void testDisagreeToLicenseNotInRegistry() {
        String licenseURL = "http://somelicense";
        LicenseRegistry registry = new LicenseRegistry();
        registry.agreeLicense(licenseURL);
        LicenseRegistryTest.assertEquals((String)"The registry registered the license but it should not have.", (int)0, (int)registry.licenses.size());
    }

    public void testPromptForLicenseNotInRegistry() {
        String licenseURL = "http://somelicense";
        LicenseRegistry registry = new LicenseRegistry();
        LicenseRegistryTest.assertTrue((String)"The prompt for agreement method does not return true for a license not in the registry.", (boolean)registry.promptToAcceptLicense(licenseURL, licenseURL));
    }
}

