/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.model;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IModelHandler;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceInUse;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.modelhandler.ModelHandlerForXML;
import org.eclipse.wst.xml.core.internal.modelhandler.XMLModelLoader;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.core.tests.util.FileUtil;
import org.eclipse.wst.xml.core.tests.util.ProjectUnzipUtility;

public class TestStructuredModel
extends TestCase {
    private boolean isSetup = false;
    private XMLModelLoader fLoader = null;
    private final String fProjectName = "DOCUMENT-LOADER";
    private final String fZipFileName = "xml-document-loader-tests.zip";

    public TestStructuredModel() {
        super("TestStructuredModel");
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (!this.isSetup) {
            this.fLoader = new XMLModelLoader();
            this.doSetup();
            this.isSetup = true;
        }
    }

    private void doSetup() throws Exception {
        Location platformLocation = Platform.getInstanceLocation();
        ProjectUnzipUtility unzipUtil = new ProjectUnzipUtility();
        File zipFile = FileUtil.makeFileFor("projecttestfiles", "xml-document-loader-tests.zip", "projecttestfiles");
        unzipUtil.unzipAndImport(zipFile, platformLocation.getURL().getFile());
        unzipUtil.initJavaProject("DOCUMENT-LOADER");
    }

    public IStructuredModel getUnmanagedModel() {
        IFile f = this.getFile();
        IStructuredModel model = null;
        try {
            model = this.fLoader.createModel();
            this.fLoader.load(f, model);
            ModelHandlerForXML xmlModelHandler = new ModelHandlerForXML();
            model.setModelHandler((IModelHandler)xmlModelHandler);
            model.setBaseLocation("DOCUMENT-LOADER/files/simple.xml");
            try {
                model.setId("DOCUMENT-LOADER/files/simple.xml");
            }
            catch (ResourceInUse resourceInUse) {}
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return model;
    }

    private IFile getFile() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path("DOCUMENT-LOADER/files/simple.xml"));
    }

    public void testAboutToChangeModel() {
        IStructuredModel model = this.getUnmanagedModel();
        model.aboutToChangeModel();
    }

    public void testAddRemoveModelStateListener() {
        IStructuredModel model = this.getUnmanagedModel();
        IModelStateListener listener = new IModelStateListener(){

            public void modelAboutToBeChanged(IStructuredModel model) {
            }

            public void modelChanged(IStructuredModel model) {
            }

            public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
            }

            public void modelResourceDeleted(IStructuredModel model) {
            }

            public void modelResourceMoved(IStructuredModel oldModel, IStructuredModel newModel) {
            }

            public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
            }

            public void modelReinitialized(IStructuredModel structuredModel) {
            }
        };
        model.aboutToChangeModel();
        model.removeModelStateListener(listener);
    }

    public void testChangedModel() {
        IStructuredModel model = this.getUnmanagedModel();
        try {
            model.changedModel();
        }
        catch (Exception e) {
            TestStructuredModel.assertTrue((boolean)(e instanceof IllegalStateException));
        }
    }

    public void testGetContentType() {
        IStructuredModel model = this.getUnmanagedModel();
        String ct = model.getContentTypeIdentifier();
        TestStructuredModel.assertTrue((String)("model has wrong content type:" + ct + " != " + ContentTypeIdForXML.ContentTypeID_XML), (boolean)ct.equals(ContentTypeIdForXML.ContentTypeID_XML));
    }

    public void testGetBaseLocation() {
        IStructuredModel model = this.getUnmanagedModel();
        String location = model.getBaseLocation();
        TestStructuredModel.assertTrue((String)"wrong base location", (boolean)location.equals("DOCUMENT-LOADER/files/simple.xml"));
    }

    public void testGetFactoryRegistry() {
        IStructuredModel model = this.getUnmanagedModel();
        model.getFactoryRegistry();
    }

    public void testGetIndexedRegion() {
        IStructuredModel model = this.getUnmanagedModel();
        model.getIndexedRegion(0);
    }

    public void testGetIndexedRegions() {
        this.getUnmanagedModel();
    }

    public void testGetStructuredDocument() {
        IStructuredModel model = this.getUnmanagedModel();
        IStructuredDocument doc = model.getStructuredDocument();
        TestStructuredModel.assertNotNull((String)"document is null", (Object)doc);
    }

    public void testIsDirty() {
        IStructuredModel model = this.getUnmanagedModel();
        TestStructuredModel.assertFalse((String)"model should not be dirty", (boolean)model.isDirty());
    }

    public void testIsModelStateChanging() {
        IStructuredModel model = this.getUnmanagedModel();
        TestStructuredModel.assertFalse((String)"model should not be changing", (boolean)model.isModelStateChanging());
    }

    public void testIsNew() {
        this.getUnmanagedModel();
    }

    public void testIsReinitializationNeeded() {
        IStructuredModel model = this.getUnmanagedModel();
        TestStructuredModel.assertFalse((String)"reinitialization should not be needed", (boolean)model.isReinitializationNeeded());
    }

    public void testIsSaveNeeded() {
        IStructuredModel model = this.getUnmanagedModel();
        TestStructuredModel.assertFalse((String)"save should not be needed", (boolean)model.isSaveNeeded());
    }

    public void testNewInstance() {
        IStructuredModel model = this.getUnmanagedModel();
        IStructuredModel newInstance = null;
        try {
            newInstance = model.newInstance();
        }
        catch (IOException iOException) {
            TestStructuredModel.assertTrue((String)"IOException during model new instance", (boolean)false);
        }
        TestStructuredModel.assertNotNull((String)"new instance is null", (Object)newInstance);
    }
}

