/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Container;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.RARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DeploymentDescriptorLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DuplicateObjectException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ModuleFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.ConnectorDirectorySaveStrategyImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.SaveStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.RarFileDynamicClassLoader;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.internal.jca.JcaPackage;
import org.eclipse.jst.j2ee.jca.Connector;
import org.eclipse.jst.j2ee.jca.JcaFactory;

public class RARFileImpl
extends ModuleFileImpl
implements RARFile {
    protected Connector deploymentDescriptor = null;
    static /* synthetic */ Class class$0;

    protected EClass eStaticClass() {
        return CommonarchivePackage.eINSTANCE.getRARFile();
    }

    public File addCopyClass(File aFile) throws DuplicateObjectException {
        if (aFile.isReadOnlyDirectory()) {
            throw new IllegalArgumentException(CommonArchiveResourceHandler.getString("add_copy_class_dir_EXC_", new Object[]{aFile.getURI()}));
        }
        return this.addCopyFileAddingPrefix(aFile, "WEB-INF/classes/");
    }

    protected File addCopyFileAddingPrefix(File aFile, String uriPrefix) throws DuplicateObjectException {
        String swizzledUri = aFile.getURI();
        if (!swizzledUri.startsWith(uriPrefix)) {
            swizzledUri = ArchiveUtil.concatUri(uriPrefix, swizzledUri, '/');
        }
        this.checkAddValid(swizzledUri);
        File copy = this.copy(aFile);
        copy.setURI(swizzledUri);
        this.getFiles().add((Object)copy);
        return copy;
    }

    protected SaveStrategy createSaveStrategyForConnectorDirectory(java.io.File dir, int expansionFlags) {
        return new ConnectorDirectorySaveStrategyImpl(dir.getAbsolutePath(), expansionFlags);
    }

    public void extractToConnectorDirectory(String aUri, int expansionFlags) throws SaveFailureException {
        java.io.File aDir = new java.io.File(aUri);
        if (this.getLoadStrategy().isUsing(aDir)) {
            throw new SaveFailureException(CommonArchiveResourceHandler.getString("Extract_destination_is_the_EXC_"));
        }
        try {
            SaveStrategy aSaveStrategy = this.createSaveStrategyForConnectorDirectory(aDir, expansionFlags);
            this.save(aSaveStrategy);
            aSaveStrategy.close();
        }
        catch (IOException ex) {
            throw new SaveFailureException(CommonArchiveResourceHandler.getString("error_saving_EXC_", new Object[]{this.uri}), ex);
        }
    }

    public List getClasses() {
        return this.filterFilesByPrefix("com");
    }

    public Connector getDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        Connector dd = this.deploymentDescriptor;
        if (dd == null && this.canLazyInitialize()) {
            try {
                this.getImportStrategy().importMetaData();
            }
            catch (Exception e) {
                throw new DeploymentDescriptorLoadException(this.getDeploymentDescriptorUri(), e);
            }
        }
        return this.deploymentDescriptor;
    }

    public Connector basicGetDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public String getDeploymentDescriptorUri() {
        return "META-INF/ra.xml";
    }

    public List getResources() {
        String[] prefixes = new String[]{"META-INF", "WEB-INF"};
        return this.filterFilesWithoutPrefix(prefixes);
    }

    public EObject getStandardDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        return this.getDeploymentDescriptor();
    }

    public boolean isDeploymentDescriptorSet() {
        return this.deploymentDescriptor != null;
    }

    public boolean isRARFile() {
        return true;
    }

    public EObject makeDeploymentDescriptor(XMLResource resource) {
        JcaPackage p = (JcaPackage)EPackage.Registry.INSTANCE.getEPackage("jca.xmi");
        JcaFactory fct = p.getJcaFactory();
        Connector connector = fct.createConnector();
        this.setDeploymentDescriptor(connector);
        resource.getContents().add((Object)connector);
        return connector;
    }

    public void setDeploymentDescriptor(Connector l) {
        this.deploymentDescriptor = l;
        this.replaceRoot(this.getMofResourceMakeIfNecessary(this.getDeploymentDescriptorUri()), (EObject)l);
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 6: {
                    if (this.eContainer != null) {
                        msgs = this.eBasicRemoveFromContainer(msgs);
                    }
                    return this.eBasicSetContainer(otherEnd, 6, msgs);
                }
                case 7: {
                    return ((InternalEList)this.getFiles()).basicAdd((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 6: {
                    return this.eBasicSetContainer(null, 6, msgs);
                }
                case 7: {
                    return ((InternalEList)this.getFiles()).basicRemove((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        block6: {
            if (this.eContainerFeatureID < 0) break block6;
            switch (this.eContainerFeatureID) {
                case 6: {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.jst.j2ee.commonarchivecore.internal.Container");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    return this.eContainer.eInverseRemove((InternalEObject)this, 7, (Class)clazz, msgs);
                }
            }
            return this.eDynamicBasicRemoveFromContainer(msgs);
        }
        return this.eContainer.eInverseRemove((InternalEObject)this, -1 - this.eContainerFeatureID, null, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getURI();
            }
            case 1: {
                return new Long(this.getLastModified());
            }
            case 2: {
                return new Long(this.getSize());
            }
            case 3: {
                return this.isDirectoryEntry() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return this.getOriginalURI();
            }
            case 5: {
                if (resolve) {
                    return this.getLoadingContainer();
                }
                return this.basicGetLoadingContainer();
            }
            case 6: {
                return this.getContainer();
            }
            case 7: {
                return this.getFiles();
            }
            case 8: {
                return this.getTypes();
            }
            case 9: {
                if (resolve) {
                    return this.getDeploymentDescriptor();
                }
                return this.basicGetDeploymentDescriptor();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return URI_EDEFAULT == null ? this.uri != null : !URI_EDEFAULT.equals(this.uri);
            }
            case 1: {
                return this.isSetLastModified();
            }
            case 2: {
                return this.isSetSize();
            }
            case 3: {
                return this.isSetDirectoryEntry();
            }
            case 4: {
                return ORIGINAL_URI_EDEFAULT == null ? this.originalURI != null : !ORIGINAL_URI_EDEFAULT.equals(this.originalURI);
            }
            case 5: {
                return this.loadingContainer != null;
            }
            case 6: {
                return this.getContainer() != null;
            }
            case 7: {
                return this.files != null && !this.files.isEmpty();
            }
            case 8: {
                return this.types != null && !this.types.isEmpty();
            }
            case 9: {
                return this.deploymentDescriptor != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setURI((String)newValue);
                return;
            }
            case 1: {
                this.setLastModified((Long)newValue);
                return;
            }
            case 2: {
                this.setSize((Long)newValue);
                return;
            }
            case 3: {
                this.setDirectoryEntry((Boolean)newValue);
                return;
            }
            case 4: {
                this.setOriginalURI((String)newValue);
                return;
            }
            case 5: {
                this.setLoadingContainer((Container)newValue);
                return;
            }
            case 6: {
                this.setContainer((Container)newValue);
                return;
            }
            case 7: {
                this.getFiles().clear();
                this.getFiles().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.getTypes().clear();
                this.getTypes().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.setDeploymentDescriptor((Connector)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setURI(URI_EDEFAULT);
                return;
            }
            case 1: {
                this.unsetLastModified();
                return;
            }
            case 2: {
                this.unsetSize();
                return;
            }
            case 3: {
                this.unsetDirectoryEntry();
                return;
            }
            case 4: {
                this.setOriginalURI(ORIGINAL_URI_EDEFAULT);
                return;
            }
            case 5: {
                this.setLoadingContainer(null);
                return;
            }
            case 6: {
                this.setContainer(null);
                return;
            }
            case 7: {
                this.getFiles().clear();
                return;
            }
            case 8: {
                this.getTypes().clear();
                return;
            }
            case 9: {
                this.setDeploymentDescriptor(null);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public ClassLoader createDynamicClassLoader(ClassLoader parentCl, ClassLoader extraCl) {
        return new RarFileDynamicClassLoader(this, parentCl, extraCl);
    }
}

