/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.actions;

import java.util.ResourceBundle;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.SourceEditingRuntimeException;
import org.eclipse.wst.xml.core.internal.document.CommentImpl;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.actions.CommentActionXML;

public class AddBlockCommentActionXML
extends CommentActionXML {
    protected int fCloseCommentOffset;
    protected int fOpenCommentOffset;
    protected IndexedRegion fSelectionEndIndexedRegion;
    protected IndexedRegion fSelectionStartIndexedRegion;

    public AddBlockCommentActionXML(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    protected void init() {
        super.init();
        this.fSelectionStartIndexedRegion = this.fModel.getIndexedRegion(this.fSelectionStartOffset);
        this.fSelectionEndIndexedRegion = this.fModel.getIndexedRegion(this.fSelectionEndOffset);
        if (this.fSelectionStartIndexedRegion == null || this.fSelectionEndIndexedRegion == null) {
            return;
        }
        this.fOpenCommentOffset = this.fSelectionStartIndexedRegion.getStartOffset();
        this.fCloseCommentOffset = this.fSelectionEndIndexedRegion.getEndOffset() + "<!--".length();
    }

    protected void processAction() {
        if (this.fSelection.getLength() == 0 && this.fSelectionStartIndexedRegion instanceof CommentImpl) {
            return;
        }
        this.fModel.beginRecording((Object)this, XMLUIMessages.AddBlockComment_tooltip);
        this.fModel.aboutToChangeModel();
        try {
            this.fDocument.replace(this.fOpenCommentOffset, 0, "<!--");
            this.fDocument.replace(this.fCloseCommentOffset, 0, "-->");
            this.removeOpenCloseComments(this.fOpenCommentOffset + "<!--".length(), this.fCloseCommentOffset - this.fOpenCommentOffset - "-->".length());
        }
        catch (BadLocationException badLocationException) {
            throw new SourceEditingRuntimeException();
        }
        this.fModel.changedModel();
        this.fModel.endRecording((Object)this);
    }
}

