/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.actions;

import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;

public class MenuBuilder {
    protected Comparator comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return Collator.getInstance().compare(this.getSortKey(o1), this.getSortKey(o2));
        }

        protected String getSortKey(Object o) {
            String result = "";
            if (o instanceof IAction) {
                IAction action = (IAction)o;
                result = action.getText();
            }
            return result;
        }
    };

    protected void createAlphebeticalGrouping(IMenuManager menu, List actionList) {
        Object[] array = actionList.toArray();
        if (array.length > 0) {
            Arrays.sort(array, this.comparator);
        }
        int groupSize = 15;
        int minGroupSize = 5;
        int numberOfGroups = array.length / groupSize + (array.length % groupSize > minGroupSize ? 1 : 0);
        int i = 0;
        while (i < numberOfGroups) {
            boolean isLastGroup = i == numberOfGroups - 1;
            int firstIndex = i * groupSize;
            int lastIndex = isLastGroup ? array.length - 1 : i * groupSize + groupSize - 1;
            Action firstAction = (Action)array[firstIndex];
            Action lastAction = (Action)array[lastIndex];
            MenuManager submenu = new MenuManager(String.valueOf(firstAction.getText()) + " - " + lastAction.getText());
            menu.add((IContributionItem)submenu);
            int j = firstIndex;
            while (j <= lastIndex) {
                submenu.add((IAction)((Action)array[j]));
                ++j;
            }
            ++i;
        }
    }

    public void populateMenu(IMenuManager menu, List actionList, boolean createTiered) {
        if (actionList.size() < 25) {
            Object[] array = actionList.toArray();
            if (array.length > 0) {
                Arrays.sort(array, this.comparator);
            }
            int i = 0;
            while (i < array.length) {
                menu.add((IAction)((Action)array[i]));
                ++i;
            }
        } else {
            this.createAlphebeticalGrouping(menu, actionList);
        }
    }
}

