/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.tests.ext;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import junit.framework.Test;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.server.core.IProjectProperties;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.Runtime;
import org.eclipse.wst.server.core.tests.OrderedTestSuite;

public abstract class AbstractRuntimeTestCase
extends TestCase {
    protected static IProject project;
    protected static IProjectProperties props;
    protected static IRuntime runtime;
    protected static IRuntimeWorkingCopy runtimeWC;
    private static final PropertyChangeListener pcl;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        pcl = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent arg0) {
            }
        };
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.tests.ext.AbstractRuntimeTestCase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new OrderedTestSuite(clazz, "AbstractRuntimeTestCase");
    }

    protected IRuntime getRuntime() throws Exception {
        if (runtime == null) {
            runtime = this.createRuntime();
        }
        return runtime;
    }

    public abstract IRuntime createRuntime() throws Exception;

    public abstract void deleteRuntime(IRuntime var1) throws Exception;

    public void test0000GetProperties() throws Exception {
        project = ResourcesPlugin.getWorkspace().getRoot().getProject("test");
        if (project != null && !project.exists()) {
            project.create(null);
            project.open(null);
        }
        props = ServerCore.getProjectProperties((IProject)project);
    }

    public void test0001GetRuntime() throws Exception {
        AbstractRuntimeTestCase.assertNull((Object)props.getRuntimeTarget());
    }

    public void test0002SetRuntime() throws Exception {
        props.setRuntimeTarget(this.getRuntime(), null);
        AbstractRuntimeTestCase.assertEquals((Object)props.getRuntimeTarget(), (Object)this.getRuntime());
    }

    public void test0003UnsetRuntime() throws Exception {
        props.setRuntimeTarget(null, null);
        AbstractRuntimeTestCase.assertNull((Object)props.getRuntimeTarget());
    }

    public void test0004End() throws Exception {
        project.delete(true, true, null);
    }

    public void test0005Delegate() throws Exception {
        IRuntime iRuntime = this.getRuntime();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.server.core.model.RuntimeDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iRuntime.getAdapter((Class)clazz);
    }

    public void test0005bDelegate() throws Exception {
        IRuntime iRuntime = this.getRuntime();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.server.core.model.RuntimeDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        iRuntime.loadAdapter((Class)clazz, null);
    }

    public void test0006Validate() throws Exception {
        IStatus status = this.getRuntime().validate(null);
        AbstractRuntimeTestCase.assertTrue((status.isOK() || status.getSeverity() == 2 ? 1 : 0) != 0);
    }

    public void test0007Validate() throws Exception {
        IRuntimeWorkingCopy wc = this.getRuntime().createWorkingCopy();
        wc.setLocation(null);
        IStatus status = wc.validate(null);
        AbstractRuntimeTestCase.assertTrue((!status.isOK() ? 1 : 0) != 0);
    }

    public void test0008ModifyRuntime() throws Exception {
        IRuntimeWorkingCopy wc = this.getRuntime().createWorkingCopy();
        String name = wc.getName();
        wc.setName(String.valueOf(name) + "x");
        wc.setName(name);
        wc.save(false, null);
    }

    public void test0009IsPrivate() {
        ((Runtime)runtime).isPrivate();
    }

    public void test0010IsReadOnly() {
        runtime.isReadOnly();
    }

    public void test0012GetTimestamp() {
        ((Runtime)runtime).getTimestamp();
    }

    public void test0013GetRuntimeType() {
        AbstractRuntimeTestCase.assertNotNull((Object)runtime.getRuntimeType());
    }

    public void test0014GetLocation() {
        AbstractRuntimeTestCase.assertNotNull((Object)runtime.getLocation());
    }

    public void test0015IsStub() {
        runtime.isStub();
    }

    public void test0016CreateWorkingCopy() {
        runtimeWC = runtime.createWorkingCopy();
    }

    public void test0017IsDirty() {
        AbstractRuntimeTestCase.assertFalse((boolean)runtimeWC.isDirty());
    }

    public void test0018SetReadOnly() {
        runtimeWC.setReadOnly(true);
        runtimeWC.setReadOnly(false);
    }

    public void test0019SetStub() {
        runtimeWC.setStub(true);
        runtimeWC.setStub(false);
    }

    public void test0019IsDirty() {
        AbstractRuntimeTestCase.assertTrue((boolean)runtimeWC.isDirty());
    }

    public void test0020AddPropertyChangeListener() {
        runtimeWC.addPropertyChangeListener(pcl);
    }

    public void test0020RemovePropertyChangeListener() {
        runtimeWC.removePropertyChangeListener(pcl);
    }

    public void test0021Clear() {
        runtimeWC = null;
    }

    public void test1001Delete() throws Exception {
        this.deleteRuntime(this.getRuntime());
        runtime = null;
    }
}

