/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.formatter;

import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.cleanup.CSSCleanupStrategy;
import org.eclipse.wst.css.core.internal.formatter.AttrChangeContext;
import org.eclipse.wst.css.core.internal.formatter.CompoundRegion;
import org.eclipse.wst.css.core.internal.formatter.DefaultCSSSourceFormatter;
import org.eclipse.wst.css.core.internal.formatter.FormatRegion;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSAttr;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.util.RegionIterator;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.w3c.dom.stylesheets.MediaList;

public class MediaListFormatter
extends DefaultCSSSourceFormatter {
    private static MediaListFormatter instance;

    MediaListFormatter() {
    }

    public StringBuffer formatAttrChanged(ICSSNode node, ICSSAttr attr, boolean insert, AttrChangeContext context) {
        StringBuffer buf = new StringBuffer();
        if (node == null || attr == null) {
            return buf;
        }
        boolean first = false;
        boolean last = false;
        if (context != null && ((IndexedRegion)node).getEndOffset() > 0) {
            if (attr != null && ((IndexedRegion)attr).getEndOffset() > 0) {
                IStructuredDocumentRegion flatNode = node.getOwnerDocument().getModel().getStructuredDocument().getRegionAtCharacterOffset(((IndexedRegion)attr).getStartOffset());
                ITextRegion region = flatNode.getRegionAtCharacterOffset(((IndexedRegion)attr).getStartOffset());
                RegionIterator it = new RegionIterator(flatNode, region);
                it.prev();
                context.start = it.getStructuredDocumentRegion().getStartOffset(region);
                while (it.hasPrev()) {
                    ITextRegion prev = it.prev();
                    if (prev.getType() != "S" && prev.getType() != "MEDIA_SEPARATOR" && prev.getType() != "COMMENT") break;
                    context.start = it.getStructuredDocumentRegion().getStartOffset(prev);
                }
                if (context.start < ((IndexedRegion)node).getStartOffset()) {
                    context.start = ((IndexedRegion)node).getStartOffset();
                    first = true;
                }
                it.reset(flatNode, region);
                context.end = it.getStructuredDocumentRegion().getEndOffset(region);
                while (it.hasNext()) {
                    ITextRegion next = it.next();
                    if (next.getType() != "S" && next.getType() != "MEDIA_SEPARATOR" && next.getType() != "COMMENT") break;
                    context.end = it.getStructuredDocumentRegion().getEndOffset(next);
                }
                if (((IndexedRegion)node).getEndOffset() < context.end) {
                    context.end = ((IndexedRegion)node).getEndOffset();
                    last = true;
                }
            } else {
                last = true;
                IStructuredDocumentRegion flatNode = node.getOwnerDocument().getModel().getStructuredDocument().getRegionAtCharacterOffset(((IndexedRegion)node).getEndOffset() - 1);
                ITextRegion region = flatNode.getRegionAtCharacterOffset(((IndexedRegion)node).getEndOffset() - 1);
                RegionIterator it = new RegionIterator(flatNode, region);
                context.start = it.getStructuredDocumentRegion().getEndOffset(region);
                context.end = it.getStructuredDocumentRegion().getEndOffset(region);
                while (it.hasPrev()) {
                    ITextRegion prev = it.prev();
                    if (prev.getType() != "S" && prev.getType() != "MEDIA_SEPARATOR" && prev.getType() != "COMMENT") break;
                    context.start = it.getStructuredDocumentRegion().getStartOffset(prev);
                }
                if (context.start < ((IndexedRegion)node).getStartOffset()) {
                    context.start = ((IndexedRegion)node).getStartOffset();
                    first = true;
                }
            }
        }
        if (insert && attr.getValue() != null && attr.getValue().length() > 0) {
            if (!first) {
                buf.append(",");
            }
            this.appendSpaceBefore(node, attr.getValue(), buf);
            buf.append(attr.getValue());
            if (!last) {
                buf.append(",");
                this.appendSpaceBefore(node, "", buf);
            }
        } else if (!first && !last) {
            buf.append(",");
            this.appendSpaceBefore(node, "", buf);
        }
        return buf;
    }

    protected void formatPre(ICSSNode node, StringBuffer source) {
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        int start = ((IndexedRegion)node).getStartOffset();
        int end = ((IndexedRegion)node).getEndOffset();
        if (end > 0) {
            IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
            CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, new FormatRegion(start, end - start), stgy);
            int i = 0;
            while (i < regions.length) {
                if (i != 0) {
                    this.appendSpaceBefore(node, regions[i], source);
                }
                source.append(this.decoratedIdentRegion(regions[i], stgy));
                ++i;
            }
        } else {
            MediaList list = (MediaList)((Object)node);
            int n = list.getLength();
            int i = 0;
            while (i < n) {
                String medium = list.item(i);
                medium = CSSCorePlugin.getDefault().getPluginPreferences().getInt("identifierCase") == 2 ? medium.toUpperCase() : medium.toLowerCase();
                if (i != 0) {
                    source.append(",");
                    this.appendSpaceBefore(node, medium, source);
                }
                source.append(medium);
                ++i;
            }
        }
    }

    protected void formatPre(ICSSNode node, IRegion region, StringBuffer source) {
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
        CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, region, stgy);
        CompoundRegion[] outside = this.getOutsideRegions(structuredDocument, region);
        int i = 0;
        while (i < regions.length) {
            if (i != 0 || MediaListFormatter.needS(outside[0])) {
                this.appendSpaceBefore(node, regions[i], source);
            }
            source.append(this.decoratedIdentRegion(regions[i], stgy));
            ++i;
        }
        if (MediaListFormatter.needS(outside[1]) && !this.isIncludesPreEnd(node, region)) {
            this.appendSpaceBefore(node, outside[1], source);
        }
    }

    public int getAttrInsertPos(ICSSNode node, String attrName) {
        if (node == null || attrName == null || attrName.length() == 0) {
            return -1;
        }
        ICSSAttr attr = (ICSSAttr)node.getAttributes().getNamedItem(attrName);
        if (attr != null && ((IndexedRegion)attr).getEndOffset() > 0) {
            return ((IndexedRegion)attr).getStartOffset();
        }
        IndexedRegion iNode = (IndexedRegion)node;
        if (iNode.getEndOffset() <= 0) {
            return -1;
        }
        return iNode.getEndOffset();
    }

    public static synchronized MediaListFormatter getInstance() {
        if (instance == null) {
            instance = new MediaListFormatter();
        }
        return instance;
    }
}

