/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.validation.sample.parser;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class ResourceHandler {
    private static ResourceBundle _bundle = null;

    private ResourceHandler() {
    }

    private static ResourceBundle getBundle(String bundleName) {
        if (_bundle == null) {
            try {
                _bundle = ResourceBundle.getBundle(bundleName);
            }
            catch (MissingResourceException exc) {
                _bundle = null;
                exc.printStackTrace();
            }
        }
        return _bundle;
    }

    public static String getExternalizedMessage(String bundleName, String key) {
        try {
            ResourceBundle bundle = ResourceHandler.getBundle(bundleName);
            if (bundle == null) {
                return key;
            }
            return bundle.getString(key);
        }
        catch (NullPointerException exc) {
            exc.printStackTrace();
            return key;
        }
    }

    public static String getExternalizedMessage(String bundleName, String key, String[] parms) {
        String res = "";
        try {
            res = MessageFormat.format(ResourceHandler.getExternalizedMessage(bundleName, key), parms);
        }
        catch (MissingResourceException exc) {
            exc.printStackTrace();
        }
        catch (NullPointerException exc) {
            exc.printStackTrace();
        }
        return res;
    }
}

