/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.consumption.ui.task;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.jst.ws.internal.axis.consumption.ui.task.Stub2BeanInfo;
import org.eclipse.jst.ws.internal.axis.consumption.ui.util.WSDLUtils;
import org.eclipse.wst.command.internal.provisional.env.core.SimpleCommand;
import org.eclipse.wst.command.internal.provisional.env.core.common.Environment;
import org.eclipse.wst.command.internal.provisional.env.core.common.SimpleStatus;
import org.eclipse.wst.command.internal.provisional.env.core.common.Status;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class Stub2BeanCommand
extends SimpleCommand {
    private WebServicesParser webServicesParser;
    private JavaWSDLParameter javaWSDLParam_;
    private String discoveredWsdlPortElementName;
    private Vector portTypes_;
    private String proxyBean_;
    private String module_ = "";
    private IProject clientProject_;
    private final char UNDERSCORE = (char)95;

    public Stub2BeanCommand() {
        super("org.eclipse.jst.ws.was.creation.ui.task.Stub2BeanCommand", "org.eclipse.jst.ws.was.creation.ui.task.Stub2BeanCommand");
        this.portTypes_ = new Vector();
    }

    public Stub2BeanCommand(String moduleName) {
        super("org.eclipse.jst.ws.was.creation.ui.task.Stub2BeanCommand", "org.eclipse.jst.ws.was.creation.ui.task.Stub2BeanCommand");
        this.portTypes_ = new Vector();
        this.module_ = moduleName;
    }

    public Status execute(Environment env) {
        File file;
        String inputWsdlLocation = this.javaWSDLParam_.getInputWsdlLocation();
        Definition def = this.webServicesParser.getWSDLDefinition(inputWsdlLocation);
        if (def == null && (file = new File(inputWsdlLocation)).exists()) {
            try {
                def = this.webServicesParser.getWSDLDefinition(file.toURL().toString());
            }
            catch (MalformedURLException malformedURLException) {}
        }
        HashMap pkg2nsMapping = this.javaWSDLParam_.getMappings();
        Map services = def.getServices();
        Iterator it = services.values().iterator();
        while (it.hasNext()) {
            String serviceClassName;
            Service service = (Service)it.next();
            String servicePkgName = WSDLUtils.getPackageName(service, (Map)pkg2nsMapping);
            String jndiName = serviceClassName = this.computeClassName(service.getQName().getLocalPart());
            Map ports = service.getPorts();
            Iterator it2 = ports.values().iterator();
            while (it2.hasNext()) {
                if (!serviceClassName.equals(this.computeClassName(((Port)it2.next()).getBinding().getPortType().getQName().getLocalPart()))) continue;
                serviceClassName = String.valueOf(serviceClassName) + "_Service";
                break;
            }
            it2 = ports.values().iterator();
            while (it2.hasNext()) {
                Port port = (Port)it2.next();
                if (this.discoveredWsdlPortElementName != null && !this.discoveredWsdlPortElementName.equals(port.getName())) continue;
                SOAPAddress soapAddress = null;
                List extensibilityElements = port.getExtensibilityElements();
                if (extensibilityElements != null) {
                    Iterator it3 = extensibilityElements.iterator();
                    while (it3.hasNext()) {
                        Object object = it3.next();
                        if (!(object instanceof SOAPAddress)) continue;
                        soapAddress = (SOAPAddress)object;
                        break;
                    }
                }
                if (soapAddress == null) continue;
                PortType portType = port.getBinding().getPortType();
                QName portTypeQName = portType.getQName();
                StringBuffer portTypeID = new StringBuffer();
                portTypeID.append(portTypeQName.getNamespaceURI());
                portTypeID.append("#");
                portTypeID.append(portTypeQName.getLocalPart());
                if (this.portTypes_.contains(portTypeID.toString())) continue;
                this.portTypes_.add(portTypeID.toString());
                Stub2BeanInfo stub2BeanInfo = new Stub2BeanInfo();
                stub2BeanInfo.setClientProject(this.clientProject_);
                stub2BeanInfo.setClientModuleName(this.module_);
                String portTypePkgName = WSDLUtils.getPackageName(portType, (Map)pkg2nsMapping);
                String portTypeClassName = this.computeClassName(portTypeQName.getLocalPart());
                stub2BeanInfo.setPackage(portTypePkgName);
                stub2BeanInfo.setClass(String.valueOf(portTypeClassName) + "Proxy");
                this.proxyBean_ = String.valueOf(portTypePkgName) + "." + portTypeClassName + "Proxy";
                if (jndiName.equals(portTypeClassName)) {
                    portTypeClassName = String.valueOf(portTypeClassName) + "_PortType";
                }
                stub2BeanInfo.addSEI(portTypePkgName, portTypeClassName, servicePkgName, serviceClassName, jndiName, port.getName());
                try {
                    stub2BeanInfo.write(env.getProgressMonitor(), env.getStatusHandler());
                    if (this.discoveredWsdlPortElementName == null) continue;
                    return new SimpleStatus("");
                }
                catch (CoreException coreException) {
                }
                catch (IOException iOException) {}
            }
        }
        return new SimpleStatus("");
    }

    private String computeClassName(String className) {
        String classNameCopy = className;
        int i = classNameCopy.indexOf(95);
        while (i != -1) {
            char c = classNameCopy.charAt(i + 1);
            if (Character.isLowerCase(c)) {
                StringBuffer sb = new StringBuffer();
                sb.append(classNameCopy.substring(0, i + 1));
                sb.append(Character.toUpperCase(c));
                sb.append(classNameCopy.substring(i + 2, classNameCopy.length()));
                classNameCopy = sb.toString();
            }
            i = classNameCopy.indexOf(95, i + 1);
        }
        char[] cArray = new char[classNameCopy.length()];
        boolean foundDigit = false;
        int j = 0;
        while (j < cArray.length) {
            char c = classNameCopy.charAt(j);
            if (Character.isDigit(c)) {
                cArray[j] = c;
                foundDigit = true;
            } else {
                cArray[j] = foundDigit ? Character.toUpperCase(c) : c;
                foundDigit = false;
            }
            ++j;
        }
        return new String(cArray);
    }

    public JavaWSDLParameter getJavaWSDLParam() {
        return this.javaWSDLParam_;
    }

    public void setJavaWSDLParam(JavaWSDLParameter javaWSDLParam) {
        this.javaWSDLParam_ = javaWSDLParam;
    }

    public WebServicesParser getWebServicesParser() {
        return this.webServicesParser;
    }

    public void setWebServicesParser(WebServicesParser webServicesParser) {
        this.webServicesParser = webServicesParser;
    }

    public void setDiscoveredWsdlPortElementName(String discoveredWsdlPortElementName) {
        this.discoveredWsdlPortElementName = discoveredWsdlPortElementName;
    }

    public void setClientProject(IProject clientProject) {
        this.clientProject_ = clientProject;
    }

    public String getProxyBean() {
        return this.proxyBean_;
    }
}

