/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.tests;

import java.io.File;
import java.io.FileFilter;
import java.io.OutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.internal.impl.DefinitionImpl;
import org.eclipse.wst.wsdl.internal.util.WSDLResourceFactoryImpl;
import org.eclipse.wst.wsdl.tests.WSDLTestsPlugin;
import org.eclipse.wst.wsdl.tests.util.DefinitionLoader;
import org.eclipse.wst.wsdl.tests.util.XMLDiff;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.w3c.dom.Element;

public class LoadAndSerializationTest
extends TestCase {
    private String PLUGIN_ABSOLUTE_PATH;
    private static File[] wsdls;
    private static Definition definition;

    static {
        definition = null;
    }

    public static void main(String[] args) {
        TestRunner.run((Test)LoadAndSerializationTest.suite());
    }

    public LoadAndSerializationTest(String name) {
        super(name);
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("wsdl", new WSDLResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
        this.PLUGIN_ABSOLUTE_PATH = WSDLTestsPlugin.getInstallURL();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new LoadAndSerializationTest("LoadAndStore"){

            protected void runTest() {
                this.testLoadAndStore();
            }
        });
        return suite;
    }

    public void testLoadAndStore() {
        File dir = new File(String.valueOf(this.PLUGIN_ABSOLUTE_PATH) + "samples");
        if (dir.exists() && dir.isDirectory()) {
            wsdls = dir.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().endsWith(".wsdl");
                }
            });
            try {
                int i = 0;
                while (i < wsdls.length) {
                    System.out.println(wsdls[i].toURL().toString());
                    this.load(wsdls[i].toString());
                    this.print(String.valueOf(wsdls[i].toString()) + ".out");
                    ++i;
                }
            }
            catch (Exception e) {
                Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
            }
        } else {
            LoadAndSerializationTest.fail((String)dir.toString());
        }
    }

    private void load(String filename) {
        try {
            definition = DefinitionLoader.load(filename);
            Assert.assertNotNull((Object)definition);
            Assert.assertTrue((boolean)(definition.eResource() instanceof WSDLResourceImpl));
            WSDLResourceImpl wsdlResource = (WSDLResourceImpl)definition.eResource();
            Assert.assertNotNull((Object)wsdlResource);
            Element element = definition.getElement();
            Assert.assertNotNull((Object)definition.getElement());
            WSDLResourceImpl.serialize((OutputStream)System.out, (Element)element);
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }

    private void print(String filename) {
        try {
            definition.setDocument(null);
            definition.setElement(null);
            ((DefinitionImpl)definition).updateElement();
            DefinitionLoader.store(definition, filename);
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }

    public void testCompare() {
        XMLDiff xmldiff = new XMLDiff();
        try {
            int i = 0;
            while (i < wsdls.length) {
                Assert.assertTrue((boolean)xmldiff.diff(wsdls[i].toString(), String.valueOf(wsdls[i].toString()) + ".out"));
                ++i;
            }
        }
        catch (Exception e) {
            Assert.fail((String)("Test failed due to an exception: " + e.getLocalizedMessage()));
        }
    }
}

