/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ejb.project;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jst.common.jdt.internal.integration.WorkingCopyProvider;
import org.eclipse.jst.j2ee.ejb.EJBResource;
import org.eclipse.jst.j2ee.internal.J2EEConstants;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.internal.ejb.project.AbstractEJBEditModel;
import org.eclipse.jst.j2ee.webservice.wsclient.WebServicesResource;
import org.eclipse.wst.common.internal.emf.resource.ReferencedResource;
import org.eclipse.wst.common.internal.emf.utilities.Revisit;
import org.eclipse.wst.common.internal.emfworkbench.EMFWorkbenchContext;

public class EJBEditModel
extends AbstractEJBEditModel
implements WorkingCopyProvider {
    private boolean batchMode = false;

    public EJBEditModel(String editModelID, EMFWorkbenchContext context, boolean readOnly) {
        super(editModelID, context, readOnly);
    }

    public EJBEditModel(String editModelID, EMFWorkbenchContext context, boolean readOnly, boolean accessUnkownResourcesAsReadOnly) {
        super(editModelID, context, readOnly, accessUnkownResourcesAsReadOnly);
    }

    public void delete(ICompilationUnit cu, IProgressMonitor monitor) {
        this.getWorkingCopyManager().delete(cu, monitor);
    }

    public void dispose() {
        super.dispose();
        this.resetWorkingCopyManager();
    }

    public Set getAffectedFiles() {
        Set affected = super.getAffectedFiles();
        if (this.getWorkingCopyManager() != null) {
            affected.addAll(this.getWorkingCopyManager().getAffectedFiles());
        }
        return affected;
    }

    public ICompilationUnit getExistingWorkingCopy(ICompilationUnit cu) throws CoreException {
        return this.getWorkingCopyManager().getExistingWorkingCopy(cu);
    }

    public ICompilationUnit getWorkingCopy(ICompilationUnit cu, boolean forNewCU) throws CoreException {
        return this.getWorkingCopyManager().getWorkingCopy(cu, forNewCU);
    }

    protected void handleSaveIfNecessaryDidNotSave(IProgressMonitor monitor) {
        this.getWorkingCopyManager().saveOnlyNewCompilationUnits(monitor);
    }

    public void processResource(Resource aResource) {
        if (aResource != null && !this.getResources().contains(aResource)) {
            if (aResource instanceof ReferencedResource) {
                this.access((ReferencedResource)aResource);
                if (!this.isReadOnly() && aResource instanceof EJBResource) {
                    this.access((ReferencedResource)aResource);
                }
                Revisit.revisit();
                ((ReferencedResource)aResource).setFormat(1);
            } else if (!this.isReadOnly()) {
                aResource.setTrackingModification(true);
            }
            this.addResource(aResource);
        }
    }

    protected void release(Resource aResource) {
        this.removeResource(aResource);
        if (aResource != null) {
            boolean isRefRes = aResource instanceof ReferencedResource;
            if (isRefRes) {
                super.release((ReferencedResource)aResource);
            }
            if (!this.isReadOnly() && aResource instanceof EJBResource) {
                if (isRefRes) {
                    ((ReferencedResource)aResource).releaseFromWrite();
                }
                if (!this.isDisposing()) {
                    this.resetWorkingCopyManager();
                }
            }
        }
    }

    public void primSave(IProgressMonitor monitor) {
        this.saveCompilationUnits(monitor);
        if (monitor == null || !monitor.isCanceled()) {
            super.primSave(monitor);
        }
    }

    public void saveCompilationUnits(IProgressMonitor monitor) {
        this.getWorkingCopyManager().saveCompilationUnits(monitor);
    }

    public void saveIfNecessary(Object accessorKey) {
        if (!this.getBatchMode()) {
            super.saveIfNecessary(accessorKey);
        }
    }

    public boolean getBatchMode() {
        return this.batchMode;
    }

    public void setBatchMode(boolean isBatch) {
        this.batchMode = isBatch;
        EJBResource res = null;
        res = this.getEjbXmiResource();
        if (res != null) {
            res.setBatchMode(isBatch);
        }
    }

    public XMLResource getDeploymentDescriptorResource() {
        return this.getEjbXmiResource();
    }

    protected void reverted(ReferencedResource revertedResource) {
        if (this.getWorkingCopyManager() != null) {
            this.getWorkingCopyManager().revert();
        }
        this.revertAllResources();
    }

    public boolean isDirty() {
        boolean dirtyBool = super.isDirty();
        if (!dirtyBool && this.getWorkingCopyManager() != null) {
            dirtyBool = this.getWorkingCopyManager().hasWorkingCopies();
        }
        return dirtyBool;
    }

    protected void resourceIsLoadedChanged(Resource aResource, boolean oldValue, boolean newValue) {
        if (!this.isReverting && !this.disposing && !this.isReadOnly() && oldValue && !newValue && aResource instanceof EJBResource) {
            this.resetWorkingCopyManager();
        }
        super.resourceIsLoadedChanged(aResource, oldValue, newValue);
    }

    public Object getRootObject() {
        return this.getEJBJar();
    }

    public WebServicesResource get13WebServicesClientResource() {
        return (WebServicesResource)this.getResource(J2EEConstants.WEB_SERVICES_CLIENT_META_INF_DD_URI_OBJ);
    }

    public String getDevelopmentAcivityID() {
        return "com.ibm.wtp.ejb.development";
    }
}

