/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.internal.validation;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.html.core.internal.validate.HTMLValidationAdapterFactory;
import org.eclipse.wst.html.internal.validation.HTMLValidationReporter;
import org.eclipse.wst.html.internal.validation.HTMLValidationResult;
import org.eclipse.wst.html.internal.validation.LocalizedMessage;
import org.eclipse.wst.html.ui.internal.HTMLUIMessages;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.util.URIResolver;
import org.eclipse.wst.sse.core.internal.validate.ValidationAdapter;
import org.eclipse.wst.sse.core.internal.validate.ValidationReporter;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.operations.WorkbenchReporter;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class HTMLValidator
implements IValidator {
    static /* synthetic */ Class class$0;

    static boolean shouldValidate(IFile file) {
        IFile resource = file;
        do {
            if (!resource.isDerived() && !resource.isTeamPrivateMember() && resource.isAccessible() && (resource.getName().charAt(0) != '.' || resource.getType() != 2)) continue;
            return false;
        } while (((resource = resource.getParent()).getType() & 4) == 0);
        return true;
    }

    public void cleanup(IReporter reporter) {
    }

    protected IDOMModel getModel(IProject project, IFile file) {
        if (project == null || file == null) {
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        if (!this.canHandle(file)) {
            return null;
        }
        IStructuredModel model = null;
        IModelManager manager = StructuredModelManager.getModelManager();
        try {
            try {
                model = manager.getModelForRead(file);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                model = manager.getModelForRead(file, new String(), null);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (IOException iOException) {
        }
        catch (CoreException coreException) {}
        if (model == null) {
            return null;
        }
        if (!(model instanceof IDOMModel)) {
            this.releaseModel(model);
            return null;
        }
        return (IDOMModel)model;
    }

    protected HTMLValidationReporter getReporter(IReporter reporter, IFile file, IDOMModel model) {
        return new HTMLValidationReporter(this, reporter, file, (IStructuredModel)model);
    }

    private boolean canHandle(IFile file) {
        if (file == null) {
            return false;
        }
        String name = file.getFullPath().toString();
        if (name == null) {
            return false;
        }
        int index = name.lastIndexOf(46);
        if (index < 0) {
            return false;
        }
        String ext = name.substring(index + 1);
        if (ext == null || ext.length() == 0) {
            return false;
        }
        return (ext = ext.toLowerCase()).startsWith("htm") || ext.startsWith("jsp") || ext.equals("jsf") || ext.startsWith("xht") || ext.startsWith("shtm") || ext.startsWith("wml") || ext.equals("jhtml");
    }

    private boolean hasHTMLFeature(IDOMDocument document) {
        DocumentTypeAdapter adapter;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (DocumentTypeAdapter)document.getAdapterFor((Object)clazz)) == null) {
            return false;
        }
        return adapter.hasFeature("HTML");
    }

    protected void releaseModel(IStructuredModel model) {
        if (model != null) {
            model.releaseFromRead();
        }
    }

    public void validate(IValidationContext helper, IReporter reporter) {
        if (helper == null) {
            return;
        }
        if (reporter != null && reporter.isCancelled()) {
            throw new OperationCanceledException();
        }
        String[] deltaArray = helper.getURIs();
        if (deltaArray != null && deltaArray.length > 0) {
            this.validateDelta(helper, reporter);
        } else {
            this.validateFull(helper, reporter);
        }
    }

    protected HTMLValidationResult validate(IDOMModel model, IFile file) {
        URIResolver res;
        IProject prj = null;
        if (file != null) {
            prj = file.getProject();
        }
        if (prj == null && model != null && (res = model.getResolver()) != null) {
            prj = res.getProject();
        }
        WorkbenchReporter reporter = new WorkbenchReporter(prj, (IProgressMonitor)new NullProgressMonitor());
        return this.validate((IReporter)reporter, file, model);
    }

    private HTMLValidationResult validate(IReporter reporter, IFile file, IDOMModel model) {
        if (file == null || model == null) {
            return null;
        }
        IDOMDocument document = model.getDocument();
        if (document == null) {
            return null;
        }
        if (!this.hasHTMLFeature(document)) {
            return null;
        }
        HTMLValidationAdapterFactory factory = HTMLValidationAdapterFactory.getInstance();
        ValidationAdapter adapter = (ValidationAdapter)factory.adapt((INodeNotifier)document);
        if (adapter == null) {
            return null;
        }
        HTMLValidationReporter rep = this.getReporter(reporter, file, model);
        rep.clear();
        adapter.setReporter((ValidationReporter)rep);
        if (reporter != null) {
            Object[] args = new String[]{file.getFullPath().toString()};
            LocalizedMessage mess = new LocalizedMessage(4, NLS.bind((String)HTMLUIMessages.MESSAGE_HTML_VALIDATION_MESSAGE_UI_, (Object[])args));
            mess.setParams((String[])args);
            reporter.displaySubtask((IValidator)this, (IMessage)mess);
        }
        adapter.validate((IndexedRegion)document);
        return rep.getResult();
    }

    private void validateContainer(IValidationContext helper, IReporter reporter, IContainer container) {
        try {
            IResource[] resourceArray = container.members(false);
            int i = 0;
            while (i < resourceArray.length) {
                IResource resource = resourceArray[i];
                if (resource != null) {
                    if (resource instanceof IFile) {
                        this.validateFile(helper, reporter, (IFile)resource);
                    } else if (resource instanceof IContainer) {
                        this.validateContainer(helper, reporter, (IContainer)resource);
                    }
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    private void validateDelta(IValidationContext helper, IReporter reporter) {
        String[] deltaArray = helper.getURIs();
        int i = 0;
        while (i < deltaArray.length) {
            IResource resource;
            String delta = deltaArray[i];
            if (delta != null && (resource = this.getResource(delta)) != null && resource instanceof IFile) {
                this.validateFile(helper, reporter, (IFile)resource);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void validateFile(IValidationContext helper, IReporter reporter, IFile file) {
        if (reporter != null && reporter.isCancelled()) {
            throw new OperationCanceledException();
        }
        if (!HTMLValidator.shouldValidate(file)) {
            return;
        }
        IDOMModel model = this.getModel(file.getProject(), file);
        if (model == null) {
            return;
        }
        try {
            this.validate(reporter, file, model);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.releaseModel((IStructuredModel)model);
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.releaseModel((IStructuredModel)model);
            return;
        }
    }

    private void validateFull(IValidationContext helper, IReporter reporter) {
        IProject project = null;
        String[] fileDelta = helper.getURIs();
        if (helper instanceof IWorkbenchContext) {
            IWorkbenchContext wbHelper = (IWorkbenchContext)helper;
            project = wbHelper.getProject();
        } else {
            project = this.getResource(fileDelta[0]).getProject();
        }
        if (project == null) {
            return;
        }
        this.validateContainer(helper, reporter, (IContainer)project);
    }

    public IResource getResource(String delta) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(delta));
    }
}

