/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.contentassist;

import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.html.ui.internal.HTMLUIPlugin;
import org.eclipse.wst.html.ui.internal.contentassist.CustomTemplateProposal;
import org.eclipse.wst.html.ui.internal.editor.HTMLEditorPluginImageHelper;

class HTMLTemplateCompletionProcessor
extends TemplateCompletionProcessor {
    private String fContextTypeId = null;

    HTMLTemplateCompletionProcessor() {
    }

    protected ICompletionProposal createProposal(Template template, TemplateContext context, IRegion region, int relevance) {
        return new CustomTemplateProposal(template, context, region, this.getImage(template), relevance);
    }

    protected TemplateContextType getContextType(ITextViewer viewer, IRegion region) {
        TemplateContextType type = null;
        ContextTypeRegistry registry = this.getTemplateContextRegistry();
        if (registry != null) {
            type = registry.getContextType(this.fContextTypeId);
        }
        return type;
    }

    protected Image getImage(Template template) {
        return HTMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/tag-template.gif");
    }

    private ContextTypeRegistry getTemplateContextRegistry() {
        return HTMLUIPlugin.getDefault().getTemplateContextRegistry();
    }

    protected Template[] getTemplates(String contextTypeId) {
        Template[] templates = null;
        TemplateStore store = this.getTemplateStore();
        if (store != null) {
            templates = store.getTemplates(contextTypeId);
        }
        return templates;
    }

    private TemplateStore getTemplateStore() {
        return HTMLUIPlugin.getDefault().getTemplateStore();
    }

    void setContextType(String contextTypeId) {
        this.fContextTypeId = contextTypeId;
    }
}

