/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.earcreation;

import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.commonarchivecore.internal.looseconfig.LooseApplication;
import org.eclipse.jst.j2ee.commonarchivecore.internal.looseconfig.LooseArchive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.looseconfig.LooseConfiguration;
import org.eclipse.jst.j2ee.commonarchivecore.internal.looseconfig.LooseLibrary;
import org.eclipse.jst.j2ee.commonarchivecore.internal.looseconfig.LooseModule;
import org.eclipse.jst.j2ee.commonarchivecore.internal.looseconfig.LooseconfigFactory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.looseconfig.LooseconfigPackage;
import org.eclipse.jst.j2ee.internal.earcreation.EARCreationResourceHandler;
import org.eclipse.jst.j2ee.internal.earcreation.EAREditModel;
import org.eclipse.jst.j2ee.internal.earcreation.EARNatureRuntime;
import org.eclipse.jst.j2ee.internal.earcreation.ILooseConfigConstants;
import org.eclipse.jst.j2ee.internal.earcreation.modulemap.ModuleMapping;
import org.eclipse.jst.j2ee.internal.earcreation.modulemap.UtilityJARMapping;
import org.eclipse.jst.j2ee.internal.project.J2EEModuleNature;
import org.eclipse.jst.j2ee.internal.project.J2EENature;
import org.eclipse.wst.common.frameworks.internal.enablement.nonui.WFTWrappedException;
import org.eclipse.wst.common.frameworks.internal.operations.WTPOperation;

public class LooseConfigUpdateOperation
extends WTPOperation
implements ILooseConfigConstants {
    protected Resource resource;
    protected IProgressMonitor monitor;
    protected LooseConfiguration looseConfig;
    protected String uri;
    protected EAREditModel currentEditModel;
    protected static final String UPDATING_MESSAGE = EARCreationResourceHandler.getString("Updating_absolute_paths_UI_");

    protected LooseconfigFactory looseConfigFactory() {
        return ((LooseconfigPackage)EPackage.Registry.INSTANCE.getEPackage("commonarchive.looseconfig.xmi")).getLooseconfigFactory();
    }

    protected void execute(IProgressMonitor progressMonitor) throws CoreException, InvocationTargetException, InterruptedException {
        this.monitor = progressMonitor;
        this.monitor.beginTask(UPDATING_MESSAGE, -1);
        this.initialize();
        this.addLooseApplications();
        this.save();
    }

    protected void initialize() {
        this.resource = Resource.Factory.Registry.INSTANCE.getFactory(URI.createURI((String)CONFIG_PATH)).createResource(URI.createURI((String)CONFIG_PATH));
        this.resource.getContents().add((Object)this.createLooseConfig());
    }

    protected LooseConfiguration createLooseConfig() {
        this.looseConfig = this.looseConfigFactory().createLooseConfiguration();
        return this.looseConfig;
    }

    protected void addLooseApplications() throws CoreException {
        List earProjects = EARNatureRuntime.getAllEARProjectsInWorkbench();
        int i = 0;
        while (i < earProjects.size()) {
            IProject p = (IProject)earProjects.get(i);
            EARNatureRuntime runtime = EARNatureRuntime.getRuntime(p);
            this.addLooseApplication(runtime);
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void addLooseApplication(EARNatureRuntime runtime) throws CoreException {
        this.monitor.subTask(runtime.getProject().getName());
        this.currentEditModel = runtime.getEarEditModelForRead(this);
        try {
            LooseApplication looseApp = this.createLooseApplication(runtime);
            this.addLooseApplication(looseApp);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.currentEditModel.releaseAccess(this);
            this.currentEditModel = null;
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.currentEditModel.releaseAccess(this);
        this.currentEditModel = null;
    }

    protected void addLooseApplication(LooseApplication looseApp) throws CoreException {
        this.addLooseModules(looseApp, this.currentEditModel.getModuleMappings());
        this.addLooseUtilityJARs(looseApp, this.currentEditModel.getUtilityJARMappings());
        this.looseConfig.getApplications().add((Object)looseApp);
    }

    protected LooseApplication createLooseApplication(EARNatureRuntime runtime) {
        LooseApplication looseApp = this.looseConfigFactory().createLooseApplication();
        String absPath = this.getAbsolutePath(runtime);
        looseApp.setUri(absPath);
        this.setPaths((LooseArchive)looseApp, absPath);
        return looseApp;
    }

    protected void addLooseModules(LooseApplication looseApp, List moduleMaps) {
        EList looseModules = looseApp.getLooseArchives();
        int i = 0;
        while (i < moduleMaps.size()) {
            ModuleMapping map = (ModuleMapping)moduleMaps.get(i);
            LooseModule module = this.createLooseModule(map);
            looseModules.add(module);
            ++i;
        }
    }

    protected LooseModule createLooseModule(ModuleMapping map) {
        LooseModule loose = this.looseConfigFactory().createLooseModule();
        loose.setUri(map.getModule().getUri());
        this.setPaths((LooseArchive)loose, this.getAbsolutePath(map));
        return loose;
    }

    protected void setPaths(LooseArchive archive, String absPath) {
        if (absPath == null) {
            return;
        }
        archive.setBinariesPath(absPath);
        archive.setResourcesPath(absPath);
    }

    protected void save() throws InvocationTargetException {
        try {
            ResourceSet set = this.resource.getResourceSet();
            if (set != null) {
                OutputStream out = set.getURIConverter().createOutputStream(this.resource.getURI());
                this.resource.save(out, Collections.EMPTY_MAP);
            }
        }
        catch (Exception ex) {
            throw new WFTWrappedException((Throwable)ex);
        }
    }

    protected String getAbsolutePath(ModuleMapping map) {
        if (map.getProjectName() == null) {
            return null;
        }
        IProject p = this.getProject(map.getProjectName());
        J2EEModuleNature nature = (J2EEModuleNature)J2EENature.getRegisteredRuntime(p);
        return this.getAbsolutePath(nature);
    }

    protected String getAbsolutePath(UtilityJARMapping map) throws CoreException {
        if (map.getProjectName() == null) {
            return null;
        }
        IProject p = this.getProject(map.getProjectName());
        return this.getAbsolutePath(this.getJavaProject(p));
    }

    protected String getAbsolutePath(IJavaProject javaProj) throws CoreException {
        IPath loc = javaProj.getOutputLocation();
        if (loc == null) {
            return null;
        }
        return javaProj.getProject().getFile(loc).getLocation().toOSString();
    }

    protected IProject getProject(String projectName) {
        return this.getWorkspace().getRoot().getProject(projectName);
    }

    protected IJavaModel getJavaModel() {
        return JemProjectUtilities.getJavaModel();
    }

    protected IJavaProject getJavaProject(IProject p) {
        return this.getJavaModel().getJavaProject(p.getName());
    }

    protected String getAbsolutePath(J2EENature nature) {
        if (nature == null) {
            return null;
        }
        return nature.getModuleServerRoot().getLocation().toOSString();
    }

    protected void addLooseUtilityJARs(LooseApplication looseApp, List utilMaps) throws CoreException {
        EList looseArchives = looseApp.getLooseArchives();
        int i = 0;
        while (i < utilMaps.size()) {
            UtilityJARMapping map = (UtilityJARMapping)utilMaps.get(i);
            LooseLibrary lib = this.createLooseLibrary(map);
            looseArchives.add(lib);
            ++i;
        }
    }

    protected LooseLibrary createLooseLibrary(UtilityJARMapping map) throws CoreException {
        LooseLibrary loose = this.looseConfigFactory().createLooseLibrary();
        loose.setUri(map.getUri());
        this.setPaths((LooseArchive)loose, this.getAbsolutePath(map));
        return loose;
    }
}

